CONTAINER VPGPURenderer
{
	NAME VPGPURenderer;

	INCLUDE VPbase;

	GROUP VP_GPURENDERER_PAGE_OFFLINE
	{
		COLUMNS 2;
		LONG VP_GPURENDERER_RENDERMODE_OFFLINE
		{
			ANIM OFF;
			
			CYCLE
			{
				VP_GPURENDERER_RENDERMODE_GLOBAL_ILLUMINATION;
				VP_GPURENDERER_RENDERMODE_DIRECT_ILLUMINATION;
				VP_GPURENDERER_RENDERMODE_AMBIENT_OCCLUSION;
				VP_GPURENDERER_RENDERMODE_WIREFRAME;
				VP_GPURENDERER_RENDERMODE_DIFFUSE;
			}
		}
		STATICTEXT { }

		BOOL VP_GPURENDERER_DEPTH_OF_FIELD_OFFLINE	{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }
		
		LONG VP_GPURENDERER_MOTION_BLUR_TYPE_OFFLINE
		{
			PARENTCOLLAPSE;
			ANIM OFF;
			CYCLE
			{
				VP_GPURENDERER_MOTION_BLUR_TYPE_NONE;
				VP_GPURENDERER_MOTION_BLUR_TYPE_LINEAR;
				VP_GPURENDERER_MOTION_BLUR_TYPE_SFMB;
			}
		}
		STATICTEXT { }

		LONG VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES
		{
			PARENTCOLLAPSE VP_GPURENDERER_MOTION_BLUR_TYPE_OFFLINE;
			ANIM OFF;
			CYCLE
			{
				VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_5;
				VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_9;
				VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_16;
				VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_25;
				VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_36;
				VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_49;
			}
		}
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_MOTION_BLUR_TYPE_OFFLINE; }

		REAL VP_GPURENDERER_MOTION_BLUR_SFMB_DITHERING 	{ PARENTCOLLAPSE VP_GPURENDERER_MOTION_BLUR_TYPE_OFFLINE; UNIT PERCENT; MIN 0; MAX 100; ANIM OFF; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_MOTION_BLUR_TYPE_OFFLINE; }

		LONG VP_GPURENDERER_RECURSION_DEPTH_OFFLINE	{ PARENTCOLLAPSE; MIN 1; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { }
		
		LONG VP_GPURENDERER_RECURSION_DEPTH_DIFFUSE_OFFLINE 	{ PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_OFFLINE; MIN 0; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_OFFLINE; }

		LONG VP_GPURENDERER_RECURSION_DEPTH_GLOSSY_OFFLINE		{ PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_OFFLINE; MIN 0; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_OFFLINE; }

		LONG VP_GPURENDERER_RECURSION_DEPTH_REFRACTIVE_OFFLINE		{ PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_OFFLINE; MIN 0; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_OFFLINE; }

		LONG VP_GPURENDERER_RECURSION_DEPTH_REFRACTIVE_GLOSSY_OFFLINE		{ PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_OFFLINE; MIN 0; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_OFFLINE; }

		LONG VP_GPURENDERER_SHADOW_DEPTH_OFFLINE		{ MIN 1; MAXSLIDER 10; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { }

		REAL VP_GPURENDERER_AO_RAY_LENGTH_OFFLINE 	{ MIN 0.001; ANIM OFF; UNIT METER; }
		STATICTEXT { JOINENDSCALE; }

		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }

		LONG VP_GPURENDERER_ANTIALIASING_SAMPLES_OFFLINE		{ MIN 1; MAX 64; MAXSLIDER 32; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { }

		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }

		LONG VP_GPURENDERER_FILTERMODE_OFFLINE
		{
			ANIM OFF;
			
			CYCLE
			{
				VP_GPURENDERER_FILTERMODE_NONE;
				VP_GPURENDERER_FILTERMODE_BOX;
				VP_GPURENDERER_FILTERMODE_TRIANGLE;
				VP_GPURENDERER_FILTERMODE_GAUSSIAN;
				VP_GPURENDERER_FILTERMODE_MITCHELL;
				VP_GPURENDERER_FILTERMODE_LANCZOS;
				VP_GPURENDERER_FILTERMODE_BLACKMANHARRIS;
			}
		}
		STATICTEXT { }
		
		REAL VP_GPURENDERER_FILTERSIZE_OFFLINE 	{ MIN 0.5; MAX 64.0; ANIM OFF; STEP 1.0; MAXSLIDER 16; CUSTOMGUI REALSLIDER; }
		STATICTEXT { }
		
		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }
		
		BOOL VP_GPURENDERER_RADIANCE_CLAMP_ENABLED_OFFLINE 	{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		REAL VP_GPURENDERER_RADIANCE_CLAMP_OFFLINE 			{ MIN 1.0; ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }

		BOOL VP_GPURENDERER_FIREFLY_FILTER_ENABLE 			{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		REAL VP_GPURENDERER_FIREFLY_FILTER_THRESHOLD 		{ STEP 0.001; ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }
		
		GROUP VP_GPURENDERER_STOP_RENDERING_GROUP_OFFLINE
		{
			DEFAULT 1;
			LONG VP_GPURENDERER_RENDER_ITERATIONS_MODE_OFFLINE 
			{
				ANIM OFF;

				CYCLE
				{ 
					VP_GPURENDERER_RENDER_ITERATIONS_MODE_ITERATIONS;
					VP_GPURENDERER_RENDER_ITERATIONS_MODE_TIME;
					VP_GPURENDERER_RENDER_ITERATIONS_MODE_THRESHOLD;
					VP_GPURENDERER_RENDER_ITERATIONS_MODE_INFINITE;
				}
			}

			LONG VP_GPURENDERER_RENDER_ITERATIONS_OFFLINE	{ MIN 1; ANIM OFF; }
			LONG VP_GPURENDERER_RENDER_TIME_OFFLINE			{ MIN 0; ANIM OFF; }
			REAL VP_GPURENDERER_RENDER_THRESHOLD_OFFLINE	{ MIN 0.001; MAX 100.0; ANIM OFF; STEP 0.1; UNIT PERCENT; }
			LONG VP_GPURENDERER_RENDER_ITERATIONS_MAX		{ MIN 1; ANIM OFF; }
		}

		GROUP VP_GPURENDERER_REFRESH_GROUP
		{
			DEFAULT 1;

			LONG VP_GPURENDERER_REFRESH_MODE
			{
				ANIM OFF;
			
				CYCLE
				{
					VP_GPURENDERER_REFRESH_MODE_TIME;
					VP_GPURENDERER_REFRESH_MODE_ITERATIONS;
				}
			}
			STATICTEXT { JOINENDSCALE; }
		
			LONG VP_GPURENDERER_REFRESH_TIME			{ MIN 0; ANIM OFF; }
			LONG VP_GPURENDERER_REFRESH_ITERATIONS	{ MIN 1; ANIM OFF; }
		}

		GROUP VP_GPURENDERER_BUCKET_RENDERING_GROUP
		{
			DEFAULT 0;

			BOOL VP_GPURENDERER_BUCKET_RENDERING_ENABLED { ANIM OFF; }
			LONG VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE
			{
				ANIM OFF;
			
				CYCLE
				{
					VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_CENTERED;
					VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_LEFTTORIGHT;
					VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_RIGHTTOLEFT;
					VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_TOPTOBOTTOM;
					VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_BOTTOMTOTOP;
				}
			}
		
			LONG VP_GPURENDERER_BUCKET_RENDERING_BUCKETSIZEX	{ MIN 64; MAX 4096; ANIM OFF; }
			LONG VP_GPURENDERER_BUCKET_RENDERING_BUCKETSIZEY	{ MIN 64; MAX 4096; ANIM OFF; }
		}

		GROUP VP_GPURENDERER_DEFAULT_TEXRES_GROUP_OFFLINE
		{
			DEFAULT 0;
			LONG VP_GPURENDERER_TEXSIZEX_OFFLINE { MIN 1; MAX 8192; ANIM OFF; }
			LONG VP_GPURENDERER_TEXSIZEY_OFFLINE { MIN 1; MAX 8192; ANIM OFF; }
			LONG VP_GPURENDERER_BITDEPTH_OFFLINE 
			{
				ANIM OFF;

				CYCLE
				{
					VP_GPURENDERER_BITDEPTH_8;
					VP_GPURENDERER_BITDEPTH_32;
				}
			}
		}
		
		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }

		REAL VP_GPURENDERER_LOD								{ UNIT PERCENT; ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		BOOL VP_GPURENDERER_USELOD 							{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		BOOL VP_GPURENDERER_SHOWHUD 						{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		BOOL VP_GPURENDERER_RENDERDOODLE 					{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }
		
		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }
		
		BOOL VP_GPURENDERER_RELOAD_SCENE_PER_FRAME 					{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }
	}

	GROUP VP_GPURENDERER_PAGE_PREVIEW
	{
		COLUMNS 2;
		LONG VP_GPURENDERER_RENDERMODE_PREVIEW
		{
			ANIM OFF;
			
			CYCLE
			{
				VP_GPURENDERER_RENDERMODE_GLOBAL_ILLUMINATION;
				VP_GPURENDERER_RENDERMODE_DIRECT_ILLUMINATION;
				VP_GPURENDERER_RENDERMODE_AMBIENT_OCCLUSION;
				VP_GPURENDERER_RENDERMODE_WIREFRAME;
				VP_GPURENDERER_RENDERMODE_DIFFUSE;
			}
		}
		STATICTEXT { }

		BOOL VP_GPURENDERER_DEPTH_OF_FIELD_PREVIEW	{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		LONG VP_GPURENDERER_RECURSION_DEPTH_PREVIEW 	{ PARENTCOLLAPSE; MIN 1; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { }

		LONG VP_GPURENDERER_RECURSION_DEPTH_DIFFUSE_PREVIEW		{ PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_PREVIEW; MIN 0; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_PREVIEW; }

		LONG VP_GPURENDERER_RECURSION_DEPTH_GLOSSY_PREVIEW		{ PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_PREVIEW; MIN 0; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_PREVIEW; }

		LONG VP_GPURENDERER_RECURSION_DEPTH_REFRACTIVE_PREVIEW		{ PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_PREVIEW; MIN 0; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_PREVIEW; }

		LONG VP_GPURENDERER_RECURSION_DEPTH_REFRACTIVE_GLOSSY_PREVIEW	{ PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_PREVIEW; MIN 0; MAXSLIDER 50; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { PARENTCOLLAPSE VP_GPURENDERER_RECURSION_DEPTH_PREVIEW; }

		LONG VP_GPURENDERER_SHADOW_DEPTH_PREVIEW		{ MIN 1; MAXSLIDER 10; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { }

		REAL VP_GPURENDERER_AO_RAY_LENGTH_PREVIEW 	{ MIN 0.001; ANIM OFF; UNIT METER; }
		STATICTEXT { JOINENDSCALE; }

		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }

		LONG VP_GPURENDERER_ANTIALIASING_SAMPLES_PREVIEW		{ MIN 1; MAX 64; MAXSLIDER 32; ANIM OFF; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { }

		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }

		LONG VP_GPURENDERER_FILTERMODE_PREVIEW
		{
			ANIM OFF;
			
			CYCLE
			{
				VP_GPURENDERER_FILTERMODE_NONE;
				VP_GPURENDERER_FILTERMODE_BOX;
				VP_GPURENDERER_FILTERMODE_TRIANGLE;
				VP_GPURENDERER_FILTERMODE_GAUSSIAN;
				VP_GPURENDERER_FILTERMODE_MITCHELL;
				VP_GPURENDERER_FILTERMODE_LANCZOS;
				VP_GPURENDERER_FILTERMODE_BLACKMANHARRIS;
			}
		}
		STATICTEXT { }
		
		REAL VP_GPURENDERER_FILTERSIZE_PREVIEW 	{ MIN 0.5; MAX 64.0; ANIM OFF; STEP 1.0; MAXSLIDER 16; CUSTOMGUI REALSLIDER; }
		STATICTEXT { }
		
		SEPARATOR	{ LINE; }
		STATICTEXT { JOINENDSCALE; }
		
		BOOL VP_GPURENDERER_RADIANCE_CLAMP_ENABLED_PREVIEW 	{ ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		REAL VP_GPURENDERER_RADIANCE_CLAMP_PREVIEW 			{ MIN 1.0; ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }

		GROUP VP_GPURENDERER_STOP_RENDERING_GROUP_PREVIEW
		{
			DEFAULT 1;
			LONG VP_GPURENDERER_RENDER_ITERATIONS_MODE_PREVIEW 
			{
				ANIM OFF;

				CYCLE
				{ 
					VP_GPURENDERER_RENDER_ITERATIONS_MODE_ITERATIONS;
					VP_GPURENDERER_RENDER_ITERATIONS_MODE_TIME;
					VP_GPURENDERER_RENDER_ITERATIONS_MODE_INFINITE;
				}
			}

			LONG VP_GPURENDERER_RENDER_ITERATIONS_PREVIEW	{ MIN 1; ANIM OFF; }
			LONG VP_GPURENDERER_RENDER_TIME_PREVIEW			{ MIN 0; ANIM OFF; }
		}

		GROUP VP_GPURENDERER_RESOLUTION_GROUP_PREVIEW
		{
			DEFAULT 0;

			LONG VP_GPURENDERER_RESOLUTION_MAX_PREVIEW
			{
				ANIM OFF;

				CYCLE
				{
					VP_GPURENDERER_RESOLUTION_PREVIEW_1;
					VP_GPURENDERER_RESOLUTION_PREVIEW_2;
					VP_GPURENDERER_RESOLUTION_PREVIEW_4;
					VP_GPURENDERER_RESOLUTION_PREVIEW_8;
					VP_GPURENDERER_RESOLUTION_PREVIEW_16;
				}
			}
		}

		GROUP VP_GPURENDERER_DEFAULT_TEXRES_GROUP_PREVIEW
		{
			DEFAULT 0;
			LONG VP_GPURENDERER_TEXSIZEX_PREVIEW { MIN 1; MAX 8192; ANIM OFF; }
			LONG VP_GPURENDERER_TEXSIZEY_PREVIEW { MIN 1; MAX 8192; ANIM OFF; }
			LONG VP_GPURENDERER_BITDEPTH_PREVIEW 
			{
				ANIM OFF;

				CYCLE
				{
					VP_GPURENDERER_BITDEPTH_8;
					VP_GPURENDERER_BITDEPTH_32;
				}
			}
		}
	}

	GROUP VP_GPURENDERER_PAGE_GENERAL
	{
		BOOL VP_GPURENDERER_DEFAULT_LIGHT		{ ANIM OFF; }
		BOOL VP_GPURENDERER_STATIC_NOISE		{ ANIM OFF; }
		LONG VP_GPURENDERER_SEED						{ ANIM OFF; }
		REAL VP_GPURENDERER_RAY_EPSILON			{ MIN 0.0; STEP 0.0001; ANIM OFF; }
		
		GROUP VP_GPURENDERER_OOC_GROUP
		{
			DEFAULT 1;
			COLUMNS 2;
			BOOL VP_GPURENDERER_OOC_TEXTURE_CACHE_ENABLED { ANIM OFF; }
			STATICTEXT { }

			REAL VP_GPURENDERER_OOC_TEXTURE_CACHE	{ MIN 10; MAX 99; ANIM OFF; UNIT PERCENT;}
			STATICTEXT { }
		
			LONG VP_GPURENDERER_OOC_TEXTURE_CACHE_MODE 
			{
				ANIM OFF;

				CYCLE
				{
					VP_GPURENDERER_OOC_TEXTURE_CACHE_MODE_MEM;
					VP_GPURENDERER_OOC_TEXTURE_CACHE_MODE_DISK;
				}
			}
			STATICTEXT { }
		}

		GROUP VP_GPURENDERER_GROUP_DEVICES
		{
			DEFAULT 1;
			BOOL VP_GPURENDERER_DEVICES_OVERRIDE_PREFS 	{ ANIM OFF; }
			GROUP VP_GPURENDERER_DEVICE_GROUP_OFFLINE
			{
				DEFAULT 0;
				COLUMNS 2;
				BOOL VP_GPURENDERER_DEVICE_CPU_OFFLINE	{ ANIM OFF; }
			}	
		
			GROUP VP_GPURENDERER_DEVICE_GROUP_PREVIEW
			{
				DEFAULT 0;
				COLUMNS 2;
				BOOL VP_GPURENDERER_DEVICE_CPU_PREVIEW	{ ANIM OFF; }
			}
		}
	}

	GROUP VP_GPURENDERER_PAGE_MULTIPASS
	{
		BOOL VP_GPURENDERER_MULTIPASS_ENABLE 	{ ANIM OFF; }

		GROUP VP_GPURENDERER_MULTIPASS_GROUP
		{
			DEFAULT 1;
			COLUMNS 2;
			BOOL VP_GPURENDERER_MULTIPASS_DIRECT_ILLUMINATION { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_DIRECT_DIFFUSE 	{ ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_DIRECT_REFLECT	{ ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_EMISSION { ANIM OFF; }
			
			SEPARATOR	{ LINE; }
			STATICTEXT { JOINENDSCALE; }
			
			
			BOOL VP_GPURENDERER_MULTIPASS_INDIRECT_ILLUMINATION { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_INDIRECT_DIFFUSE 	{ ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_INDIRECT_REFLECT 	{ ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_REFRACT 	{ ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_VOLUME 	{ ANIM OFF; }
			
			SEPARATOR	{ LINE; }
			STATICTEXT { JOINENDSCALE; }
			
			BOOL VP_GPURENDERER_MULTIPASS_BACKGROUND { ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_AO 	{ ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_ALBEDO 	{ ANIM OFF; }
			STATICTEXT { }
			SEPARATOR	{ LINE; }
			STATICTEXT { JOINENDSCALE; }
			
			BOOL VP_GPURENDERER_MULTIPASS_WORLD_COORD { ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_UV { ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_GEOMETRIC_NORMAL { ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_SHADING_NORMAL { ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_DEPTH { ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_OBJECT_ID { ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_OBJECT_GROUP_ID { ANIM OFF; }
			STATICTEXT { }
			BOOL VP_GPURENDERER_MULTIPASS_MATERIAL_ID { ANIM OFF; }
			STATICTEXT { }
		}
		
		GROUP VP_GPURENDERER_MULTIPASS_AA_GROUP
		{
			DEFAULT 0;
			BOOL VP_GPURENDERER_MULTIPASS_WORLD_COORD_ALIASED { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_UV_ALIASED { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_GEOMETRIC_NORMAL_ALIASED { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_SHADING_NORMAL_ALIASED { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_DEPTH_ALIASED { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_OBJECT_ID_ALIASED { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_OBJECT_GROUP_ID_ALIASED { ANIM OFF; }
			BOOL VP_GPURENDERER_MULTIPASS_MATERIAL_ID_ALIASED { ANIM OFF; }
		}
	}
}
