using UnityEngine;
using System.Collections;
using System;

public class ZeroParallax : MonoBehaviour {

	Vector3 origScale = new Vector3();
	ZSCore zs;
	public bool EnableAngleAwareness = true;
	public Vector3 cameraOffset;
	public Matrix4x4 worldToCameraTransform;
	public Vector3 displayAngle;

	void Start () {
		zs = GameObject.Find ("ZSCore").GetComponent<ZSCore>();
		origScale = transform.localScale;
	}	
	void Update () {
		displayAngle = zs.GetDisplayAngle ();
		if (EnableAngleAwareness) {
			transform.position = centerOfZeroParallax();
			zs.SetPortalMode ((int)ZSCore.PortalMode.Angle);
			transform.up = zs.CurrentCamera.transform.up;
			Vector3 orientation = transform.eulerAngles;
			orientation.x = orientation.x - displayAngle.x + (float)30.0;
			transform.eulerAngles = orientation;
			transform.localScale = origScale * zs.ViewerScale;
			cameraOffset = zs.GetCameraOffset();
			worldToCameraTransform = zs.GetCoordinateSpaceTransform(ZSCore.CoordinateSpace.Display,ZSCore.CoordinateSpace.Camera);
		}
		else {
			transform.position = centerOfZeroParallax();
			zs.SetPortalMode((int)ZSCore.PortalMode.None);
			transform.up = zs.CurrentCamera.transform.up;
			transform.localScale = origScale * zs.ViewerScale;
		}
	}
	Vector3 centerOfZeroParallax(){
		return zs.CurrentCamera.transform.position
		               + zs.CurrentCamera.transform.forward 
					   * zs.ViewerScale 
					   * zs.GetCameraOffset().magnitude;
	}
}


