using UnityEngine;
using System.Collections;

public class Levels: MonoBehaviour
{

	public ArrayList Captions = new ArrayList ();

	void Initialize ()
	{
		Captions.Add ("This sample demonstrates a 3D stylus (with six degrees of freedom) " +
			"that toggles into 2D mouse emulation mode when the stylus tip approaches a 2D panel at Zero Parallax.");	

		Captions.Add ("If you have build your project with a second scene, " +
			"then this caption will appear when you hit the next button.");

	}

	void Update ()
	{
		
		// Make the first button. If it is pressed, Application.Loadlevel (1) will be executed
		if (Input.GetKeyUp (KeyCode.Escape)) {			
			#if UNITY_EDITOR_WIN
				if (Application.isEditor) {
					UnityEditor.EditorApplication.isPlaying = false;
				} else {
					Application.Quit ();
				}
			#else
			Application.Quit ();
			#endif
		}
	}

	public string GetCaption (int level)
	{
		if (Captions.Count == 0) {
			Initialize ();
		}
		if (level < Captions.Count && level >= 0) {
			return (string)Captions [level];
		} else {
			return "";
		}
	}

}
