using UnityEngine;
using System.Collections;


public class StylusWithMouseEmulation : StylusWithHitting {
	//Only emulates mouse when stylus selects TargetTag'ed GO
	public static string TargetTag = "gui";

	public new void Update(){
		RaycastHit hitInfo;
		bool didHit = DidHit(out hitInfo);
		ToggleEmulation(didHit);
		CheckForHit(didHit,hitInfo);
	}
	private bool DidHit(out RaycastHit hitInfo){
		bool didHit = Physics.Raycast (transform.position,transform.forward,out hitInfo);
		//only ok to hit GO's with the right tag
		return didHit && hitInfo.collider.gameObject.tag.Equals(TargetTag);
	}
	public void ToggleEmulation(bool didHit){
		if (didHit){
			Screen.showCursor = true;
			_zsCore.SetMouseEmulationEnabled(true);
		}
		else {
			Screen.showCursor = false;
			_zsCore.SetMouseEmulationEnabled(false);
		}
	}
}

