using UnityEngine;
using System.Collections;

public class StylusWithHitting : StylusBase {

	public static Color ActivatedColor = Color.black;
	protected LastHoveredGO lastHoveredGO;
	
	protected new void Start ()
	{
		base.Start();
		lastHoveredGO = null;
	}
	public void Update(){
		RaycastHit hitInfo;
		bool didHit = DidHit(out hitInfo);
		CheckForHit(didHit,hitInfo);
	}
	private bool DidHit(out RaycastHit hitInfo){
		return Physics.Raycast (transform.position,transform.forward,out hitInfo);
	}
	public void CheckForHit(bool didHit,RaycastHit hitInfo){
		//Should be called whether or not we hit (if no hit, then last hit is reset)
		bool didHitNewGO = didHit && (lastHoveredGO == null 
		                              || hitInfo.collider.gameObject != lastHoveredGO.GO);
		
		if ( lastHoveredGO != null && (didHitNewGO || !didHit) ){
			lastHoveredGO.RestoreColor();
			lastHoveredGO = null;
		}
		if (didHitNewGO) {
			lastHoveredGO = new LastHoveredGO(hitInfo.collider.gameObject,
			                                  hitInfo.collider.gameObject.renderer.material.color);
		}
	}
	
	protected class LastHoveredGO{
		public GameObject GO;
		public Color originalColor;
		public LastHoveredGO(GameObject setGO, Color setoriginalColor){
			GO = setGO;
			originalColor = setoriginalColor;
			GO.renderer.material.color = StylusWithHitting.ActivatedColor;
		}
		public void RestoreColor(){
			GO.renderer.material.color = originalColor;
		}
	}
	
}


