using UnityEngine;
using System.Collections;

public class StylusBase : MonoBehaviour
{
	protected ZSCore _zsCore;

	protected void Start ()
	{
		_zsCore = GameObject.Find ("ZSCore").GetComponent<ZSCore> ();
		_zsCore.Updated += new ZSCore.CoreEventHandler (UpdateStylusPose);
		initialRotation = transform.rotation;
		initialPosition = transform.position;
	}

	private void UpdateStylusPose (ZSCore sender)
	{
			Matrix4x4 pose = _zsCore.GetTrackerTargetWorldPose (_targetType);
		//Debug.Log("x,y,z=" + (pose.m03 / _zsCore.ViewerScale).ToString() + "," + (pose.m13 / _zsCore.ViewerScale).ToString() + "," + (pose.m23 / _zsCore.ViewerScale).ToString());
		transform.position = new Vector3 (pose.m03 + initialPosition.x,
			                                 pose.m13 + initialPosition.y,
			                                 pose.m23 + initialPosition.z);
			transform.rotation = Quaternion.LookRotation(pose.GetColumn(2), pose.GetColumn(1))
				* initialRotation;
	}
	
	private Quaternion initialRotation = new Quaternion();
	private Vector3 initialPosition = new Vector3();
	private ZSCore.TrackerTargetType _targetType = ZSCore.TrackerTargetType.Primary;
	
}

