﻿using UnityEngine;
using System.Collections;

public class GUICaptionWithBackFwd : MonoBehaviour {

	public float xPosPct = .1f;
	public float yPosPct = .85f;
	public float xWidthPix = 1300f;
	public float yHeightPix = 100f;

	public int fontSize = 20;
	protected string caption;

	protected struct Span {
		public float leftPCT;
		public float widthPCT;
		public Span(float setLeftPCT, float setWidthPCT){
			this.leftPCT=setLeftPCT;
			this.widthPCT=setWidthPCT;
		}
	};

	public virtual void Start ()
	{
		Levels levels = FindObjectOfType<Levels>();
		caption = levels.GetCaption(Application.loadedLevel);
	}
	
	public virtual void OnGUI ()
	{
		GetStyle();
		Span cap = new Span(0f,.7f);
		Span back = new Span(.705f, .14f);
		Span fwd = new Span(.85f,.14f);
		CaptionForwardBackControls(cap,back,fwd);
	}

	protected Vector2 CaptionForwardBackControls(Span capSpan, Span backSpan, Span fwdSpan){

		Vector2 posPix = new Vector2(XPctToPix (xPosPct),YPctToPix(yPosPct));
		Caption(posPix.x, posPix.y, capSpan.leftPCT, capSpan.widthPCT);
		
		// Make the first button. If it is pressed, Application.Loadlevel (1) will be executed
		BackwardLevelButton(posPix.x, posPix.y, backSpan.leftPCT, backSpan.widthPCT);
		
		// Make the first button. If it is pressed, Application.Loadlevel (1) will be executed
		ForwardLevelButton(posPix.x, posPix.y, fwdSpan.leftPCT, fwdSpan.widthPCT);

		return posPix;
	}

	protected void GetStyle(){
		buttonstyle = new GUIStyle(GUI.skin.GetStyle("Button"));
		buttonstyle.fontSize = fontSize;
		buttonstyle.wordWrap = true;
		
		captionstyle = new GUIStyle(GUI.skin.GetStyle("Button"));
		captionstyle.fontSize = fontSize;
		captionstyle.wordWrap = true;
		captionstyle.alignment = TextAnchor.UpperLeft;
		captionstyle.padding = new RectOffset(5,5,5,5);
	}

	protected const float yMargin = 5f;
	protected GUIStyle buttonstyle;
	protected GUIStyle captionstyle;

	public virtual void Caption(float xPosPix, float yPosPix, float xPosPCT_OFFSET, float xWidthPCT){
		GUI.Box (new Rect (xPosPix + xWidthPix * xPosPCT_OFFSET, 
		                   yPosPix + yMargin, xWidthPix * xWidthPCT, 
		                   yHeightPix - 2*yMargin), 
		         caption, 
		         captionstyle);
	}
	public virtual void BackwardLevelButton(float xPosPix, float yPosPix, float xPosPCT_OFFSET, float xWidthPCT){
		// Make the first button. If it is pressed, Application.Loadlevel (1) will be executed
		if (GUI.Button (new Rect (xPosPix + xWidthPix * xPosPCT_OFFSET, 
		                          yPosPix + yMargin, 
		                          xWidthPix * xWidthPCT, 
		                          yHeightPix - 2*yMargin), 
		                "<<", 
		                buttonstyle)) {
			
			if (Application.loadedLevel > 0){
				Application.LoadLevel (Application.loadedLevel - 1);
			}
		}
	}
	public virtual void ForwardLevelButton(float xPosPix, float yPosPix, float xPosPCT_OFFSET, float xWidthPCT){
		
		// Make the first button. If it is pressed, Application.Loadlevel (1) will be executed
		if (GUI.Button (new Rect (xPosPix + xWidthPix * xPosPCT_OFFSET, 
		                          yPosPix + yMargin, 
		                          xWidthPix * xWidthPCT, 
		                          yHeightPix - 2*yMargin), 
		                ">>", 
		                buttonstyle)) {
			
			if (Application.loadedLevel < Application.levelCount - 1){
				Application.LoadLevel (Application.loadedLevel + 1);
			}
			else {
				#if UNITY_EDITOR_WIN
				if (Application.isEditor) {
					UnityEditor.EditorApplication.isPlaying = false;
				} else {
					Application.Quit ();
				}
				#else
				Application.Quit ();
				#endif
			}			
		}
	}

	protected float XPctToPix (float xPct)
	{
		if (xPct >= 0)
			return Screen.width * xPct;
		else
			return Screen.width * (1 + xPct);
	}
	
	protected float YPctToPix (float yPct)
	{
		if (yPct >= 0)
			return Screen.height * yPct;
		else
			return Screen.height * (1 - yPct);
	}

}
