CONTAINER Tcaposemorph
{
	NAME Tcaposemorph;
	INCLUDE Texpression;

	GROUP Obaselist
	{
		PRIORITY ID_CA_POSE_BASE_PRI { ANIM OFF; }

		GROUP ID_CA_POSE_OPTIONS_GROUP
		{
			COLUMNS 2; DEFAULT 1;
			
			BOOL ID_CA_POSE_P { ANIM OFF; }
			BOOL ID_CA_POSE_PARAM { ANIM OFF; }
			
			BOOL ID_CA_POSE_S { ANIM OFF; }
			BOOL ID_CA_POSE_USERDATA { ANIM OFF; }
			
			BOOL ID_CA_POSE_R { ANIM OFF; }
			BOOL ID_CA_POSE_HIERARCHY { ANIM OFF; }
			
			BOOL ID_CA_POSE_POINTS { ANIM OFF; }
			BOOL ID_CA_POSE_MAPS { ANIM OFF; }
			
			BOOL ID_CA_POSE_UV { ANIM OFF; }
			STATICTEXT { NEWLINE; }

			GROUP ID_CA_POSE_OPTIONS_PSD_GROUP
			{
				COLUMNS 1;
				BOOL ID_CA_POSE_OPTIONS_PSD_DRAWDRIVER { ANIM OFF; }
				COLOR ID_CA_POSE_OPTIONS_PSD_DRIVERCOLOR { ANIM OFF; }
				REAL ID_CA_POSE_OPTIONS_PSD_POS_THRESHOLD { ANIM OFF; UNIT METER; MIN 0.0; MAX 100000.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
				REAL ID_CA_POSE_OPTIONS_PSD_ORIENT_THRESHOLD { ANIM OFF; UNIT DEGREE; MIN 0.0; MAX 180.0; MAXSLIDER 180.0; CUSTOMGUI REALSLIDER; }
				REAL ID_CA_POSE_OPTIONS_PSD_TWIST_THRESHOLD { ANIM OFF; UNIT DEGREE; MIN 0.0; MAX 180.0; MAXSLIDER 180.0; CUSTOMGUI REALSLIDER; }
			}
		}		

		STATICTEXT ID_CA_POSE_MEMORY_USED { }		
	}
	
	GROUP ID_TAGPROPERTIES
	{		
		GROUP
		{
			LONG ID_CA_POSE_MODE
			{
				CYCLE
				{
					ID_CA_POSE_MODE_EDIT;
					ID_CA_POSE_MODE_ANIMATE;
				}
				CUSTOMGUI RADIOBUTTONS; COLUMNS 2; SCALE_H;
				ANIM OFF;
			}
		}
		
		SEPARATOR { LINE; }

		GROUP
		{
			ITEMTREE ID_CA_POSE_MORPHS
			{
				DRAGDROP;
				COLUMNS 4;
				ROWS 10;
				PADLOCK;
				CHECKBOX;
				FOLDERS;
				MULTIPLE;
				ACCEPT { Obase; }
			}
		}
		
		GROUP
		{
			COLUMNS 2;
			
			BUTTON	ID_CA_POSE_ADDMORPH { SCALE_H;}
			LONG ID_CA_POSE_EDIT_MODE
			{
				ANIM OFF;
				CYCLE
				{
					ID_CA_POSE_EDIT_MODE_OFF;
					ID_CA_POSE_EDIT_MODE_TARGET;
					ID_CA_POSE_EDIT_MODE_INPLACE;
				}
			}
		}
		
		GROUP
		{
			COLUMNS 2;

			LONG ID_CA_POSE_MIXING
			{
				SCALE_H; ANIM OFF;
				CYCLE
				{
					ID_CA_POSE_MIXING_ABS;
					ID_CA_POSE_MIXING_REL;
					ID_CA_POSE_MIXING_ROT;
					ID_CA_POSE_MIXING_CORRECTIONAL;
					ID_CA_POSE_MIXING_CORRECTIONAL_AREA;
					ID_CA_POSE_MIXING_CORRECTIONAL_PSD;
				}
			}
			BOOL ID_CA_POSE_MIXING_DEFORMED { }
			SEPARATOR { }
		}
		
		GROUP
		{
			COLUMNS 2;
				
			BOOL ID_CA_POSE_USE_STRENGTH { }
			REAL ID_CA_POSE_STRENGTH { UNIT PERCENT; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; SCALE_H; }
		}
		
		GROUP ID_CA_POSE_ROTATION_GROUP
		{
			DEFAULT 1;
			
			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 3;
				
				GROUP
				{
					VECTOR ID_CA_POSE_ROTATION_POS { UNIT METER; SCALE_H; CUSTOMGUI SUBDESCRIPTION;; }
				}
				GROUP
				{
					VECTOR ID_CA_POSE_ROTATION_AXIS { UNIT METER; SCALE_H; CUSTOMGUI SUBDESCRIPTION;; }
				}
			}
				
			GROUP
			{
				COLUMNS 2;
				BUTTON ID_CA_POSE_ROTATION_FROMEDGE { SCALE_H;}
				BUTTON ID_CA_POSE_ROTATION_FROMPOINTS { SCALE_H;}
			}			
		}
		
		GROUP ID_CA_POSE_EDIT_PSD_GROUP
		{
			GROUP
			{
				COLUMNS 2;
				BUTTON ID_CA_POSE_UPDATE_PSD_POSE { SCALE_H;}
				BUTTON ID_CA_POSE_RESTORE_PSD_POSE { SCALE_H;}
				BUTTON ID_CA_POSE_FORCE_AUTOWEIGHTDRIVER { SCALE_H;}
				BUTTON ID_CA_POSE_SHOW_AUTOWEIGHTDRIVER { SCALE_H;}
			}

			SEPARATOR { LINE; }
			LONG ID_CA_POSE_PSD_INTERP_MODE_UI_ONLY
			{
				SCALE_H; ANIM OFF;
				CYCLE
				{
					ID_CA_POSE_PSD_INTERP_MODE_JOINT;
					ID_CA_POSE_PSD_INTERP_MODE_AXIS;
					ID_CA_POSE_PSD_INTERP_MODE_GLOBALAVERAGE;
				}
			}
			LINK ID_CA_POSE_WEIGHTTAG_UI_ONLY { ANIM OFF; ACCEPT { 1019365; } } // Tweights = 1019365
		}

		GROUP ID_CA_POSE_ADVANCED_GROUP
		{
			LINK ID_CA_POSE_TARGET { }

			GROUP
			{
				COLUMNS 2;
							
				FILENAME ID_CA_POSE_EXTERNAL { SCALE_H; ANIM OFF; }
				BUTTON ID_CA_POSE_EXTERNAL_SAVE { }
			}
		}
		
		GROUP ID_CA_POSE_ANIMATE_GROUP
		{
			COLUMNS 2;
			
			REAL ID_CA_POSE_TOTAL_STRENGTH { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
			
			GROUP
			{
				COLUMNS 2;
				
				BUTTON ID_CA_POSE_RECORD_SLIDER { SCALE_H; }
				BUTTON ID_CA_POSE_RESET_SLIDER {SCALE_H; }
			}
			
			SEPARATOR { }
			
			GROUP ID_CA_POSE_SLIDERS_GROUP
			{
				COLUMNS 2;

			}
		}
	}
	
	GROUP ID_CA_POSE_INCLUDE_GROUP
	{
		SCALE_V;
		
		GROUP
		{		
			LINK ID_CA_POSE_DEST { }
		}
		
		GROUP
		{
			SCALE_V;
	
			LONG ID_CA_POSE_TARGET_INCLUDE_MODE
			{
				SCALE_H;
				
				CYCLE
				{
					ID_CA_POSE_TARGET_INCLUDE_MODE_INCLUDE;
					ID_CA_POSE_TARGET_INCLUDE_MODE_EXCLUDE;
				}
			}
			
			IN_EXCLUDE  ID_CA_POSE_TARGET_INCLUDE
			{
				NUM_FLAGS 1; INIT_STATE 0; SEND_SELCHNGMSG 1; SCALE_V;
				IMAGE_01_ON 1009316; IMAGE_01_OFF 1009320;				
				ACCEPT { Obase; Tbase; };
			}
		}
	}

	GROUP ID_CA_POSE_PSD_TAB_GROUP
	{
		GROUP ID_CA_POSE_PSD_GROUP
		{
			HIDDEN;
			COLUMNS 2;
			BOOL ID_CA_POSE_PSD_AUTOWEIGHT_INTERP_UI_ONLY { HIDDEN; }
			BOOL ID_CA_POSE_PSD_ORIENT_INTERP_UI_ONLY { HIDDEN; }
			BOOL ID_CA_POSE_PSD_TWIST_INTERP_UI_ONLY { HIDDEN; }
			BOOL ID_CA_POSE_PSD_POS_INTERP_UI_ONLY { HIDDEN; }
			REAL ID_CA_POSE_PSD_ORIENT_INTERP_AVERAGEWEIGHT_UI_ONLY { HIDDEN; }
			REAL ID_CA_POSE_PSD_POS_INTERP_AVERAGEWEIGHT_UI_ONLY { HIDDEN; }
			REAL ID_CA_POSE_PSD_TWIST_INTERP_AVERAGEWEIGHT_UI_ONLY { HIDDEN; }
			REAL ID_CA_POSE_PSD_INTERP_AVERAGEWEIGHT_UI_ONLY { HIDDEN; }
			BOOL ID_CA_POSE_PSD_INTERP_MODE { HIDDEN; }

			// per joint group
			GROUP
			{
				COLUMNS 1;
				REAL ID_CA_POSE_PSD_JOINT_X_WEIGHT { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; SCALE_H; HIDDEN; }
				REAL ID_CA_POSE_PSD_JOINT_Y_WEIGHT { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; SCALE_H; HIDDEN; }
				REAL ID_CA_POSE_PSD_JOINT_Z_WEIGHT { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; SCALE_H; HIDDEN; }		
				BOOL ID_CA_POSE_PSD_JOINT_FORCE_IN_AUTOWEIGHT { HIDDEN; }
			}
		}
	}
}
