CONTAINER TBakeTexture
{
	NAME TBakeTexture;
	INCLUDE Tbase;

	GROUP ID_TAGPROPERTIES
	{
		FILENAME BAKETEXTURE_NAME { SAVE; }
		LONG BAKETEXTURE_FORMAT
		{
			CYCLE
			{
			}
		}
		BUTTON BAKETEXTURE_OPTIONS_BTN { }
		BOOL BAKETEXTURE_SINGLEFILE { }

		COLORPROFILE BAKETEXTURE_COLORPROFILE { DISPLAYMODE; SCALE_H; }
		LONG BAKETEXTURE_COLOR_DEPTH
		{
			CYCLE
			{
			}
		}
		BOOL BAKETEXTURE_AUTOSIZE { }
		LONG BAKETEXTURE_WIDTH { MIN 16; MAX 16000; }
		LONG BAKETEXTURE_HEIGHT { MIN 16; MAX 16000; }
		LONG BAKETEXTURE_AUTO_MIN { MIN 16; MAX 16000; }
		LONG BAKETEXTURE_AUTO_MAX { MIN 16; MAX 16000; }
		REAL BAKETEXTURE_AUTO_PIXEL_SIZE { MIN 0.001; }
		LONG BAKETEXTURE_SUPERSAMPLING { MIN 0; MAX 10; }
		LONG BAKETEXTURE_PIXELBORDER { MIN 0; MAX 20; }
		BOOL BAKETEXTURE_CONTINUE_UV { }
		COLOR BAKETEXTURE_BACKGROUND { }
	}

	GROUP ID_TEXTURESETTINGS
	{
	}
	GROUP ID_BAKEOPTIONS
	{
		BOOL BAKETEXTURE_USE_POLYSELECTION { }
		BOOL BAKETEXTURE_USE_BUMP { }
		BOOL BAKETEXTURE_USE_CAMERA_VECTOR { }

		SEPARATOR { LINE; }

		GROUP
		{
			LAYOUTGROUP; COLUMNS 2;
			GROUP
			{
				BOOL BAKETEXTURE_CHANNEL_COLOR { }
				BOOL BAKETEXTURE_CHANNEL_LUMINANCE { }
				BOOL BAKETEXTURE_CHANNEL_DIFFUSION { }
				BOOL BAKETEXTURE_CHANNEL_BUMP { }
				BOOL BAKETEXTURE_CHANNEL_ALPHA { }
				BOOL BAKETEXTURE_CHANNEL_TRANS { }
				BOOL BAKETEXTURE_CHANNEL_DISPLACEMENT { }
			}
			GROUP
			{
				BOOL BAKETEXTURE_CHANNEL_S_COLOR { }
				BOOL BAKETEXTURE_CHANNEL_ILLUMINATION { }
				BOOL BAKETEXTURE_CHANNEL_SHADOWS { }
				BOOL BAKETEXTURE_CHANNEL_AO { }
				BOOL BAKETEXTURE_CHANNEL_NORMAL { }
				BOOL BAKETEXTURE_CHANNEL_UVMAP { }
				BOOL BAKETEXTURE_CHANNEL_REFLECTION { }
			}
		}

		GROUP ID_COLORGROUP
		{
			COLUMNS 2;
			BOOL BAKETEXTURE_COLOR_ILLUM { }
			BOOL BAKETEXTURE_COLOR_SHADOWS { }
			BOOL BAKETEXTURE_COLOR_LUMINANCE { }
			BOOL BAKETEXTURE_COLOR_DIFFUSION { }
		}

		GROUP ID_LUMINANCEGROUP
		{
			BOOL BAKETEXTURE_LUMINANCE_DIFFUSION { }
		}
	
		GROUP ID_ILLUMINATIONGROUP
		{
			BOOL BAKETEXTURE_ILLUMINATION_SHADOWS { }
		}

		GROUP ID_NORMALGROUP
		{
			LINK BAKETEXTURE_NORMAL_SOURCE { ANIM OFF; ACCEPT { Opolygon; } }
			LONG BAKETEXTURE_NORMAL_METHOD
			{
				CYCLE
				{
					BAKETEXTURE_NORMAL_METHOD_OBJECT;
					BAKETEXTURE_NORMAL_METHOD_TANGENT;
					BAKETEXTURE_NORMAL_METHOD_WORLD;
				}
			}
			GROUP
			{
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BOOL BAKETEXTURE_NORMAL_FLIP_X { }
					BOOL BAKETEXTURE_NORMAL_FLIP_Y { }
				}
				GROUP
				{
					BOOL BAKETEXTURE_NORMAL_FLIP_Z { }
					BOOL BAKETEXTURE_NORMAL_SWAP_YZ { }
				}
			}
		}

		GROUP ID_AOGROUP
		{
			BOOL BAKETEXTURE_AO_SELFINTERSECTION { }
			BOOL BAKETEXTURE_AO_TO_VERTEX { }
		}
		
		GROUP ID_DISPLACE_GROUP
		{
			LINK BAKETEXTURE_DISPLACEMENT_SOURCE { ANIM OFF; ACCEPT { Opolygon; } }
			REAL BAKETEXTURE_DISPLACEMENT_HEIGHT { UNIT METER; ANIM OFF; }
			LONG BAKETEXTURE_DISPLACEMENT_METHOD
			{
				CYCLE
				{
					BAKETEXTURE_DISPLACEMENT_METHOD_INTENSITY;
					BAKETEXTURE_DISPLACEMENT_METHOD_CENTEREDINTENSITY;
					BAKETEXTURE_DISPLACEMENT_METHOD_REDGREEN;
					BAKETEXTURE_DISPLACEMENT_METHOD_OBJECT;
					BAKETEXTURE_DISPLACEMENT_METHOD_TANGENT;
					BAKETEXTURE_DISPLACEMENT_METHOD_WORLD;
				}
			}
			BOOL BAKETEXTURE_DISPLACEMENT_SUBPOLY { }
			LONG BAKETEXTURE_DISPLACEMENT_SUBPOLY_SUBDIVISION { MIN 1; MAX 12; }
			BOOL BAKETEXTURE_DISPLACEMENT_SUBPOLY_ROUND { }
			BOOL BAKETEXTURE_DISPLACEMENT_SUBPOLY_ROUNDCONTOUR { }
			BOOL BAKETEXTURE_DISPLACEMENT_SUBPOLY_HQREMAPPING { }
			BOOL BAKETEXTURE_DISPLACEMENT_SUBPOLY_MAPRESULT { }
			BOOL BAKETEXTURE_DISPLACEMENT_SUBPOLY_KEEPEDGES { }
			BOOL BAKETEXTURE_DISPLACEMENT_SUBPOLY_DISTRIBUTION { }
		}

		GROUP ID_RAYCAST_GROUP
		{
			BOOL BAKETEXTURE_RAYCAST_USE_MAX_DISTANCE { ANIM OFF; }
			REAL BAKETEXTURE_RAYCAST_CUSTOM_MAX_DISTANCE { UNIT METER; MIN 0.0; ANIM OFF; }
			BOOL BAKETEXTURE_RAYCAST_USE_AUTO_SPIKE_THRESHOLD { ANIM OFF; }
			REAL BAKETEXTURE_RAYCAST_CUSTOM_SPIKE_THRESHOLD { MIN 0; MAX 100; ANIM OFF; }
		}

		LONG BAKETEXTURE_MAPPING
		{
			CYCLE
			{
				BAKETEXTURE_MAPPING_OFF;
				BAKETEXTURE_MAPPING_CUBIC;
				BAKETEXTURE_MAPPING_ANGLE;
			}
		}
		LONG BAKETEXTURE_RELAXCOUNT { MIN 0; }

		SEPARATOR { LINE; }

		GROUP
		{
			COLUMNS 4;
			BUTTON BAKETEXTURE_BAKE { }
			BUTTON BAKETEXTURE_STOP { }
			BUTTON BAKETEXTURE_DELETE { }
			BUTTON BAKETEXTURE_BAKE_PREVIEW { }
		}

		MATPREVIEW BAKETEXTURE_PREVIEW { OPEN; MIN_WIDTH 150; MIN_HEIGHT 150; RECTSELECT; }
	}

	GROUP ID_DETAILSGROUP
	{
		GROUP
		{
			BOOL BAKETEXTURE_USE_CURRENT { }
			BASETIME BAKETEXTURE_TIME_MIN { }
			BASETIME BAKETEXTURE_TIME_MAX { }
			LONG BAKETEXTURE_FPS { MIN 1; }
			LONG BAKETEXTURE_NAME_FORMAT
			{
				CYCLE
				{
					BAKETEXTURE_NAME_0000_TIF;
					BAKETEXTURE_NAME0000_TIF;
					BAKETEXTURE_NAME0000;
					BAKETEXTURE_NAME_0000;
					BAKETEXTURE_NAME000_TIF;
					BAKETEXTURE_NAME000;
					BAKETEXTURE_NAME_000;
				}
			}
		}
		SEPARATOR { LINE; }

		SCALE_V;
		IN_EXCLUDE BAKETEXTURE_TAGLIST { NUM_FLAGS 0; INIT_STATE 0; ACCEPT { Ttexture; }  ANIM OFF; }
	}
}
