CONTAINER Omograph_fracturevoronoi
{
	NAME 	Omograph_fracturevoronoi;
	INCLUDE Obase;
	SCALE_V;
	GROUP ID_OBJECTPROPERTIES
	{
		LINK ID_FRACTURE_SELECTION
		{
			ACCEPT
			{
				Tmgselection;
			}
		}
		LINK ID_FRACTURE_WEIGHT
		{
			ACCEPT
			{
				Tmgweight;
			}
		}
		SEPARATOR
		{
			LINE;
		}
		GROUP
		{	
			COLUMNS 2;
			
			BOOL ID_FRACTURE_COLORIZE { NAME ID_FRACTURE_COLORIZE; }
			STATICTEXT { JOINENDSCALE; }
			BOOL ID_FRACTURE_CREATENGONS { NAME ID_FRACTURE_CREATENGONS; }
			STATICTEXT { JOINENDSCALE; }
		
			REAL ID_FRACTURE_GAP { UNIT METER; MIN 0.0; STEP 0.1; }
			BOOL ID_FRACTURE_GAP_INVERT { NAME ID_FRACTURE_GAP_INVERT; }
			BOOL ID_FRACTURE_SHELL { NAME ID_FRACTURE_SHELL; }
			REAL ID_FRACTURE_THICKNESS { UNIT METER; STEP 0.1; }
		
			BOOL ID_FRACTURE_HOLLOW {NAME ID_FRACTURE_HOLLOW;}
			STATICTEXT { JOINENDSCALE; }
			BOOL ID_FRACTURE_AUTOCLOSE { NAME ID_FRACTURE_AUTOCLOSE; }
			STATICTEXT { JOINENDSCALE; }
		}
		SEPARATOR
		{
			LINE;
		}
		
		GROUP ID_FRACTURE_SCALE_GROUP
		{
			VECTOR	ID_FRACTURE_SCALE
			{
				MIN 0.01;
				MAX 100.0;
				STEP 0.01;
				CUSTOMGUI SUBDESCRIPTION;
			}
		}
	
		SEPARATOR
		{
			LINE;
		}
		BOOL ID_FRACTURE_SAVE_CACHE { NAME ID_FRACTURE_SAVE_CACHE; }
		BOOL ID_FRACTURE_AUTOMATIC_UPDATE { NAME ID_FRACTURE_AUTOMATIC_UPDATE; }
		BOOL ID_FRACTURE_AUTOMATIC_UPDATE_ANIMATION { NAME ID_FRACTURE_AUTOMATIC_UPDATE_ANIMATION; }
		BUTTON ID_FRACTURE_UPDATE { NAME ID_FRACTURE_UPDATE;}
	}
	
	GROUP ID_SOURCES
	{
		SCALE_V;
		DEFAULT 1;
		GROUP
		{
			BOOL ID_FRACTURE_SHOWPOINTS { NAME ID_FRACTURE_SHOWPOINTS; }
			REAL ID_FRACTURE_VIEWPORTRATIO		{ UNIT PERCENT; MIN 10.0; MAX 100.0; MAXSLIDER 100.0;	STEP 1.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP
		{
			SEPARATOR
			{
				LINE;
			}	
			IN_EXCLUDE ID_FRACTURE_INPUT_POINTS
			{
				NUM_FLAGS 2;
				INIT_STATE 3;
				SEND_SELCHNGMSG 1;
				SMALL_MODE_SIZE 80;
				BIG_MODE_SIZE 150;
				IMAGE_01_ON 300000131;
				IMAGE_01_OFF 300000130;
				IMAGE_02_ON 1037025;
				IMAGE_02_OFF 1037026;
				ACCEPT 
				{
					Obase;
					1001381; //TP GROUP
				}
				REFUSE { }
			}
			SEPARATOR
			{
				
			}	
			GROUP
			{
				COLUMNS 2;
				
				BUTTON ID_FRACTURE_CREATEDISTRIBUTION {NAME ID_FRACTURE_CREATEDISTRIBUTION;}
				BUTTON ID_FRACTURE_CREATESHADER {NAME ID_FRACTURE_CREATESHADER;}
			}	
		}
		
		GROUP
		{
			COLUMNS 2;
				
			BUTTON ID_FRACTURE_CREATEDISTRIBUTION {NAME ID_FRACTURE_CREATEDISTRIBUTION;}
			BUTTON ID_FRACTURE_CREATESHADER {NAME ID_FRACTURE_CREATESHADER;}
		}	
		GROUP ID_SOURCE_PROPERTIES
		{
			SEPARATOR
			{
			
			}	
			DEFAULT 1;
		}
				
		OPEN;
	}
	
	GROUP ID_FRACTURE_SORTTAB
	{
		BOOL ID_FRACTURE_ACTIVATE_SORTORDER { NAME ID_FRACTURE_ACTIVATE_SORTORDER; }
		BOOL ID_FRACTURE_INVERT_SORTORDER { NAME ID_FRACTURE_INVERT_SORTORDER; }
		LONG ID_FRACTURE_SORTORDER
		{
			CYCLE
			{
				ID_FRACTURE_SORTORDER_X;
				ID_FRACTURE_SORTORDER_Y;
				ID_FRACTURE_SORTORDER_Z;
				ID_FRACTURE_SORTORDER_USER;
			}
			CUSTOMGUI RADIOBUTTONS; COLUMNS 4;
			ANIM ON;
		}
		VECTOR	ID_FRACTURE_SORTORDER_USER_VECTOR
		{
			MIN -1.0;
			MAX 1.0;
			STEP 0.01;
		}
		 
		LINK ID_FRACTURE_SORT_OBJECTDISTANCE
		{
			ACCEPT
			{
				Obase;
			}
		}
		BOOL ID_FRACTURE_SORT_SPLINESTEP { NAME ID_FRACTURE_SORT_SPLINESTEP; }
	}
	
	GROUP ID_FRACTURE_DETAILING_TAB
	{
		GROUP
		{
			COLUMNS 2;

			BOOL ID_FRACTURE_DETAILING_ENABLE { NAME ID_FRACTURE_DETAILING_ENABLE;}
			STATICTEXT { JOINENDSCALE; }
			BOOL ID_FRACTURE_DETAILING_ACTIVATE_IN_VIEWPORT { NAME ID_FRACTURE_DETAILING_ACTIVATE_IN_VIEWPORT;}
			STATICTEXT { JOINENDSCALE; }

			SEPARATOR
			{
				LINE;
			}
			STATICTEXT { JOINENDSCALE; }
			
			LONG ID_FRACTURE_DETAILING_MESH_DETAIL{MIN 0; MAX 7; STEP 1;}
			STATICTEXT { JOINENDSCALE; }
			REAL ID_FRACTURE_DETAILING_MESH_DETAIL_LENGTH { UNIT METER; MIN 0.1; STEP 1;}
			STATICTEXT { DUMMY; }

			BOOL ID_FRACTURE_DETAILING_NOISE_EDGES { NAME ID_FRACTURE_DETAILING_NOISE_EDGES;}
			REAL ID_FRACTURE_DETAILING_NOISE_EDGES_FEATURE_PRESERVE { MIN 1.0; STEP 1.0;}
		
			BOOL ID_FRACTURE_DETAILING_SMOOTH_NORMALS { NAME ID_FRACTURE_DETAILING_SMOOTH_NORMALS; }
			STATICTEXT { JOINENDSCALE; }
			BOOL ID_FRACTURE_DETAILING_SMOOTH_USE_ORIGINAL_EDGES { NAME ID_FRACTURE_DETAILING_SMOOTH_USE_ORIGINAL_EDGES; }
			STATICTEXT { JOINENDSCALE; }
			REAL ID_FRACTURE_DETAILING_SMOOTH_NORMALS_ANGLE { UNIT DEGREE; MIN 0.0; MAX 180.0; }
			STATICTEXT { JOINENDSCALE; }
			
			LONG ID_FRACTURE_DETAILING_RELAX_INSIDE_EDGES { MIN 0; STEP 1; }
			STATICTEXT { JOINENDSCALE; }
		
			BOOL ID_FRACTURE_DETAILING_KEEP_ORIGINAL_SURFACE { NAME ID_FRACTURE_DETAILING_KEEP_ORIGINAL_SURFACE; }
			STATICTEXT { JOINENDSCALE; }
		}
		GROUP ID_FRACTURE_DETAILING_NOISE_GROUP
		{
			OPEN;
			DEFAULT 1;
			LONG ID_FRACTURE_DETAILING_NOISE_TYPE
			{
				CYCLE 
				{
						ID_FRACTURE_DETAILING_NOISE_TYPE_BOX;
						ID_FRACTURE_DETAILING_NOISE_TYPE_BLISTEREDTURBULENCE;
						ID_FRACTURE_DETAILING_NOISE_TYPE_BUYA;
						ID_FRACTURE_DETAILING_NOISE_TYPE_CELL;
						ID_FRACTURE_DETAILING_NOISE_TYPE_CRANAL;
						ID_FRACTURE_DETAILING_NOISE_TYPE_DENTS;
						ID_FRACTURE_DETAILING_NOISE_TYPE_DISPLACEDTURBULENCE;
						ID_FRACTURE_DETAILING_NOISE_TYPE_ELECTRIC;
						ID_FRACTURE_DETAILING_NOISE_TYPE_FBM;
						ID_FRACTURE_DETAILING_NOISE_TYPE_GASEOUS;
						ID_FRACTURE_DETAILING_NOISE_TYPE_HAMA;
						ID_FRACTURE_DETAILING_NOISE_TYPE_LUKA;
						ID_FRACTURE_DETAILING_NOISE_TYPE_MODNOISE;
						ID_FRACTURE_DETAILING_NOISE_TYPE_NAKI;
						ID_FRACTURE_DETAILING_NOISE_TYPE_NUTOUS;
						ID_FRACTURE_DETAILING_NOISE_TYPE_OBER;
						ID_FRACTURE_DETAILING_NOISE_TYPE_PEZO;
						ID_FRACTURE_DETAILING_NOISE_TYPE_POXO;
						ID_FRACTURE_DETAILING_NOISE_TYPE_SEMA;
						ID_FRACTURE_DETAILING_NOISE_TYPE_STUPL;
						ID_FRACTURE_DETAILING_NOISE_TYPE_TURBULENCE;
						ID_FRACTURE_DETAILING_NOISE_TYPE_VLNOISE;
						ID_FRACTURE_DETAILING_NOISE_TYPE_WAVYTURBULENCE;
						ID_FRACTURE_DETAILING_NOISE_TYPE_CELLVORONOI;
						ID_FRACTURE_DETAILING_NOISE_TYPE_DISPLACEDVORONOI;
						ID_FRACTURE_DETAILING_NOISE_TYPE_VORONOI1;
						ID_FRACTURE_DETAILING_NOISE_TYPE_VORONOI2;
						ID_FRACTURE_DETAILING_NOISE_TYPE_VORONOI3;
						ID_FRACTURE_DETAILING_NOISE_TYPE_ZADA;
						ID_FRACTURE_DETAILING_NOISE_TYPE_PERLIN;
						ID_FRACTURE_DETAILING_NOISE_TYPE_RIDGEDMULTIFRACTAL;
				}
				SCALE_H;
			}
			
			REAL ID_FRACTURE_DETAILING_NOISE_STRENGTH { UNIT METER; STEP 0.1;}
			LONG ID_FRACTURE_DETAILING_NOISE_SEED { MIN 0; STEP 1; }

			
			LONG ID_FRACTURE_DETAILING_NOISE_OCTAVES{MIN 0; MAX 16; STEP 1; SCALE_H;}
			REAL	ID_FRACTURE_DETAILING_NOISE_GLOBAL_SCALE { UNIT PERCENT; MIN 0.0; STEP 1.0; }
			VECTOR	ID_FRACTURE_DETAILING_NOISE_RELATIVE_SCALE { UNIT PERCENT; MIN 0.0; STEP 1.0; }
			REAL ID_FRACTURE_DETAILING_NOISE_ANIMATION_SPEED { MIN 0.0; STEP 0.1;}
			REAL ID_FRACTURE_DETAILING_NOISE_LOW_CLIP { UNIT PERCENT; MIN 0.0; MAX 100.0; MAXSLIDER 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
			REAL ID_FRACTURE_DETAILING_NOISE_HIGH_CLIP { UNIT PERCENT; MIN 0.0; MAX 100.0; MAXSLIDER 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
			SPLINE ID_FRACTURE_DETAILING_NOISE_DEPTH_NOISE_RAMP { }
		}	
	}
	
	GROUP ID_FRACTURE_AUTOCONNECTOR_TAB
	{
		BUTTON ID_FRACTURE_AUTOCONNECTOR_ENABLE { NAME ID_FRACTURE_AUTOCONNECTOR_ENABLE;}
		
		LINK ID_FRACTURE_AUTOCONNECTOR_TEMPLATE_LINK 
		{
			ACCEPT
			{
				180000010; // SPRING_OBJECT_ID
				180000011; // CONSTRAINT_OBJECT_ID
				180000012; // MOTOR_OBJECT_ID
			}
		}
	
		SEPARATOR
		{
			LINE;
		}
		
		LINK ID_FRACTURE_AUTOCONNECTOR_BREAKING_VALUE_WEIGHT
		{ 
			ACCEPT 
			{
				Tmgweight;
			}
		}
		LINK ID_FRACTURE_AUTOCONNECTOR_BREAKING_VALUE_TORQUE_WEIGHT
		{ 
			ACCEPT 
			{
				Tmgweight;
			}
		}
		
		IN_EXCLUDE ID_FRACTURE_AUTOCONNECTOR_FALLOFF
		{
			NUM_FLAGS 1;
			INIT_STATE 1;
			SMALL_MODE_SIZE 80;
			BIG_MODE_SIZE 150;
			IMAGE_01_ON 300000131;
			IMAGE_01_OFF 300000130;
			ACCEPT 
			{
				Ofalloffobject;
				1038144; //ID_FALLOFF
			}
			REFUSE { }
		}
		BUTTON ID_FRACTURE_AUTOCONNECTOR_ADD_FALLOFF {NAME ID_FRACTURE_AUTOCONNECTOR_ADD_FALLOFF;}
		
	}
	
	GROUP ID_FRACTURE_GLUE_TAB
	{
		GROUP
		{
			COLUMNS 2;
			BOOL ID_FRACTURE_GLUE_ACTIVATE {NAME ID_FRACTURE_GLUE_ACTIVATE;}
			STATICTEXT { JOINENDSCALE; }
			LONG ID_FRACTURE_GLUE_TYPE
				{
					CYCLE 
					{
						ID_FRACTURE_GLUE_TYPE_FALLOFF;
						ID_FRACTURE_GLUE_TYPE_CLUSTER;
						ID_FRACTURE_GLUE_TYPE_DISTANCE;
					}
					SCALE_H;
				}
				STATICTEXT { JOINENDSCALE; }
			BOOL ID_FRACTURE_GLUE_REST { NAME ID_FRACTURE_GLUE_REST;}
			STATICTEXT { JOINENDSCALE; }
			
			LONG ID_FRACTURE_GLUE_CLUSTERSIZE { MIN 1; STEP 1;}
			STATICTEXT { JOINENDSCALE; }
			LONG ID_FRACTURE_GLUE_CLUSTERSEED { MIN 0; STEP 1;}
			STATICTEXT { JOINENDSCALE; }


			REAL ID_FRACTURE_GLUE_DISTANCE { UNIT METER; MIN 0.0; STEP 0.1;} 
			BOOL ID_FRACTURE_GLUE_DISTANCE_SWITCH { NAME ID_FRACTURE_GLUE_DISTANCE_SWITCH;}
			
			IN_EXCLUDE ID_FRACTURE_GLUE_FALLOFF
			{
				NUM_FLAGS 1;
				INIT_STATE 1;
				SMALL_MODE_SIZE 80;
				BIG_MODE_SIZE 150;
				IMAGE_01_ON 300000131;
				IMAGE_01_OFF 300000130;
				ACCEPT 
				{
					Ofalloffobject;
					1038144; //ID_FALLOFF
				}
				REFUSE { }
			}
			STATICTEXT { JOINENDSCALE; }
		}
		BUTTON ID_FRACTURE_GLUE_ADD_FALLOFF {NAME ID_FRACTURE_GLUE_ADD_FALLOFF;}
	}

	INCLUDE otransform_panel;
	
	
	GROUP ID_MG_VF_MOTIONGENERATOR_GROUP_EFFECTORS
	{
		SCALE_V;
		GROUP
		{
			SCALE_V;
			IN_EXCLUDE	ID_MG_VF_MOTIONGENERATOR_EFFECTORLIST
			{
				NUM_FLAGS 1;
				INIT_STATE 1;
				SCALE_V;
				IMAGE_01_ON 300000131;
				IMAGE_01_OFF 300000130;

				ACCEPT
				{
					Obaseeffector;
				}
			}
		}
		OPEN;
	}
	GROUP ID_FRACTURE_SELECTION_TAGS
	{
		COLUMNS 3;

		BOOL ID_FRACTURE_CREATE_INSIDE_FACE_SELECTION { ANIM OFF; NAME ID_FRACTURE_CREATE_INSIDE_FACE_SELECTION;}
		BOOL ID_FRACTURE_CREATE_INSIDE_VERTEX_SELECTION { ANIM OFF; NAME ID_FRACTURE_CREATE_INSIDE_VERTEX_SELECTION;}
		BOOL ID_FRACTURE_CREATE_INSIDE_VERTEXMAP { ANIM OFF; NAME ID_FRACTURE_CREATE_INSIDE_VERTEXMAP;}
		BOOL ID_FRACTURE_CREATE_OUTSIDE_FACE_SELECTION { ANIM OFF; NAME ID_FRACTURE_CREATE_OUTSIDE_FACE_SELECTION;}
		BOOL ID_FRACTURE_CREATE_OUTSIDE_VERTEX_SELECTION { ANIM OFF; NAME ID_FRACTURE_CREATE_OUTSIDE_VERTEX_SELECTION;}
		BOOL ID_FRACTURE_CREATE_OUTSIDE_VERTEXMAP { ANIM OFF; NAME ID_FRACTURE_CREATE_OUTSIDE_VERTEXMAP;}
		BOOL ID_FRACTURE_CREATE_EDGE_SELECTION { ANIM OFF; NAME ID_FRACTURE_CREATE_EDGE_SELECTION;}
		BOOL ID_FRACTURE_CREATE_EDGE_VERTEX_SELECTION { ANIM OFF; NAME ID_FRACTURE_CREATE_EDGE_VERTEX_SELECTION;}
		BOOL ID_FRACTURE_CREATE_EDGE_VERTEXMAP { ANIM OFF; NAME ID_FRACTURE_CREATE_EDGE_VERTEXMAP;}
	}
}
