CONTAINER Tcaik
{
	NAME Tcaik;
	INCLUDE Texpression;

	GROUP ID_TAGPROPERTIES
	{
		GROUP
		{

			BOOL ID_CA_IK_TAG_ENABLE { }
			LONG ID_CA_IK_TAG_SOLVER
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					ID_CA_IK_TAG_SOLVER_2D;
					ID_CA_IK_TAG_SOLVER_3D;
				}
			}
			
			BOOL ID_CA_IK_TAG_SPLINE { }
			STATICTEXT { NEWLINE; }

			LONG ID_CA_IK_TAG_START_INDEX { MIN 0; }
			LONG ID_CA_IK_TAG_END_INDEX { MIN 0; }		

			LINK ID_CA_IK_TAG_TIP { ACCEPT { Obase; } }
			STATICTEXT { JOINEND; }
			
			LINK ID_CA_IK_TAG_TARGET { ACCEPT { Obase; } }
			BUTTON ID_CA_IK_TAG_ADD_GOAL { }
						
			REAL ID_CA_IK_TAG_IKFK { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			BUTTON ID_CA_IK_TAG_RESET_FK { }

			REAL ID_CA_IK_TAG_STRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINEND; }
 
			REAL ID_CA_IK_TAG_PREFERRED_WEIGHT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINEND; }
			
			REAL ID_CA_IK_TAG_GOAL_OFFSET { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINEND; }

			GROUP ID_CA_IK_TAG_POLE_GROUP
			{
				DEFAULT 1;
				
				LONG ID_CA_IK_TAG_POLE_AXIS
				{
					CUSTOMGUI QUICKTABRADIO;
					CYCLE
					{
						ID_CA_IK_TAG_POLE_AXIS_AUTO;
						ID_CA_IK_TAG_POLE_AXIS_X;
						ID_CA_IK_TAG_POLE_AXIS_Y;
						ID_CA_IK_TAG_POLE_AXIS_Z;
						ID_CA_IK_TAG_POLE_AXIS_NX;
						ID_CA_IK_TAG_POLE_AXIS_NY;
						ID_CA_IK_TAG_POLE_AXIS_NZ;					
					}
				}
				REAL ID_CA_IK_TAG_POLE_TWIST { UNIT DEGREE; MINSLIDER -180.0; MAXSLIDER 180.0; CUSTOMGUI REALSLIDER; }
				
				LINK ID_CA_IK_TAG_POLE { ACCEPT { Obase; } }
				BUTTON ID_CA_IK_TAG_ADD_POLE { }
			}
			
			GROUP ID_CA_IK_TAG_STRETCH_GROUP
			{
				REAL ID_CA_IK_TAG_SQUASH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				LONG ID_CA_IK_TAG_SQUASH_TYPE
				{
					CYCLE
					{
						ID_CA_IK_TAG_STRETCH_TYPE_POSITION;
						ID_CA_IK_TAG_STRETCH_TYPE_SCALE_UNIFORM;
						ID_CA_IK_TAG_STRETCH_TYPE_SCALE_BONE;
						ID_CA_IK_TAG_STRETCH_TYPE_SCALE_VOLUME;
					}
				}
				
				REAL ID_CA_IK_TAG_SQUASH_CLAMP_DIST { UNIT METER; MIN 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
				BOOL ID_CA_IK_TAG_SQUASH_CLAMP {}
				
				REAL ID_CA_IK_TAG_STRETCH { SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				LONG ID_CA_IK_TAG_STRETCH_TYPE
				{
					CYCLE
					{
						ID_CA_IK_TAG_STRETCH_TYPE_POSITION;
						ID_CA_IK_TAG_STRETCH_TYPE_SCALE_UNIFORM;
						ID_CA_IK_TAG_STRETCH_TYPE_SCALE_BONE;
						ID_CA_IK_TAG_STRETCH_TYPE_SCALE_VOLUME;
					}
				}
				
				REAL ID_CA_IK_TAG_STRETCH_CLAMP_DIST { UNIT METER; MIN 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
				BOOL ID_CA_IK_TAG_STRETCH_CLAMP {}				
			}
		}
	}
	
	GROUP ID_CA_IK_TAG_DISPLAY_GROUP
	{
		GROUP
		{
			BOOL ID_CA_IK_TAG_DRAW_FK_CHAIN { }
			BOOL ID_CA_IK_TAG_DRAW_IK_CHAIN { }

			BOOL ID_CA_IK_TAG_DRAW_HANDLE_LINE { }
			LONG ID_CA_IK_TAG_DRAW_POLE
			{
				CYCLE
				{
					ID_CA_IK_TAG_DRAW_POLE_NONE;
					ID_CA_IK_TAG_DRAW_POLE_ROOT;
					ID_CA_IK_TAG_DRAW_POLE_JOINT;
				}
			}
		}

		SEPARATOR { }

		COLOR ID_CA_IK_TAG_DRAW_FK_COLOR { }
		COLOR ID_CA_IK_TAG_DRAW_IK_COLOR { }
		COLOR ID_CA_IK_TAG_DRAW_HANDLE_COLOR { }
		COLOR ID_CA_IK_TAG_DRAW_POLE_COLOR { }
	}

	GROUP ID_CA_IK_TAG_SOLVER_GROUP
	{
		BOOL ID_CA_IK_TAG_GOAL_UPDATE { }
		BOOL ID_CA_IK_TAG_GOAL_CONSTRAIN { }

		BOOL ID_CA_IK_TAG_GOAL_DIRTY { }
		BOOL ID_CA_IK_TAG_ALIGN_GOAL { }

		BOOL ID_CA_IK_TAG_UPDATEFKIK { }
		STATICTEXT { JOINEND; }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }

		LONG ID_CA_IK_TAG_SOLVER_ITERATIONS_MAX { MIN 0; MAX 9999; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI LONGSLIDER; }
		STATICTEXT { JOINENDSCALE; }
		
		REAL ID_CA_IK_TAG_SOLVER_THRESHOLD { UNIT METER; MIN 0.0; MAX 100000.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
		STATICTEXT { JOINENDSCALE; }
	}
	
	GROUP ID_CA_IK_TAG_DYNAMICS_GROUP
	{
		GROUP
		{
			BOOL ID_CA_IK_TAG_DYNAMICS_ENABLE { }
								
			REAL ID_CA_IK_TAG_DYNAMICS_STIFFNESS { UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			REAL ID_CA_IK_TAG_DYNAMICS_DRAG { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			
			REAL ID_CA_IK_TAG_DYNAMICS_POSHOLD { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			REAL ID_CA_IK_TAG_DYNAMICS_ROTHOLD { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			
			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }
			
			BOOL ID_CA_IK_TAG_DYNAMICS_COLLISIONS { }
			REAL ID_CA_IK_TAG_DYNAMICS_RADIUS { UNIT METER; }
			
			REAL ID_CA_IK_TAG_DYNAMICS_FRICTION { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			REAL ID_CA_IK_TAG_DYNAMICS_BOUNCE { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }			
		}
				
		GROUP ID_CA_IK_TAG_DYNAMICS_COLLIDERS_GROUP
		{
			SCALE_V; COLUMNS 1; DEFAULT 1;
									
			IN_EXCLUDE  ID_CA_IK_TAG_DYNAMICS_COLLIDERS
			{
				NUM_FLAGS 0; INIT_STATE 1; SEND_SELCHNGMSG 1;
				ACCEPT { Obase; };
			}
		}
		
		GROUP ID_CA_IK_TAG_DYNAMICS_CURVES_GROUP
		{
			SPLINE ID_CA_IK_TAG_DYNAMICS_POSHOLD_CURVE {  }		
			
			SPLINE ID_CA_IK_TAG_DYNAMICS_ROTHOLD_CURVE {  }				
		}
		
		GROUP ID_CA_IK_TAG_DYNAMICS_FORCES_GROUP
		{
			SCALE_V; COLUMNS 1;
			
			GROUP
			{
				REAL ID_CA_IK_TAG_DYNAMICS_GRAVITY { UNIT METER; STEP 0.1; }

				SEPARATOR { }

				LONG ID_CA_IK_TAG_DYNAMICS_FORCES_INCEXC
				{
					CYCLE
					{
						ID_CA_IK_TAG_DYNAMICS_INCEXC_INCLUDE;
						ID_CA_IK_TAG_DYNAMICS_INCEXC_EXCLUDE;
					}
				}
			}
						
			IN_EXCLUDE  ID_CA_IK_TAG_DYNAMICS_FORCES
			{
				NUM_FLAGS 0; INIT_STATE 1; SEND_SELCHNGMSG 1;
				ACCEPT { Obase; };
			}
		}
		
		GROUP ID_CA_IK_TAG_DYNAMICS_ADVANCED_GROUP
		{
			BOOL ID_CA_IK_TAG_DYNAMICS_CUPDATE { ANIM OFF; }
			
			LONG ID_CA_IK_TAG_DYNAMICS_SUBDIV { MIN 1; MAX 100; }

			SEPARATOR { }

				BOOL ID_CA_IK_TAG_DYNAMICS_AUTOTIME { ANIM OFF; }

				BASETIME ID_CA_IK_TAG_DYNAMICS_START { ANIM OFF; }
				BASETIME ID_CA_IK_TAG_DYNAMICS_STOP  { ANIM OFF; }
		}
	}
}
