CONTAINER Ocajiggle
{
	NAME Ocajiggle;
	INCLUDE Obase;
	
	GROUP ID_OBJECTPROPERTIES
	{
					
		BOOL ID_CA_JIGGLE_OBJECT_ONSTOP { }
		BOOL ID_CA_JIGGLE_OBJECT_LOCAL { }
		
		LINK ID_CA_JIGGLE_OBJECT_SOURCE { HIDDEN; ACCEPT { Obase; Tbase; } }
		STATICTEXT { JOINEND; }
		
		REAL ID_CA_JIGGLE_OBJECT_STRENGTH { UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		STATICTEXT { JOINEND; }
		
		REAL ID_CA_JIGGLE_OBJECT_STIFFNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
		LINK ID_CA_JIGGLE_OBJECT_STIFFNESS_MAP { SCALE_H; ACCEPT { Tbase; } }
		
		REAL ID_CA_JIGGLE_OBJECT_STRUCTUAL_STIFFNESS { SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }			
		LINK ID_CA_JIGGLE_OBJECT_STRUCTUAL_STIFFNESS_MAP { SCALE_H; ACCEPT { Tbase; } }
		
		REAL ID_CA_JIGGLE_OBJECT_DRAG { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
		LINK ID_CA_JIGGLE_OBJECT_DRAG_MAP { SCALE_H; ACCEPT { Tbase; } }
		
		REAL ID_CA_JIGGLE_OBJECT_MOTION_SCALE { UNIT PERCENT; MIN 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
		STATICTEXT { JOINEND; }
		
		GROUP ID_CA_JIGGLE_OBJECT_CACHE_ADVANCED
		{
						
			LONG ID_CA_JIGGLE_OBJECT_SPRINGS { MIN 0; MAX 100; }
			LONG ID_CA_JIGGLE_OBJECT_ITERATIONS { MIN 1; MAX 1000; }
		}
	}
		
	GROUP ID_CA_JIGGLE_OBJECT_RESTRICTION_GROUP
	{
		SCALE_V; COLUMNS 1;
				
		IN_EXCLUDE  ID_CA_JIGGLE_OBJECT_RESTRICT
		{
			NUM_FLAGS 0; INIT_STATE 1; SEND_SELCHNGMSG 1; SCALE_V;
			ACCEPT { Obase; Tbase; };
		}
	}
	
	GROUP ID_CA_JIGGLE_OBJECT_FORCES_GROUP
	{
		SCALE_V;
		
		REAL ID_CA_JIGGLE_OBJECT_GRAVITY { }
		LINK ID_CA_JIGGLE_OBJECT_FORCES_MAP { ACCEPT { Tbase; } }

		IN_EXCLUDE  ID_CA_JIGGLE_OBJECT_FORCES
		{
			NUM_FLAGS 0; INIT_STATE 1; SEND_SELCHNGMSG 1; SCALE_V;
			ACCEPT { Obase; };
		}
		STATICTEXT { JOINENDSCALE; }
	}
	
	GROUP ID_CA_JIGGLE_OBJECT_CACHE_GROUP
	{
		BOOL ID_CA_JIGGLE_OBJECT_CACHE_ENABLE { }

		SEPARATOR { LINE; }

		BOOL ID_CA_JIGGLE_OBJECT_CACHE_COMPRESSED { SCALE_H; ANIM OFF; }
		STATICTEXT ID_CA_JIGGLE_OBJECT_CACHE_INFO2 { SCALE_H; }

		GROUP
		{
			COLUMNS 3;

			BUTTON ID_CA_JIGGLE_OBJECT_CACHE_CALCULATE {  SCALE_H; }
			BUTTON ID_CA_JIGGLE_OBJECT_CACHE_UPDATE {  SCALE_H; }
			BUTTON ID_CA_JIGGLE_OBJECT_CACHE_DELETE { SCALE_H; }
		}

		GROUP
		{
			COLUMNS 2;

			BUTTON ID_CA_JIGGLE_OBJECT_CACHE_CACHE_LOAD {  SCALE_H; }
			BUTTON ID_CA_JIGGLE_OBJECT_CACHE_CACHE_SAVE {  SCALE_H; }
		}	
		
		BOOL ID_CA_JIGGLE_OBJECT_CACHE_AUTOTIME { ANIM OFF; }

		BASETIME ID_CA_JIGGLE_OBJECT_CACHE_START { ANIM OFF; }
		BASETIME ID_CA_JIGGLE_OBJECT_CACHE_STOP  { ANIM OFF; }
			
		BASETIME ID_CA_JIGGLE_OBJECT_CACHE_OFFSET { ANIM OFF; }			
		REAL ID_CA_JIGGLE_OBJECT_CACHE_TIMESCALE { UNIT PERCENT; MIN 0.0; }
			
		LONG ID_CA_JIGGLE_OBJECT_CACHE_CACHE_LIMIT { MIN 1; MAX 1000; ANIM OFF; }
		STATICTEXT ID_CA_JIGGLE_OBJECT_CACHE_TEXT_LIMIT {}
		}
	}
}