CONTAINER Trsobject
{
	NAME Trsobject;
	INCLUDE Tbase;

	GROUP REDSHIFT_OBJECT_GROUP_PARTICLES
	{
		DEFAULT 1; // Start open
		SCALE_V;
		HIDDEN;

		GROUP
		{
			SCALE_V; COLUMNS 1;
			LONG REDSHIFT_OBJECT_PARTICLE_MODE
			{
				CYCLE
				{
					REDSHIFT_OBJECT_PARTICLE_MODE_NONE;
					REDSHIFT_OBJECT_PARTICLE_MODE_POINTCLOUD_INSTANCED_POINTS;
					REDSHIFT_OBJECT_PARTICLE_MODE_POINTCLOUD_INSTANCED_SPHERES;
					REDSHIFT_OBJECT_PARTICLE_MODE_POINTCLOUD_INSTANCED_QUADS;
					REDSHIFT_OBJECT_PARTICLE_MODE_POINTCLOUD_INSTANCED_CUSTOM;
					REDSHIFT_OBJECT_PARTICLE_MODE_POINTCLOUD_SPHERES;
				}
				ANIM OFF;
			}

			IN_EXCLUDE REDSHIFT_OBJECT_PARTICLE_CUSTOM_OBJECTS
			{
				SCALE_V; NUM_FLAGS 0;
				ACCEPT { Obase; };
				ANIM OFF;
			}
		}

		GROUP
		{
			BOOL REDSHIFT_OBJECT_PARTICLE_CUSTOM_OBJECTS_VISIBLE
			{
				ANIM OFF;
			}

			LONG REDSHIFT_OBJECT_PARTICLE_OBJECT_DISTRIBUTION
			{
				CYCLE
				{
					REDSHIFT_OBJECT_PARTICLE_OBJECT_DISTRIBUTION_TYPE_SEQUENTIAL;
					REDSHIFT_OBJECT_PARTICLE_OBJECT_DISTRIBUTION_TYPE_RANDOM;
					REDSHIFT_OBJECT_PARTICLE_OBJECT_DISTRIBUTION_TYPE_RANDOM_LEGACY;
				}
				ANIM OFF;
			}

			LONG REDSHIFT_OBJECT_PARTICLE_OBJECT_DISTRIBUTION_SEED
			{
				MIN 0;
				ANIM OFF;
			}

			SEPARATOR { LINE; }
			REAL REDSHIFT_OBJECT_PARTICLE_SCALE { MIN 0.001; MAXSLIDER 100.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		}
	}

	GROUP REDSHIFT_OBJECT_GROUP_VOLUME
	{
		DEFAULT 1; // Start open
		HIDDEN;
		REAL REDSHIFT_OBJECT_VOLUME_STEP
		{
			CUSTOMGUI REALSLIDER;
			MIN 0.001;
			MINSLIDER 0.1;
			MAXSLIDER 10;
			STEP 0.01;
		}
	}

	GROUP REDSHIFT_OBJECT_GROUP_CURVE
	{
		DEFAULT 1; // Start open
		HIDDEN;

		LONG REDSHIFT_OBJECT_CURVE_MODE
		{
			CYCLE
			{
				REDSHIFT_OBJECT_CURVE_MODE_NONE;
				REDSHIFT_OBJECT_CURVE_MODE_HAIR;
				REDSHIFT_OBJECT_CURVE_MODE_MESH_BOX;
				REDSHIFT_OBJECT_CURVE_MODE_MESH_CYLINDER;
				REDSHIFT_OBJECT_CURVE_MODE_MESH_CAPSULE;
				REDSHIFT_OBJECT_CURVE_MODE_MESH_CONE;
				REDSHIFT_OBJECT_CURVE_MODE_MESH_STRIP;
			}
		}

		REAL REDSHIFT_OBJECT_CURVE_THICKNESS
		{
			CUSTOMGUI REALSLIDER;
			MIN 0.001;
			MINSLIDER 0.1;
			MAXSLIDER 100;
			STEP 0.01;
		}

		SPLINE REDSHIFT_OBJECT_CURVE_SCALE
		{
		}

		LONG REDSHIFT_OBJECT_CURVE_INTERPOLATION_MODE
		{
			CYCLE
			{
				REDSHIFT_OBJECT_CURVE_INTERPOLATION_MODE_PRECISE;
				REDSHIFT_OBJECT_CURVE_INTERPOLATION_MODE_FAST;
			}
		}

		BOOL REDSHIFT_OBJECT_CURVE_RESAMPLE_ENABLED
		{
		}

		LONG REDSHIFT_OBJECT_CURVE_RESAMPLE_STEPS
		{
			MIN 2;
			CUSTOMGUI LONGSLIDER;
			MAXSLIDER 200;
		}

		LONG REDSHIFT_OBJECT_CURVE_MESH_SUBDIVISION_TYPE
		{
			CYCLE
			{
				REDSHIFT_OBJECT_CURVE_MESH_SUBDIVISION_TYPE_NONE;
				REDSHIFT_OBJECT_CURVE_MESH_SUBDIVISION_TYPE_FIXED;
				REDSHIFT_OBJECT_CURVE_MESH_SUBDIVISION_TYPE_ADAPTIVE;
			}
		}

		LONG REDSHIFT_OBJECT_CURVE_MESH_MAX_SUBDIVISIONS
		{
			MIN 0;
			MAX 8;
			CUSTOMGUI LONGSLIDER;
			MAXSLIDER 8;
		}
	}

	GROUP REDSHIFT_OBJECT_TAB_VISIBILITY
	{
		DEFAULT 1; // Start open
		BOOL REDSHIFT_OBJECT_VISIBILITY_OVERRIDE { }
		GROUP REDSHIFT_OBJECT_GROUP_VISIBILITY_GENERAL
		{
			DEFAULT 1; // Start open
			COLUMNS 2;
			BOOL REDSHIFT_OBJECT_VISIBILITY_PRIMARYRAYVISIBLE { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_SECONDARYRAYVISIBLE { }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }

			BOOL REDSHIFT_OBJECT_VISIBILITY_SHADOWCASTER { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_SHADOWRECEIVER { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_SELFSHADOWS { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_AOCASTER { }
		}

		GROUP REDSHIFT_OBJECT_GROUP_VISIBILITY_REFLECTION_REFRACTION
		{
			DEFAULT 1; // Start open
			COLUMNS 2;

			BOOL REDSHIFT_OBJECT_VISIBILITY_REFLECTIONVISIBLE { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_REFRACTIONVISIBLE { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_REFLECTIONCASTER { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_REFRACTIONCASTER { }

		}

		GROUP REDSHIFT_OBJECT_GROUP_VISIBILITY_GLOBAL_ILLUMINATION
		{
			DEFAULT 1; // Start open
			COLUMNS 2;

			BOOL REDSHIFT_OBJECT_VISIBILITY_FGVISIBLE { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_CAUSTICVISIBLE { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_FGCASTER { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_FORCEBRUTEFORCEGI { }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }

			BOOL REDSHIFT_OBJECT_VISIBILITY_CAUSTICCASTER { }
			BOOL REDSHIFT_OBJECT_VISIBILITY_CAUSTICSRECEIVER { }

			//BOOL REDSHIFT_OBJECT_VISIBILITY_GIVISIBLE_DEPRECATED { }
			//BOOL REDSHIFT_OBJECT_VISIBILITY_GICASTER_DEPRECATED { }
			//BOOL REDSHIFT_OBJECT_VISIBILITY_GIRECEIVER_DEPRECATED { }
		}
	}

	GROUP REDSHIFT_OBJECT_TAB_GEOMETRY
	{
		BOOL REDSHIFT_OBJECT_GEOMETRY_OVERRIDE { }
		GROUP REDSHIFT_OBJECT_GROUP_GEOMETRY_TESSELATION
		{
			DEFAULT 1; // Start open
			BOOL REDSHIFT_OBJECT_GEOMETRY_SUBDIVISIONENABLED { }
			LONG REDSHIFT_OBJECT_GEOMETRY_SUBDIVISIONRULE
			{
				CYCLE
				{
					REDSHIFT_OBJECT_GEOMETRY_SUBDIVISIONRULE_CATMULLCLARKLOOP;
					REDSHIFT_OBJECT_GEOMETRY_SUBDIVISIONRULE_CATMULLCLARK;
				}
			}
			BOOL REDSHIFT_OBJECT_GEOMETRY_SCREENSPACEADAPTIVE { }
			BOOL REDSHIFT_OBJECT_GEOMETRY_SMOOTHSUBDIVISIONENABLED { }
			LONG REDSHIFT_OBJECT_GEOMETRY_UVSMOOTHINGMODE
			{
				CYCLE
				{
					REDSHIFT_OBJECT_GEOMETRY_UVSMOOTHINGMODE_DISABLED;
					REDSHIFT_OBJECT_GEOMETRY_UVSMOOTHINGMODE_ALL_EDGES;
					REDSHIFT_OBJECT_GEOMETRY_UVSMOOTHINGMODE_INTERNAL_EDGES;
				}
			}

			REAL REDSHIFT_OBJECT_GEOMETRY_MINTESSELLATIONLENGTH { MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 32.0; }
			LONG REDSHIFT_OBJECT_GEOMETRY_MAXTESSELLATIONSUBDIVS { MIN 0; MAX 16; CUSTOMGUI LONGSLIDER; }
			REAL REDSHIFT_OBJECT_GEOMETRY_OUTOFFRUSTUMTESSELLATIONFACTOR { MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 32.0; }
			BOOL REDSHIFT_OBJECT_GEOMETRY_LIMITOUTOFFRUSTUMTESSELLATION { }
			LONG REDSHIFT_OBJECT_GEOMETRY_MAXOUTOFFRUSTUMTESSELLATIONSUBDIVS { MIN 0; MAX 16; CUSTOMGUI LONGSLIDER; }
		}

		GROUP REDSHIFT_OBJECT_GROUP_GEOMETRY_DISPLACEMENT
		{
			DEFAULT 1; // Start open
			BOOL REDSHIFT_OBJECT_GEOMETRY_DISPLACEMENTENABLED { }
			REAL REDSHIFT_OBJECT_GEOMETRY_MAXDISPLACEMENT { MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 1000.0; }
			REAL REDSHIFT_OBJECT_GEOMETRY_DISPLACEMENTSCALE { MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; }
			BOOL REDSHIFT_OBJECT_GEOMETRY_AUTOBUMPENABLED { }
		}

		GROUP REDSHIFT_OBJECT_GROUP_REFERENCE
		{
			DEFAULT 1;
			LONG REDSHIFT_OBJECT_REFERENCE_SOURCE
			{
				CYCLE
				{
					REDSHIFT_OBJECT_REFERENCE_SOURCE_AUTO;
					REDSHIFT_OBJECT_REFERENCE_SOURCE_OBJECT;
					REDSHIFT_OBJECT_REFERENCE_SOURCE_SNAPSHOT;
				}
			}

			LINK REDSHIFT_OBJECT_REFERENCE_OBJECT
			{
				ACCEPT { Obase; }
			}

			GROUP
			{
				COLUMNS 2;
				BUTTON REDSHIFT_OBJECT_REFERENCE_BUTTON_CAPTURE { ANIM OFF; SCALE_H; }
				BUTTON REDSHIFT_OBJECT_REFERENCE_BUTTON_CLEAR { ANIM OFF; SCALE_H; }
				STATICTEXT REDSHIFT_OBJECT_REFERENCE_INFO { SCALE_H; }
				STATICTEXT { JOINENDSCALE; }
			}

		}
	}

	GROUP REDSHIFT_OBJECT_TAB_MATTE
	{
		BOOL REDSHIFT_OBJECT_MATTE_OVERRIDE { }
		GROUP REDSHIFT_OBJECT_GROUP_MATTE_GENERAL
		{
			DEFAULT 1;
			BOOL 	REDSHIFT_OBJECT_MATTE_ENABLED { }
			BOOL 	REDSHIFT_OBJECT_MATTE_SHOW_BACKGROUND { }
			BOOL 	REDSHIFT_OBJECT_MATTE_APPLY_TO_SECONDARY_RAYS { }
			BOOL 	REDSHIFT_OBJECT_MATTE_AFFECTED_BY_MATTE_LIGHTS { }
			BOOL	REDSHIFT_OBJECT_MATTE_INCLUDE_IN_PUZZLE_MATTE { }
			REAL	REDSHIFT_OBJECT_MATTE_ALPHA { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL	REDSHIFT_OBJECT_MATTE_REFLECTION_SCALE { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL	REDSHIFT_OBJECT_MATTE_REFRACTION_SCALE { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL	REDSHIFT_OBJECT_MATTE_DIFFUSE_SCALE { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		}

		GROUP REDSHIFT_OBJECT_GROUP_MATTE_SHADOW
		{
			DEFAULT 1;
			BOOL 	REDSHIFT_OBJECT_MATTE_SHADOW_ENABLED { }
			BOOL	REDSHIFT_OBJECT_MATTE_RECEIVE_SHADOWS_FROM_MATTE_ENABLED { }
			BOOL 	REDSHIFT_OBJECT_MATTE_SHADOW_AFFECTS_ALPHA_ENABLED { }
			COLOR	REDSHIFT_OBJECT_MATTE_SHADOW_COLOR { }
			REAL	REDSHIFT_OBJECT_MATTE_SHADOW_TRANSPARENCY { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		}
	}

	GROUP REDSHIFT_OBJECT_GROUP_OBJECTID
	{
		BOOL REDSHIFT_OBJECT_OBJECTID_OVERRIDE { }
		LONG REDSHIFT_OBJECT_OBJECTID_ID { MIN 0; CUSTOMGUI LONGSLIDER; MAXSLIDER 100; }
	}

	GROUP REDSHIFT_OBJECT_GROUP_MOTIONBLUR
	{
		BOOL REDSHIFT_OBJECT_MOTIONBLUR_OVERRIDE { }
		LONG REDSHIFT_OBJECT_MOTIONBLUR_MODE
		{
			CYCLE
			{
				REDSHIFT_OBJECT_MOTIONBLUR_MODE_GLOBAL;
				REDSHIFT_OBJECT_MOTIONBLUR_MODE_OFF;
				REDSHIFT_OBJECT_MOTIONBLUR_MODE_TRANSFORMATION;
				REDSHIFT_OBJECT_MOTIONBLUR_MODE_TRANSFORMATION_DEFORMATION;
			}
		}

		LONG REDSHIFT_OBJECT_MOTIONBLUR_DEFORMATION_STEPS
		{
			CYCLE
			{
				REDSHIFT_OBJECT_MOTIONBLUR_DEFORMATION_STEPS_GLOBAL;
				REDSHIFT_OBJECT_MOTIONBLUR_DEFORMATION_STEPS_2;
				REDSHIFT_OBJECT_MOTIONBLUR_DEFORMATION_STEPS_3;
				REDSHIFT_OBJECT_MOTIONBLUR_DEFORMATION_STEPS_5;
				REDSHIFT_OBJECT_MOTIONBLUR_DEFORMATION_STEPS_9;
				REDSHIFT_OBJECT_MOTIONBLUR_DEFORMATION_STEPS_17;
			}
		}

		GROUP REDSHIFT_OBJECT_GROUP_MOTIONBLUR_MOTIONVECTOR
		{
			DEFAULT 1;
			BOOL REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_ENABLED { }
			STRING REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_X { }
			STRING REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_Y { }
			STRING REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_Z { }
			REAL REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_SCALE
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 2;
				STEP 0.001;
			}
			LONG REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_UNIT
			{
				CYCLE
				{
					REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_UNIT_FRAMES;
					REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_UNIT_SECONDS;
					REDSHIFT_OBJECT_MOTIONBLUR_MOTIONVECTOR_UNIT_FRAMES_LEGACY;
				}
			}
		}
	}
	GROUP REDSHIFT_OBJECT_GROUP_TRACESETS
	{
		BOOL REDSHIFT_OBJECT_TRACESETS_OVERRIDE { }
		SCALE_V;
		LONG REDSHIFT_OBJECT_TRACESETS_EXCLUSION_MODE
		{
			CYCLE
			{
				REDSHIFT_OBJECT_TRACESETS_EXCLUSION_MODE_INCLUDE;
				REDSHIFT_OBJECT_TRACESETS_EXCLUSION_MODE_EXCLUDE;
			}
		}

		IN_EXCLUDE REDSHIFT_OBJECT_TRACESETS_EXCLUSION_LIST
		{
			SCALE_V; NUM_FLAGS 3;
			INIT_STATE 7;

			IMAGE_01_ON 300000104;	IMAGE_01_OFF 300000101;	// Refraction
			IMAGE_02_ON 300000105;	IMAGE_02_OFF 300000102;	// Reflection
			IMAGE_03_ON 1009316;	IMAGE_03_OFF 1009320;	// Hierarchy
			//IMAGE_04_ON 1040200;	IMAGE_04_OFF 1040201;	// SSS
			ACCEPT { Obase; };
		}
	}

}
