CONTAINER Ocharacterbase
{
	NAME Ocharacterbase;
	INCLUDE Obase;

	GROUP Obaselist
	{
		SEPARATOR { LINE; }
		
		GROUP
		{
			COLUMNS 2;
			
			LONG ID_CA_CHARACTER_TYPE
			{
				ANIM OFF;
				
				CYCLE
				{
					ID_CA_CHARACTER_TYPE_NONE;
					-1;
					ID_CA_CHARACTER_TYPE_BIPED~1021433;
					ID_CA_CHARACTER_TYPE_QUAD~1022962;
					ID_CA_CHARACTER_TYPE_INSECT~1022963;
					ID_CA_CHARACTER_TYPE_WING~1022964;
					ID_CA_CHARACTER_TYPE_AMPHIBIAN~1022965;
					ID_CA_CHARACTER_TYPE_ALIEN~1022966;
					ID_CA_CHARACTER_TYPE_FISH~1022967;
					ID_CA_CHARACTER_TYPE_REPTILE~1022968;
					ID_CA_CHARACTER_TYPE_FACE~1022970;
					ID_CA_CHARACTER_TYPE_TENTACLE~1022971;
					-1;
					ID_CA_CHARACTER_TYPE_CUSTOM~1022972;
				}
			}
			BOOL ID_CA_CHARACTER_TYPE_AUTO_SIZE { ANIM OFF; }
			
			REAL ID_CA_CHARACTER_TYPE_SIZE { UNIT METER; MINSLIDER 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
			
			STRING ID_CA_CHARACTER_TYPE_NAME { ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
			
			TEXTURE ID_CA_CHARACTER_TYPE_ICON { ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
			
			BOOL ID_CA_CHARACTER_DEBUG { HIDDEN; }
			STATICTEXT { DUMMY; }
		}
	}
	
	GROUP ID_OBJECTPROPERTIES
	{
		GROUP
		{
			COLUMNS 3;
			
			LONG ID_CA_CHARACTER_MODE
			{
				SCALE_H; ANIM OFF; 
				
				CUSTOMGUI QUICKTABRADIO;
				
				CYCLE
				{
					ID_CA_CHARACTER_MODE_BUILD;
					ID_CA_CHARACTER_MODE_ADJUST;
					ID_CA_CHARACTER_MODE_BIND;
					ID_CA_CHARACTER_MODE_ANIMATE;
				}
			}
			
			BOOL ID_CA_CHARACTER_PROTECT { ANIM OFF; }
		}

		SEPARATOR { LINE; }
	
		GROUP
		{
			COLUMNS 2;
			
			LONG ID_CA_ADJUST_MODE
			{
				SCALE_H; ANIM OFF; 
				
				CYCLE
				{
					ID_CA_ADJUST_MODE_COMPONENT;
					ID_CA_ADJUST_MODE_CONTROLLER;
				}
			}
			BOOL ID_CA_CHARACTER_ADJUST_SYMMETRY { ANIM OFF; }	
		}
		
		GROUP ID_CA_CHARACTER_GROUP_ADJUST
		{
			COLUMNS 3; DEFAULT 1; HIDDEN;
		
			LONG ID_CA_CHARACTER_ADJUST_SYMMETRY_ORIGIN
			{
				ANIM OFF; 
			
				CYCLE
				{
					ID_CA_CHARACTER_ADJUST_SYMMETRY_ORIGIN_DEFAULT;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_ORIGIN_WORLD;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_ORIGIN_PARENT;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_ORIGIN_HUB;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_ORIGIN_CHARACTER;
				}
			}			
			
			LONG ID_CA_CHARACTER_ADJUST_SYMMETRY_PLANE
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_ADJUST_SYMMETRY_PLANE_DEFAULT;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_PLANE_WORLD_XY;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_PLANE_WORLD_YZ;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_PLANE_WORLD_XZ;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_PLANE_LOCAL_XY;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_PLANE_LOCAL_YZ;
					ID_CA_CHARACTER_ADJUST_SYMMETRY_PLANE_LOCAL_XZ;
				}
			}
			
			GROUP ID_CA_CHARACTER_GROUP_ADJUST_SYMMETRY_EXT
			{
				COLUMNS 2;

				BOOL ID_CA_CHARACTER_ADJUST_SYMMETRY_SEARCH_DISTANCE { ANIM OFF; }
				REAL ID_CA_CHARACTER_ADJUST_SYMMETRY_RAD { UNIT METER; MIN 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
				
				BOOL ID_CA_CHARACTER_ADJUST_SYMMETRY_SEARCH_NAME { ANIM OFF; }
				BOOL ID_CA_CHARACTER_ADJUST_SYMMETRY_SEARCH_NAME_CASE { ANIM OFF; }
				
				STRING ID_CA_CHARACTER_ADJUST_SYMMETRY_SEARCH_NAME_REPLACE { ANIM OFF; }
				STRING ID_CA_CHARACTER_ADJUST_SYMMETRY_SEARCH_NAME_WITH { ANIM OFF; }
			}
			
				
			LONG ID_CA_CHARACTER_AUTO_ALIGN
			{
				ANIM OFF; HIDDEN;
				CYCLE
				{
					ID_CA_CHARACTER_AUTO_ALIGN_OFF;
					ID_CA_CHARACTER_AUTO_ALIGN_ON;
					ID_CA_CHARACTER_AUTO_ALIGN_CONTINUOUS;
				}
			}
			
			LONG ID_CA_CHARACTER_ADJUST_FILTER
			{
				ANIM OFF; HIDDEN;
				
				CYCLE
				{
					ID_CA_CHARACTER_ADJUST_FILTER_ALL;
					ID_CA_CHARACTER_ADJUST_FILTER_COMPONENT;
					ID_CA_CHARACTER_ADJUST_FILTER_COMPONENT_TYPE;
				}
			}
		}
		
		GROUP ID_CA_CHARACTER_GROUP_BUILD
		{
			COLUMNS 2; DEFAULT 1;
			
			LONG ID_CA_CHARACTER_TEMPLATE { ANIM OFF; CYCLE { } }
			STATICTEXT { JOINENDSCALE; }
			
			GROUP ID_CA_CHARACTER_COMPONENTS_BUILD_GROUP
			{
				COLUMNS 2; DEFAULT 1;
			}
			
			GROUP ID_CA_CHARACTER_GROUP_COMPONENT_BONES
			{		
				COLUMNS 1; DEFAULT 1;
				
				LONG ID_CA_CHARACTER_BONE_COUNT { MIN 1; MAX 100; ANIM OFF; }
			}
      
      GROUP
      {
        REAL ID_CA_CHARACTER_BONE_LENGTH { HIDDEN; UNIT METER; MIN 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; SCALE_H; ANIM OFF; }
      }
		}
		
		GROUP ID_CA_CHARACTER_GROUP_ANIMATION
		{
			DEFAULT 1;
			
			GROUP
			{
				COLUMNS 3;
			
				BUTTON ID_CA_CHARACTER_REST_RESET { SCALE_H; }
				BUTTON ID_CA_CHARACTER_REST_UPDATE { SCALE_H; }
				BUTTON ID_CA_CHARACTER_ANIMATION_CREATE_WALK { SCALE_H; }
			}
		}

		GROUP ID_CA_CHARACTER_GROUP_BIND
		{
			BUTTON ID_CA_CHARACTER_BIND_AUTO { HIDDEN; }
			
			ITEMTREE ID_CA_CHARACTER_BIND_TREE { SCALE_H; MULTIPLE; COLUMNS 2; ICON; NORENAME; FOLDERS; DRAGDROP; ACCEPT { Obase; } }
		}
		
		//SEPARATOR { LINE; }		
		
		GROUP
		{
			COLUMNS 2; HIDDEN;
			
			BUTTON ID_CA_CHARACTER_LOAD_CHARACTER { SCALE_H; }
			BUTTON ID_CA_CHARACTER_SAVE_CHARACTER { SCALE_H; }
		}
	}

	GROUP ID_CA_CHARACTER_GROUP_COMPONENT
	{
		SCALE_V;
		
		GROUP
		{
			COLUMNS 2;
		
			STRING ID_CA_CHARACTER_COMPONENT_NAME { SCALE_H; ANIM OFF; }
			COLOR ID_CA_CHARACTER_OBJECT_COLOR { ANIM OFF; }
			
			STRING ID_CA_CHARACTER_OBJECT_NAME { SCALE_H; ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
		}
		
		GROUP ID_CA_CHARACTER_GROUP_COMPONENT_COORDS
		{
		}
		
		GROUP ID_CA_CHARACTER_GROUP_COMPONENT_NOTES
		{			
			STRING ID_CA_CHARACTER_COMPONENT_NOTES { CUSTOMGUI MULTISTRING; SCALE_V; ANIM OFF; }
		}
	}
	
	GROUP ID_CA_CHARACTER_GROUP_COMPONENT_DIGITS
	{
		GROUP
		{
			COLUMNS 2;
		
			LONG ID_CA_CHARACTER_DIGITS_COUNT { ANIM OFF; }
			BOOL ID_CA_CHARACTER_DIGITS_SHOWALL { ANIM OFF; }
			
			ITEMLIST ID_CA_CHARACTER_DIGITS_LIST { MULTIPLE; }
			STATICTEXT { JOINENDSCALE; }
		}
				
		GROUP ID_CA_CHARACTER_GROUP_DIGITS_POSES
		{
			COLUMNS 3; HIDDEN;
			
			BUTTON ID_CA_CHARACTER_GROUP_DIGITS_POSES_RECORD { }
			BUTTON ID_CA_CHARACTER_GROUP_DIGITS_POSES_ADD { }
			BUTTON ID_CA_CHARACTER_GROUP_DIGITS_POSES_REMOVE { }
				
			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
	
			BOOL ID_CA_CHARACTER_GROUP_DIGITS_POSES_ENABLE { HIDDEN; }
			BOOL ID_CA_CHARACTER_GROUP_DIGITS_POSES_SELECTED { HIDDEN; }
			REAL ID_CA_CHARACTER_GROUP_DIGITS_POSES_MIX { HIDDEN; }
		}
	}
		
	GROUP ID_CA_CHARACTER_GROUP_COMPONENT_HOTSPOTS
	{
		COLUMNS 2;
		
		BUTTON ID_CA_CHARACTER_COMPONENT_HOTSPOTS_CREATE_HUD { }
		BUTTON ID_CA_CHARACTER_COMPONENT_HOTSPOTS_CREATE_VS { }
		
		GROUP ID_CA_CHARACTER_GROUP_COMPONENT_HOTSPOTS_LIST
		{
			DEFAULT 1;
			
			COLUMNS 2;
		}
	}

	GROUP ID_CA_CHARACTER_GROUP_USERDATA
	{				
		STATICTEXT ID_CA_CHARACTER_USERDATA_DUMMY { }		
	}
		
	GROUP ID_CA_CHARACTER_GROUP_DIGITS_CONTROLS
	{
		DEFAULT 1; SCALE_V; HIDDEN;
	}
		
	GROUP ID_CA_CHARACTER_GROUP_CONTROLLERS
	{
		HIDDEN;
		
		COLUMNS 2;
		
		BUTTON ID_CA_CHARACTER_CONTROLLER_REMOVE { HIDDEN; }
	}
	
	GROUP ID_CA_CHARACTER_GROUP_DISPLAY
	{
		GROUP ID_CA_CHARACTER_GROUP_DISPLAY_HIGHLIGHTING
		{
			COLUMNS 2; DEFAULT 1;
			
			LONG ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_SELECTED
			{
				UNIMPORTANTFORDEFAULTS; 
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_NONE;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_COMPONENTS;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_CONTROLLERS;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_ALL;
				}
			}
			LONG ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_OVER
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_NONE;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_COMPONENTS;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_CONTROLLERS;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_OBJECTS;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_ALL;
				}
			}
			
			LONG ID_CA_CHARACTER_COMPONENT_MOUSEOVER
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_COMPONENT_MOUSEOVER_NONE;
					ID_CA_CHARACTER_COMPONENT_MOUSEOVER_COMPONENT;
					ID_CA_CHARACTER_COMPONENT_MOUSEOVER_CONTROLLER;
					ID_CA_CHARACTER_COMPONENT_MOUSEOVER_OBJECT;
					ID_CA_CHARACTER_COMPONENT_MOUSEOVER_ALL;
				}
			}
			
			LONG ID_CA_CHARACTER_COMPONENT_VISIBLE
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_NONE;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_COMPONENTS;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_CONTROLLERS;
					ID_CA_CHARACTER_COMPONENT_HIGHLIGHT_ALL;
				}
			}
		}
			
		GROUP ID_CA_CHARACTER_GROUP_DISPLAY_HANDLES
		{
			COLUMNS 2; DEFAULT 1;
		
			REAL ID_CA_CHARACTER_COMPONENT_DISPLAY_HANDLE_SCREEN_SIZE { UNIT PERCENT; MIN 0.0; MAXSLIDER 400.0; STEP 0.1; CUSTOMGUI REALSLIDER; ANIM OFF; SCALE_H; }
			LONG ID_CA_CHARACTER_COMPONENT_DISPLAY_HANDLE_UNITS
			{
				ANIM OFF;
				
				CYCLE
				{
					ID_CA_CHARACTER_COMPONENT_DISPLAY_HANDLE_UNITS_WORLD;
					ID_CA_CHARACTER_COMPONENT_DISPLAY_HANDLE_UNITS_SCREEN;
				}
			}
								
			LONG ID_CA_CHARACTER_COMPONENT_ADJUST_DISPLAY
			{
				ANIM OFF; HIDDEN;
				
				CYCLE
				{
					ID_CA_CHARACTER_COMPONENT_ADJUST_DISPLAY_CUBE;
					ID_CA_CHARACTER_COMPONENT_ADJUST_DISPLAY_CUBE_WIRE;
					ID_CA_CHARACTER_COMPONENT_ADJUST_DISPLAY_SQUARE;
					ID_CA_CHARACTER_COMPONENT_ADJUST_DISPLAY_SQUARE_WIRE;
					ID_CA_CHARACTER_COMPONENT_ADJUST_DISPLAY_CIRCLE;
					ID_CA_CHARACTER_COMPONENT_ADJUST_DISPLAY_CIRCLE_WIRE;
					ID_CA_CHARACTER_COMPONENT_ADJUST_DISPLAY_SPHERE;				
				}
			}
			
			LONG ID_CA_CHARACTER_ADJUST_COLORING
			{
				ANIM OFF; HIDDEN;
				
				CYCLE
				{
					ID_CA_CHARACTER_ADJUST_COLORING_SINGLE;
					ID_CA_CHARACTER_ADJUST_COLORING_MULTI;
					ID_CA_CHARACTER_ADJUST_COLORING_COMPONENT;
					ID_CA_CHARACTER_ADJUST_COLORING_RANDOM;
				}
			}
			
			LONG ID_CA_CHARACTER_ADJUST_HANDLES
			{
				ANIM OFF; HIDDEN;
				
				CYCLE
				{
					ID_CA_CHARACTER_ADJUST_HANDLES_FIXED;
					ID_CA_CHARACTER_ADJUST_HANDLES_AS_BONES;
					ID_CA_CHARACTER_ADJUST_HANDLES_AS_JOINTS;
					ID_CA_CHARACTER_ADJUST_HANDLES_REL_JOINTS;
					ID_CA_CHARACTER_ADJUST_HANDLES_REL_COMP;
				}
			}
			
			LONG ID_CA_CHARACTER_COMPONENT_HANDLE_JOINTS
			{	
				ANIM OFF; HIDDEN;
				
				CYCLE
				{
					ID_CA_CHARACTER_COMPONENT_HANDLE_JOINTS_DEFAULT;
					ID_CA_CHARACTER_COMPONENT_HANDLE_JOINTS_HIDE;
					ID_CA_CHARACTER_COMPONENT_HANDLE_JOINTS_LINES;
					ID_CA_CHARACTER_COMPONENT_HANDLE_JOINTS_STICK;
					ID_CA_CHARACTER_COMPONENT_HANDLE_JOINTS_BOX;
					ID_CA_CHARACTER_COMPONENT_HANDLE_JOINTS_STANDARD;
				}
			}
		}
		
		GROUP ID_CA_CHARACTER_GROUP_DISPLAY_COLORS
		{
			COLUMNS 2; DEFAULT 1;  HIDDEN;
			
			LONG ID_CA_CHARACTER_JOINT_COLORING
			{	
				ANIM OFF; 
			
				CYCLE
				{
					ID_CA_CHARACTER_JOINT_COLORS_DEFAULT;
					ID_CA_CHARACTER_JOINT_COLORS_SINGLE;
					ID_CA_CHARACTER_JOINT_COLORS_RANDOM;
					ID_CA_CHARACTER_JOINT_COLORS_HUE;
				}
			}
			BUTTON ID_CA_CHARACTER_JOINT_COLOR_APPLY { }
			
			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }
					
			COLOR ID_CA_CHARACTER_ACTIVE_COLOR { ANIM OFF; }		
			REAL ID_CA_CHARACTER_ACTIVE_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
			
			COLOR ID_CA_CHARACTER_HIGHLIGHT_COLOR { ANIM OFF; }
			REAL ID_CA_CHARACTER_HIGHLIGHT_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
			
			COLOR ID_CA_CHARACTER_SCALING_COLOR { ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
			
			COLOR ID_CA_CHARACTER_BONE_COLOR { ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
			
			LONG ID_CA_CHARACTER_ICON_TYPES
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_ICON_TYPES_TEMPLATE;
					ID_CA_CHARACTER_ICON_TYPES_DEFAULTS;
				}
			}
			BOOL ID_CA_CHARACTER_ICON_COLORIZE { ANIM OFF; }
		}
					
		GROUP ID_CA_CHARACTER_GROUP_DISPLAY_JOINTS
		{
			COLUMNS 2;  HIDDEN;
		
			BUTTON ID_CA_CHARACTER_DISPLAY_JOINTS_RESET { }
			STATICTEXT { JOINENDSCALE; }
			
			LONG ID_CA_CHARACTER_BONE_DISPLAY
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_BONE_DISPLAY_DEFAULT;
					ID_CA_CHARACTER_BONE_DISPLAY_NONE;
					ID_CA_CHARACTER_BONE_DISPLAY_STANDARD;
					ID_CA_CHARACTER_BONE_DISPLAY_BOX;
					ID_CA_CHARACTER_BONE_DISPLAY_LINE;
					ID_CA_CHARACTER_BONE_DISPLAY_STICK;
					ID_CA_CHARACTER_BONE_DISPLAY_POLYGON;
				}
			}
			
			LONG ID_CA_CHARACTER_JOINT_DISPLAY
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_JOINT_DISPLAY_DEFAULT;
					ID_CA_CHARACTER_JOINT_DISPLAY_NONE;
					ID_CA_CHARACTER_JOINT_DISPLAY_AXIS;
					ID_CA_CHARACTER_JOINT_DISPLAY_SPHERE;
					ID_CA_CHARACTER_JOINT_DISPLAY_CIRCLE;
					ID_CA_CHARACTER_JOINT_DISPLAY_BALL;
				}
			}
		}
		
		GROUP ID_CA_CHARACTER_GROUP_DISPLAY_GROUPS
		{
			COLUMNS 1; DEFAULT 1;  HIDDEN;
		}
		
		GROUP ID_CA_CHARACTER_GROUP_DISPLAY_MANAGERS
		{
			COLUMNS 1;
		
			LONG ID_CA_CHARACTER_OM_DISPLAY
			{
				ANIM OFF; 
			
				CYCLE
				{
					ID_CA_CHARACTER_OM_DISPLAY_NONE;
					ID_CA_CHARACTER_OM_DISPLAY_COMPONENTS_OBJECTS;
					ID_CA_CHARACTER_OM_DISPLAY_COMPONENTS;
					ID_CA_CHARACTER_OM_DISPLAY_CONTROLLERS;
					ID_CA_CHARACTER_OM_DISPLAY_ACTIVE_COMPONENT;
					ID_CA_CHARACTER_OM_DISPLAY_ACTIVE_CONTROLLERS;
					ID_CA_CHARACTER_OM_DISPLAY_OBJECT;
					ID_CA_CHARACTER_OM_DISPLAY_FULL;
				}
			}
			BOOL ID_CA_CHARACTER_LOCK_AM { ANIM OFF; }
		}		
	}
		
	GROUP ID_CA_CHARACTER_GROUP_ADVANCED
	{
		HIDDEN;
				
		GROUP ID_CA_CHARACTER_GROUP_NAMING
		{
			COLUMNS 2;
			
			BOOL ID_CA_CHARACTER_NAMING_COMPONENT { ANIM OFF; }
			BOOL ID_CA_CHARACTER_NAMING_OBJECTS { ANIM OFF; }
			
			BOOL ID_CA_CHARACTER_NAMING_CONTROLLERS { }
			STATICTEXT { NEWLINE; }
			
			STRING ID_CA_CHARACTER_NAMING_PRE { SCALE_H; ANIM OFF; }
			STRING ID_CA_CHARACTER_NAMING_POST { SCALE_H; ANIM OFF; }
			
			STRING ID_CA_CHARACTER_NAMING_REPLACE { SCALE_H; ANIM OFF; }
			STRING ID_CA_CHARACTER_NAMING_REPLACE_WITH { SCALE_H; ANIM OFF; }
		
			BOOL ID_CA_CHARACTER_NAMING_CASE { ANIM OFF; }
			BUTTON ID_CA_CHARACTER_NAMING_CLEAR { }
		}
		
		GROUP ID_CA_CHARACTER_GROUP_LABEL
		{
			COLUMNS 1;
				
			LONG ID_CA_CHARACTER_NAMING_LABEL
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_NAMING_LABEL_NONE;
					ID_CA_CHARACTER_NAMING_LABEL_PRE;
					ID_CA_CHARACTER_NAMING_LABEL_POST;
				}
			}
			
			SEPARATOR { }
			
			LONG ID_CA_CHARACTER_NAMING_LABEL_COMPONENTS
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_NAMING_LABEL_NONE;
					ID_CA_CHARACTER_NAMING_LABEL_LEVEL;
					ID_CA_CHARACTER_NAMING_LABEL_ROOT;
					ID_CA_CHARACTER_NAMING_LABEL_CHARACTER;
					ID_CA_CHARACTER_NAMING_LABEL_DOCUMENT;
					ID_CA_CHARACTER_NAMING_LABEL_GLOBAL;
				}
			}
			
			LONG ID_CA_CHARACTER_NAMING_LABEL_OBJECTS
			{
				ANIM OFF; 
			
				CYCLE
				{
					ID_CA_CHARACTER_NAMING_LABEL_NONE;
					ID_CA_CHARACTER_NAMING_LABEL_COMPONENT;
					ID_CA_CHARACTER_NAMING_LABEL_LEVEL;
					ID_CA_CHARACTER_NAMING_LABEL_ROOT;
					ID_CA_CHARACTER_NAMING_LABEL_CHARACTER;
					ID_CA_CHARACTER_NAMING_LABEL_DOCUMENT;
					ID_CA_CHARACTER_NAMING_LABEL_GLOBAL;
				}
			}
			
			LONG ID_CA_CHARACTER_NAMING_LABEL_CONTROLLERS
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_NAMING_LABEL_NONE;
					ID_CA_CHARACTER_NAMING_LABEL_COMPONENT;
					ID_CA_CHARACTER_NAMING_LABEL_LEVEL;
					ID_CA_CHARACTER_NAMING_LABEL_ROOT;
					ID_CA_CHARACTER_NAMING_LABEL_CHARACTER;
					ID_CA_CHARACTER_NAMING_LABEL_DOCUMENT;
					ID_CA_CHARACTER_NAMING_LABEL_GLOBAL;
				}
			}
			
			SEPARATOR { }
			
			LONG ID_CA_CHARACTER_NAMING_SEPARATOR
			{
				ANIM OFF; 
				
				CYCLE
				{
					ID_CA_CHARACTER_NAMING_SEPARATOR_DOT;
					ID_CA_CHARACTER_NAMING_SEPARATOR_UNDERSCORE;
					ID_CA_CHARACTER_NAMING_SEPARATOR_HYPHEN;
					ID_CA_CHARACTER_NAMING_SEPARATOR_COLON;
					ID_CA_CHARACTER_NAMING_SEPARATOR_SEMICOLON;
					ID_CA_CHARACTER_NAMING_SEPARATOR_SPACE;
					ID_CA_CHARACTER_NAMING_SEPARATOR_CUSTOM;
				}
			}
			STRING ID_CA_CHARACTER_NAMING_SEPARATOR_TXT { ANIM OFF; }
		}
		
		GROUP ID_CA_CHARACTER_GROUP_EXPRESSIONS
		{
			LONG ID_CA_CHARACTER_EXPRESSIONS_PASSES { HIDDEN; MIN 1; MAX 100; CUSTOMGUI LONGSLIDER; }
		}
	}

	GROUP Obaselist
	{
		HIDE ID_BASELIST_ICON_SETTINGS_GROUP;
	}
}
