CONTAINER OpointProjector
{
	NAME OpointProjector;
	INCLUDE Obase;

	GROUP POINTPROJECTOR_GROUP_PARAMS
	{
		DEFAULT 1;

		LINK POINTPROJECTOR_LINK		{ ACCEPT { Obase; } }
		LONG POINTPROJECTOR_MODE
		{
			CYCLE
			{
				POINTPROJECTOR_MODE_PARALLEL;
				POINTPROJECTOR_MODE_SPHERICAL;
			}
		}
		STATICTEXT { JOINEND; }
		LONG POINTPROJECTOR_ALIGNMENT
		{
			ANIM OFF;
			CUSTOMGUI QUICKTABRADIO;
			CYCLE 
			{
				POINTPROJECTOR_ALIGNMENT_POSITIVE_X;
				POINTPROJECTOR_ALIGNMENT_NEGATIVE_X;
				POINTPROJECTOR_ALIGNMENT_POSITIVE_Y;
				POINTPROJECTOR_ALIGNMENT_NEGATIVE_Y;
				POINTPROJECTOR_ALIGNMENT_POSITIVE_Z;
				POINTPROJECTOR_ALIGNMENT_NEGATIVE_Z;
			}
		}

		BOOL POINTPROJECTOR_INCLUDE_HIERARCHY { NAME POINTPROJECTOR_INCLUDE_HIERARCHY; }

		SEPARATOR													{ LINE; }

		REAL POINTPROJECTOR_OFFSET				{ UNIT METER; }
		REAL POINTPROJECTOR_STRENGTH			{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; DEFAULT 50; }
	}

	GROUP POINTPROJECTOR_FALLOFF_GROUP_PARAMS
	{
		FIELD HIDE;
		DEFAULT	0;
		FIELDLIST POINTPROJECTOR_FALLOFF { ANIM ON; NEWLINE; NOCOLOR; NODIRECTION; NOROTATION; }
	}
}