#ifndef MMATERIAL_H__
#define MMATERIAL_H__

enum
{
	ID_MATERIALGROUP_COLOR 					= 807,
	ID_MATERIALGROUP_DIFFUSION			= 808,
	ID_MATERIALGROUP_LUMINANCE			= 809,
	ID_MATERIALGROUP_TRANSPARENCY		= 810,
	ID_MATERIALGROUP_REFLECTION			= 811,
	ID_MATERIALGROUP_ENVIRONMENT		= 812,
	ID_MATERIALGROUP_FOG						= 813,
	ID_MATERIALGROUP_BUMP				  	= 814,
	ID_MATERIALGROUP_ALPHA					= 815,
	ID_MATERIALGROUP_SPECULAR				= 816,
	ID_MATERIALGROUP_SPECULARCOLOR	= 817,
	ID_MATERIALGROUP_GLOW					  = 818,
	ID_MATERIALGROUP_DISPLACEMENT		= 819,
	MATERIAL_NBM_INLINE 						= 777,
	ID_MATERIALGROUP_NORMAL					= 3301,
	ID_MATERIALGROUP_EDITOR					= 503,
	MATERIAL_PAGE_EDITOR						= 504,
	MATERIAL_PAGE_CUSTOM						= 505,
	MATERIAL_PAGE_NODE							= 506,
	ID_MATERIALGROUP_NODE						= 507,

	MATERIAL_USE_COLOR 													= 2000,
	MATERIAL_USE_DIFFUSION											= 2001,
	MATERIAL_USE_LUMINANCE											= 2002,
	MATERIAL_USE_TRANSPARENCY										= 2003,
	MATERIAL_USE_REFLECTION											= 2004,
	MATERIAL_USE_ENVIRONMENT										= 2005,
	MATERIAL_USE_FOG														= 2006,
	MATERIAL_USE_BUMP														= 2007,
	MATERIAL_USE_ALPHA													= 2008,
	MATERIAL_USE_SPECULAR												= 2009,
	MATERIAL_USE_SPECULARCOLOR									= 2010,
	MATERIAL_USE_GLOW														= 2011,
	MATERIAL_USE_DISPLACEMENT										= 2012,
	MATERIAL_USE_NORMAL													= 2013,

	MATERIAL_DISPLAY_USE_COLOR									= 2050,
	MATERIAL_DISPLAY_USE_DIFFUSION							= 2051,
	MATERIAL_DISPLAY_USE_LUMINANCE							= 2052,
	MATERIAL_DISPLAY_USE_TRANSPARENCY						= 2053,
	MATERIAL_DISPLAY_USE_ENVIRONMENT						= 2055,
	MATERIAL_DISPLAY_USE_BUMP										= 2057,
	MATERIAL_DISPLAY_USE_ALPHA									= 2058,
	MATERIAL_DISPLAY_USE_REFLECTANCE						= 2059,
	MATERIAL_DISPLAY_USE_SPECULARCOLOR					= 2060,
	MATERIAL_DISPLAY_USE_NORMAL									= 2063,
	MATERIAL_DISPLAY_USE_DISPLACEMENT						= 2064,
	MATERIAL_DISPLAY_USE_SHADER_EOGL_IS_DEPRECATED						= 2068,
	MATERIAL_DISPLAY_USE_SHADER_EOGL_NAME_IS_DEPRECATED				= 2069,

	MATERIAL_COLOR_COLOR 												= 2100,
	MATERIAL_COLOR_BRIGHTNESS 									= 2101,
	MATERIAL_COLOR_TEXTURESTRENGTH							= 2102,
	MATERIAL_COLOR_TEXTUREMIXING								= 2103,
		MATERIAL_TEXTUREMIXING_NORMAL									= 0,
		MATERIAL_TEXTUREMIXING_ADD										= 1,
		MATERIAL_TEXTUREMIXING_SUBTRACT								= 2,
		MATERIAL_TEXTUREMIXING_MULTIPLY								= 3,

	// Different IDs (legacy illumination values)
	MATERIAL_COLOR_MODEL 												= 2110,
		MATERIAL_COLOR_MODEL_LAMBERTIAN								= 0,
		MATERIAL_COLOR_MODEL_ORENNAYAR								= 1,
	MATERIAL_ILLUMINATION_MODEL_EX							= 1134,
		MATERIAL_ILLUMINATION_MODEL_EX_PHONG					= 0,
		MATERIAL_ILLUMINATION_MODEL_EX_BLINN					= 1,
		MATERIAL_ILLUMINATION_MODEL_EX_ORENNAYAR			= 2,
	MATERIAL_COLOR_DIFFUSEFALLOFF								= 1136,
	MATERIAL_COLOR_DIFFUSELEVEL									= 1138,
	MATERIAL_COLOR_ROUGHNESS										= 1135,

	MATERIAL_DIFFUSION_BRIGHTNESS 							= 2200,
	MATERIAL_DIFFUSION_TEXTURESTRENGTH					= 2201,
	MATERIAL_DIFFUSION_TEXTUREMIXING						= 2202,
	MATERIAL_DIFFUSION_AFFECT_LUMINANCE 				= 1002,
	MATERIAL_DIFFUSION_AFFECT_SPECULAR 					= 1000,
	MATERIAL_DIFFUSION_AFFECT_REFLECTION				= 1001,

	MATERIAL_LUMINANCE_COLOR 										= 2300,
	MATERIAL_LUMINANCE_BRIGHTNESS 							= 2301,
	MATERIAL_LUMINANCE_TEXTURESTRENGTH					= 2302,
	MATERIAL_LUMINANCE_TEXTUREMIXING						= 2303,

	MATERIAL_TRANSPARENCY_COLOR 								= 2400,
	MATERIAL_TRANSPARENCY_BRIGHTNESS 						= 2401,
	MATERIAL_TRANSPARENCY_TEXTURESTRENGTH				= 2402,
	MATERIAL_TRANSPARENCY_TEXTUREMIXING					= 2403,
	MATERIAL_TRANSPARENCY_REFRACTION_PRESET			= 2409,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_CUSTOM					= 0,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_BEER						= 1,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_DIAMOND					= 2,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_EMERALD					= 3,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_ETHANOL					= 4,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_GLASS						= 5,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_JADE						= 6,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_MILK						= 7,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_OIL_VEGETABLE		= 8,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_PEARL						= 9,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_PET							= 10,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_PLEXIGLASS			= 11,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_RUBY						= 12,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_SAPPHIRE				= 13,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_WATER						= 14,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_WATER_ICE				= 15,
		MATERIAL_TRANSPARENCY_REFRACTION_PRESET_WHISKEY					= 16,
	MATERIAL_TRANSPARENCY_REFRACTION 						= 1005,
	MATERIAL_TRANSPARENCY_FRESNEL 							= 1003,
	MATERIAL_TRANSPARENCY_ADDITIVE 							= 1004,
	MATERIAL_TRANSPARENCY_FRESNELREFLECTIVITY		= 2404,
	MATERIAL_TRANSPARENCY_ABSORPTIONCOLOR				= 2405,
	MATERIAL_TRANSPARENCY_ABSORPTIONDISTANCE		= 2406,
	MATERIAL_TRANSPARENCY_EXITREFLECTIONS				= 2407,
	MATERIAL_TRANSPARENCY_EXITCOLOR							= 2408,

	MATERIAL_TRANSPARENCY_DISPERSION_EX					= 1120,
	MATERIAL_TRANSPARENCY_MINSAMPLES 						= 1122,
	MATERIAL_TRANSPARENCY_MAXSAMPLES 						= 1123,
	MATERIAL_TRANSPARENCY_ACCURACY   						= 1121,

	MATERIAL_REFLECTION_COLOR 									= 2500,
	MATERIAL_REFLECTION_BRIGHTNESS 							= 2501,
	MATERIAL_REFLECTION_TEXTURESTRENGTH					= 2502,
	MATERIAL_REFLECTION_TEXTUREMIXING						= 2503,

	MATERIAL_REFLECTION_DISPERSION_EX						= 1130,
	MATERIAL_REFLECTION_MINSAMPLES 							= 1132,
	MATERIAL_REFLECTION_MAXSAMPLES 							= 1133,
	MATERIAL_REFLECTION_ACCURACY  							= 1131,
	MATERIAL_REFLECTION_ADDITIVE 								= 8022,

	MATERIAL_REFLECTION_DISTRIBUTION						= 8100,
		MATERIAL_REFLECTION_DISTRIBUTION_SIMPLE				= 0,
		MATERIAL_REFLECTION_DISTRIBUTION_BLINN				= 1,
		MATERIAL_REFLECTION_DISTRIBUTION_BECKMANN			= 2,
		MATERIAL_REFLECTION_DISTRIBUTION_WARD					= 3,
		MATERIAL_REFLECTION_DISTRIBUTION_ANISOTROPIC	= 4,

	MATERIAL_REFLECTION_ANISOTROPY							= 8101,
	MATERIAL_REFLECTION_ORIENTATION							= 8102,

	MATERIAL_REFLECTION_SHADER_DISPERSION 			= 8103,
	MATERIAL_REFLECTION_SHADER_ANISOTROPY				= 8104,
	MATERIAL_REFLECTION_SHADER_ORIENTATION			= 8105,

	MATERIAL_REFLECTION_USE_BUMP 								= 8110,

	MATERIAL_ENVIRONMENT_COLOR									= 2600,
	MATERIAL_ENVIRONMENT_BRIGHTNESS							= 2601,
	MATERIAL_ENVIRONMENT_TEXTURESTRENGTH				= 2602,
	MATERIAL_ENVIRONMENT_TEXTUREMIXING					= 2603,
	MATERIAL_ENVIRONMENT_TILESX									= 1006,
	MATERIAL_ENVIRONMENT_TILESY									= 1007,
	MATERIAL_ENVIRONMENT_EXCLUSIVE							= 1028,

	MATERIAL_FOG_COLOR													= 2700,
	MATERIAL_FOG_BRIGHTNESS											= 2701,
	MATERIAL_FOG_DISTANCE												= 1008,

	MATERIAL_BUMP_STRENGTH											= 1009,
	MATERIAL_BUMP_MIPFALLOFF										= 1010,
	MATERIAL_BUMP_PARALLAX_HEIGHT								= 10110,
	MATERIAL_BUMP_PARALLAX_SAMPLES							= 10111,

	MATERIAL_ALPHA_COLOR												= 2900,
	MATERIAL_ALPHA_DELTA												= 1011,
	MATERIAL_ALPHA_INVERT												= 1014,
	MATERIAL_ALPHA_SOFT													= 1012,
	MATERIAL_ALPHA_IMAGEALPHA										= 1013,
	MATERIAL_ALPHA_PREMULTIPLIED								= 1027,

	MATERIAL_SPECULAR_MODE											= 1018,
		MATERIAL_SPECULAR_MODE_PLASTIC							= 0,
		MATERIAL_SPECULAR_MODE_METAL 								= 1,
		MATERIAL_SPECULAR_MODE_COLORED							= 2,
	MATERIAL_SPECULAR_WIDTH											= 1016,
	MATERIAL_SPECULAR_HEIGHT										= 1017,
	MATERIAL_SPECULAR_FALLOFF										= 1137,
	MATERIAL_SPECULAR_INNERWIDTH								= 1139,

	MATERIAL_SPECULAR_COLOR											= 3100,
	MATERIAL_SPECULAR_BRIGHTNESS								= 3101,
	MATERIAL_SPECULAR_TEXTURESTRENGTH						= 3102,
	MATERIAL_SPECULAR_TEXTUREMIXING							= 3103,

	MATERIAL_GLOW_COLOR													= 3200,
	MATERIAL_GLOW_BRIGHTNESS										= 3201,
	MATERIAL_GLOW_INNERSTRENGTH									= 1019,
	MATERIAL_GLOW_OUTERSTRENGTH									= 1020,
	MATERIAL_GLOW_RADIUS												= 1021,
	MATERIAL_GLOW_RANDOM												= 1022,
	MATERIAL_GLOW_FREQUENCY											= 1023,
	MATERIAL_GLOW_USEMATERIALCOLOR							= 1024,

	MATERIAL_DISPLACEMENT_STRENGTH							= 1025,
	MATERIAL_DISPLACEMENT_HEIGHT								= 1026,
	MATERIAL_DISPLACEMENT_SUBPOLY								= 3202,
	MATERIAL_DISPLACEMENT_SUBPOLY_SUBDIVISION		= 3203,
	MATERIAL_DISPLACEMENT_SUBPOLY_KEEPEDGES			= 3205,
	MATERIAL_DISPLACEMENT_SUBPOLY_DISTRIBUTION	= 3206,
	MATERIAL_DISPLACEMENT_SUBPOLY_SMOOTH				= 3207,
	MATERIAL_DISPLACEMENT_SUBPOLY_ROUND					= 3208,
	MATERIAL_DISPLACEMENT_SUBPOLY_ROUNDCONTOUR	= 3209,
		
		MATERIAL_DISPLACEMENT_TESSELLATION           = 3220,
				MATERIAL_DISPLACEMENT_TESSELLATION_NONE           = 0,
				MATERIAL_DISPLACEMENT_TESSELLATION_UNIFORM        = 1,
				MATERIAL_DISPLACEMENT_TESSELLATION_ADAPTIVE       = 2,
		MATERIAL_DISPLACEMENT_TESSELLATION_UNIFORM_LEVEL      = 3221,
		MATERIAL_DISPLACEMENT_TESSELLATION_ADAPTIVE_LEVEL     = 3222,
		MATERIAL_DISPLACEMENT_TESSELLATION_INFO               = 3223,
				
	MATERIAL_DISPLACEMENT_TYPE									= 3210,
		MATERIAL_DISPLACEMENT_TYPE_INTENSITY						= 0,
		MATERIAL_DISPLACEMENT_TYPE_CENTEREDINTENSITY		= 1,
		MATERIAL_DISPLACEMENT_TYPE_REDGREEN							= 2,
		MATERIAL_DISPLACEMENT_TYPE_RGBTANGENT						= 3,
		MATERIAL_DISPLACEMENT_TYPE_RGBWORLD							= 4,
		MATERIAL_DISPLACEMENT_TYPE_RGBLOCAL						  = 5,
	MATERIAL_DISPLACEMENT_SUBPOLY_HQREMAPPING		= 3211,
	MATERIAL_DISPLACEMENT_SUBPOLY_MAPRESULT     = 3212,
	MATERIAL_DISPLACEMENT_SUBPOLY_PREBUILD	    = 3213,

    MATERIAL_VIEWPORT_REFLECTION_MAP_SIZE			= 3224,
	MATERIAL_VIEWPORT_REFLECTION_ENVIRONMENT		= 3225,
	MATERIAL_VIEWPORT_REFLECTION_SAMPLES				= 3226,
	MATERIAL_VIEWPORT_REFLECTION_ENVIRONMENT_ROTATION	= 1038943,
	
	MATERIAL_NORMAL_STRENGTH										= 3300,
	MATERIAL_NORMAL_REVERSEX										= 3302,
	MATERIAL_NORMAL_REVERSEY										= 3303,
	MATERIAL_NORMAL_REVERSEZ										= 3304,
	MATERIAL_NORMAL_SPACE												= 3305,
		MATERIAL_NORMAL_SPACE_TANGENT										= 0,
		MATERIAL_NORMAL_SPACE_LOCAL											= 1,
		MATERIAL_NORMAL_SPACE_WORLD											= 2,
	MATERIAL_NORMAL_SWAP												= 3306,

	MATERIAL_VOLUME_MATERIAL										= 3400,
	MATERIAL_VOLUME_SCATTERING_COEFFICIENT			= 3401,
	MATERIAL_VOLUME_ABSORPTION_COEFFICIENT			= 3402,
	MATERIAL_VOLUME_EMISSION_COEFFICIENT				= 3403,
	MATERIAL_VOLUME_EMISSION_TEMPERATURE				= 3404,
	MATERIAL_VOLUME_SCATTERING_GRADIENT					= 3405,
	MATERIAL_VOLUME_EMISSION_TYPE								= 3406,
		MATERIAL_VOLUME_EMISSION_TYPE_NONE					= 0,
		MATERIAL_VOLUME_EMISSION_TYPE_RAMP					= 1,
		MATERIAL_VOLUME_EMISSION_TYPE_BLACKBODY			= 2,
	MATERIAL_VOLUME_EMISSION_GRADIENT						= 3407,
	MATERIAL_VOLUME_DENSITY_SHADOW_SCALE				= 3408,
	MATERIAL_VOLUME_DENSITY_RANGE_OLD_MIN				= 3409,
	MATERIAL_VOLUME_DENSITY_RANGE_NEW_MIN				= 3410,
	MATERIAL_VOLUME_EMISSION_RANGE_OLD_MIN			= 3411,
	MATERIAL_VOLUME_EMISSION_RANGE_NEW_MIN			= 3412,
	MATERIAL_VOLUME_DENSITY_RANGE_OLD_MAX				= 3413,
	MATERIAL_VOLUME_DENSITY_RANGE_NEW_MAX				= 3414,
	MATERIAL_VOLUME_EMISSION_RANGE_OLD_MAX			= 3415,
	MATERIAL_VOLUME_EMISSION_RANGE_NEW_MAX			= 3416,
	MATERIAL_VOLUME_ABSORPTION_GRADIENT					= 3417,

	MATERIAL_PREVIEWSIZE												= 500,
		MATERIAL_PREVIEWSIZE_DEF										= 0,
		MATERIAL_PREVIEWSIZE_NO_SCALE								= 1,
		MATERIAL_PREVIEWSIZE_64											= 6,
		MATERIAL_PREVIEWSIZE_128										= 7,
		MATERIAL_PREVIEWSIZE_256										= 8,
		MATERIAL_PREVIEWSIZE_512										= 9,
		MATERIAL_PREVIEWSIZE_1024										= 10,
		MATERIAL_PREVIEWSIZE_2048										= 11,
		MATERIAL_PREVIEWSIZE_4096										= 12,
		MATERIAL_PREVIEWSIZE_8192										= 13,
		MATERIAL_PREVIEWSIZE_16384									= 14,

	MATERIAL_EDITORDISPLAY											= 502,
		MATERIAL_EDITORDISPLAY_COMBINED						= 0,
		MATERIAL_EDITORDISPLAY_COLOR							= 1,
		MATERIAL_EDITORDISPLAY_DIFFUSION					= 2,
		MATERIAL_EDITORDISPLAY_LUMINANCE					= 3,
		MATERIAL_EDITORDISPLAY_BUMP								= 4,
		MATERIAL_EDITORDISPLAY_NORMAL							= 5,
		MATERIAL_EDITORDISPLAY_ALPHA							= 6,
		MATERIAL_EDITORDISPLAY_TRANSPARENCY				= 7,
		MATERIAL_EDITORDISPLAY_DISPLACEMENT				= 8,
		MATERIAL_EDITORDISPLAY_REFLECTANCE				= 9,
		MATERIAL_EDITORDISPLAY_ENVIRONMENT				= 10,
		MATERIAL_EDITORDISPLAY_SPECULARCOLOR			= 11,

	MATERIAL_ANIMATEPREVIEW											= 501,

	MATERIAL_COLOR_SHADER												= 8000,
	MATERIAL_DIFFUSION_SHADER 									= 8001,
	MATERIAL_LUMINANCE_SHADER 									= 8002,
	MATERIAL_TRANSPARENCY_SHADER 								= 8003,
	MATERIAL_REFLECTION_SHADER 									= 8004,
	MATERIAL_ENVIRONMENT_SHADER 								= 8005,
	MATERIAL_BUMP_SHADER 												= 8006,
	MATERIAL_ALPHA_SHADER												= 8007,
	MATERIAL_SPECULAR_SHADER										= 8008,
	MATERIAL_DISPLACEMENT_SHADER								= 8009,
	MATERIAL_NORMAL_SHADER											= 8012,

	MATERIAL_TRANSPARENCY_DISPERSION						= 8020,
	MATERIAL_REFLECTION_DISPERSION							= 8021,

	MATERIAL_OPEN_IN_NODEEDITOR									= 8023,
	
	// virtual ID
	MATERIAL_SPECULARPREVIEW										= 8010,
	ID_MATERIALGROUP_SUBPOLY										= 8011,
	ID_MATERIALGROUP_REFLECTANCE_PREVIEW				= 8014,
	ID_MATERIALGROUP_TESSELLATION								= 8013,
};

#endif // MMATERIAL_H__
