#ifndef VPRSRENDEDER_H__
#define VPRSRENDEDER_H__

enum
{
	REDSHIFT_RENDERER_PARAMETER_START = 1000,

	//--------------------------------------------------------------------------
	// General Tab

	// General/Progressive Rendering
	REDSHIFT_RENDERER_GROUP_PROGRESSIVE_RENDERING = 1000,
	REDSHIFT_RENDERER_PROGRESSIVE_RENDERING_ENABLED_LEGACY,
	REDSHIFT_RENDERER_PROGRESSIVE_IPR_FORCE_LEGACY,
	REDSHIFT_RENDERER_PROGRESSIVE_RENDERING_NUM_PASSES,
	REDSHIFT_RENDERER_PROGRESSIVE_FAST_PREPROC,
	REDSHIFT_RENDERER_RENDER_MODE_IPR,
	REDSHIFT_RENDERER_RENDER_MODE_FINAL,

	// General/Sampling
	REDSHIFT_RENDERER_GROUP_SAMPLING = 1100,
	REDSHIFT_RENDERER_UNIFIED_MIN_SAMPLES,
	REDSHIFT_RENDERER_UNIFIED_MAX_SAMPLES,
	REDSHIFT_RENDERER_UNIFIED_ADAPTIVE_ERROR_THRESHOLD,
	REDSHIFT_RENDERER_UNIFIED_DEBUG_DRAW_SAMPLES,
	REDSHIFT_RENDERER_UNIFIED_DISABLE_DIVISION,
	REDSHIFT_RENDERER_UNIFIED_RANDOMIZE_PATTERN,
	REDSHIFT_RENDERER_ENABLE_AUTOMATIC_SAMPLING,
	REDSHIFT_RENDERER_UNIFIED_ENABLE_DIVISION,					// Virtual

	// General/Filtering
	REDSHIFT_RENDERER_GROUP_FILTERING = 1200,
	REDSHIFT_RENDERER_UNIFIED_FILTER_TYPE,
	REDSHIFT_RENDERER_UNIFIED_FILTER_SIZE,
	REDSHIFT_RENDERER_UNIFIED_MAX_OVERBRIGHT,
	REDSHIFT_RENDERER_GLOSSY_RAY_MAX_OVERBRIGHT,

	// General/Sampling Override
	REDSHIFT_RENDERER_GROUP_SAMPLING_OVERRIDE = 1300,
	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_REFLECTION,
	REDSHIFT_RENDERER_REFLECT_SAMPLES_ENABLED,
	REDSHIFT_RENDERER_REFLECT_SAMPLES_MODE,
	REDSHIFT_RENDERER_REFLECT_SAMPLES_COUNT,
	REDSHIFT_RENDERER_REFLECT_SAMPLES_SCALE,

	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_REFRACTION,
	REDSHIFT_RENDERER_REFRACT_SAMPLES_ENABLED,
	REDSHIFT_RENDERER_REFRACT_SAMPLES_MODE,
	REDSHIFT_RENDERER_REFRACT_SAMPLES_COUNT,
	REDSHIFT_RENDERER_REFRACT_SAMPLES_SCALE,

	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_AO,
	REDSHIFT_RENDERER_AO_SAMPLES_ENABLED,
	REDSHIFT_RENDERER_AO_SAMPLES_MODE,
	REDSHIFT_RENDERER_AO_SAMPLES_COUNT,
	REDSHIFT_RENDERER_AO_SAMPLES_SCALE,

	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_LIGHT,
	REDSHIFT_RENDERER_LIGHT_SAMPLES_ENABLED,
	REDSHIFT_RENDERER_LIGHT_SAMPLES_MODE,
	REDSHIFT_RENDERER_LIGHT_SAMPLES_COUNT,
	REDSHIFT_RENDERER_LIGHT_SAMPLES_SCALE,

	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_VOLUME,
	REDSHIFT_RENDERER_VOLUME_SAMPLES_ENABLED,
	REDSHIFT_RENDERER_VOLUME_SAMPLES_MODE,
	REDSHIFT_RENDERER_VOLUME_SAMPLES_COUNT,
	REDSHIFT_RENDERER_VOLUME_SAMPLES_SCALE,

	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_SINGLE_SCATTERING,
	REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_ENABLED,
	REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_MODE,
	REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_COUNT,
	REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_SCALE,

	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MULTIPLE_SCATTERING,
	REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_ENABLED,
	REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_MODE,
	REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_COUNT,
	REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_SCALE,

	// General/Motion Blur
	REDSHIFT_RENDERER_GROUP_MOTIONBLUR = 1400,
	REDSHIFT_RENDERER_MOTION_BLUR_ENABLED,
	REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_ENABLED,
	REDSHIFT_RENDERER_MOTION_BLUR_NUM_TRANSFORMATION_STEPS,
	REDSHIFT_RENDERER_MOTION_BLUR_FRAME_DURATION,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_START,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_END,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_POSITION,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_EFFICIENCY_FOR_TRAPEZOIDAL,
	REDSHIFT_RENDERER_MOTION_BLUR_NUM_DEFORMATION_STEPS,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TYPE,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TIME_RATIO,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_ANGLE,			// Virtual, Maps to Frame Duration
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_OFFSET_ANGLE,		// Virtual Maps to Offset Frames
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_OFFSET_FRAMES,

	// General/Gamma
	REDSHIFT_RENDERER_GROUP_COLOR_MANAGEMENT = 1500,
	REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_CONFIG,
	REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_RENDERING_COLORSPACE,
	REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_DISPLAY,
	REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_VIEW,
	REDSHIFT_RENDERER_COLOR_MANAGEMENT_COMPENSATE_VIEW_TRANSFORM,
	REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_USE_FILE_RULES,
	REDSHIFT_RENDERER_COLOR_MANAGEMENT_NATIVE_MODE,

	// General/Enironment
	REDSHIFT_RENDERER_GROUP_ENVIRONMENT = 1600,
	REDSHIFT_RENDERER_ENVIRONMENT,
	REDSHIFT_RENDERER_ATMOSPHERE_DEPRECATED,				// Deprecated

	// General/Lens
	REDSHIFT_RENDERER_GROUP_LENS = 1700,
	REDSHIFT_RENDERER_EFFECT_CAMERA,

	// General/Photometric Units
	REDSHIFT_RENDERER_GROUP_PHOTOMETRIC_UNITS = 1800,
	REDSHIFT_RENDERER_PHOTOMETRIC_UNITS_TO_METER_SCALE,
	REDSHIFT_RENDERER_PHOTOMETRIC_CANDELA_METERS_SQUARED_FACTOR,

	// General/Quantize
	REDSHIFT_RENDERER_GROUP_QUANTIZATION = 1900,
	REDSHIFT_RENDERER_DO_8BIT_QUANTIZATION_AND_DITHERING,

	// General/Denoise
	REDSHIFT_RENDERER_GROUP_DENOISE = 2000,
	REDSHIFT_RENDERER_DENOISE_ENGINE_DEPRECATED,
	REDSHIFT_RENDERER_DENOISE_AUTO_CREATE_AOVS,
	REDSHIFT_RENDERER_DENOISE_BUFFERS_SHOW,
	REDSHIFT_RENDERER_DENOISE_BUFFERS_SAVE,
	REDSHIFT_RENDERER_DENOISE_AOVS,
	REDSHIFT_RENDERER_DENOISE_ENABLED,
	REDSHIFT_RENDERER_DENOISE_ENGINE,
	REDSHIFT_RENDERER_DENOISE_ENGINE_RT,

	// General/Denoise/Altus
	REDSHIFT_RENDERER_GROUP_DENOISE_ALTUS = 2100,
	REDSHIFT_RENDERER_DENOISE_ALTUS_KC1,
	REDSHIFT_RENDERER_DENOISE_ALTUS_KC2,
	REDSHIFT_RENDERER_DENOISE_ALTUS_KC4,
	REDSHIFT_RENDERER_DENOISE_ALTUS_KF,
	REDSHIFT_RENDERER_DENOISE_ALTUS_INFO_DEPRECATED,
	REDSHIFT_RENDERER_DENOISE_ALTUS_LINK_DEPRECATED,

	REDSHIFT_RENDERER_GROUP_DENOISE_OVERHEAD = 2150,
	REDSHIFT_RENDERER_DENOISE_OVERHEAD_BUCKET,
	REDSHIFT_RENDERER_DENOISE_OVERHEAD_PROGRESSIVE,

	//--------------------------------------------------------------------------
	// AOV Tab
	// AOV/General
	REDSHIFT_RENDERER_AOV_GROUP_GENERAL = 3000,
	REDSHIFT_RENDERER_AOV_GLOBAL_MODE,

	REDSHIFT_RENDERER_AOV_PATH,
	REDSHIFT_RENDERER_AOV_MULTIPART,
	REDSHIFT_RENDERER_AOV_AUTOCROP,
	REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION,
	REDSHIFT_RENDERER_AOV_FILE_EXR_DWA_COMPRESSION,
	REDSHIFT_RENDERER_AOV_FILE_STORAGE,
	REDSHIFT_RENDERER_AOV_MULTIPASS_COMPATIBILITY,
	REDSHIFT_RENDERER_AOV_MULTIPASS_PFX_PREVIEW_MODE,					// Internal Use

	// AOV/Active AOVs
	REDSHIFT_RENDERER_AOV_GROUP_ACTIVE_AOVS = 3100,
	REDSHIFT_RENDERER_AOV_COUNT,
	REDSHIFT_RENDERER_AOV_LAYER_FIRST,
	REDSHIFT_RENDERER_AOV_LAYER_LAST = 3198, // 96 Layers

	// AOV/Processing
	REDSHIFT_RENDERER_AOV_GROUP_PROCESSING = 3200,
	REDSHIFT_RENDERER_AOV_ENABLE_DEEP_OUTPUT,
	REDSHIFT_RENDERER_AOV_DEEP_MERGE_MODE,
	REDSHIFT_RENDERER_AOV_DEEP_MERGE_Z_THRESHOLD,
	REDSHIFT_RENDERER_AOV_MAX_OVERBRIGHT_ENABLE,
	REDSHIFT_RENDERER_AOV_MAX_OVERBRIGHT,
	REDSHIFT_RENDERER_AOV_DISABLE_IMPORTANCE_OPTIMIZATIONS,
	REDSHIFT_RENDERER_AOV_FIX_RAW_HALO_ARTIFACTS,
	REDSHIFT_RENDERER_AOV_ENABLE_IMPORTANCE_OPTIMIZATIONS,		// Virtual for REDSHIFT_RENDERER_AOV_DISABLE_IMPORTANCE_OPTIMIZATIONS
	REDSHIFT_RENDERER_AOV_DEEP_MERGE_ALPHA_THRESHOLD,			// As of 3.0.58

	//--------------------------------------------------------------------------
	// Opt Tab
	// Opt/MaxTraceDepth
	REDSHIFT_RENDERER_OPT_GROUP_MAX_TRACE_DEPTH = 5000,
	REDSHIFT_RENDERER_MAX_TRACE_DEPTH_REFLECTION,
	REDSHIFT_RENDERER_MAX_TRACE_DEPTH_REFRACTION,
	REDSHIFT_RENDERER_MAX_TRACE_DEPTH_COMBINED,
	REDSHIFT_RENDERER_MAX_TRACE_DEPTH_TRANSPARENCY,
	REDSHIFT_RENDERER_MAX_TRACE_DEPTH_VOLUME,

	// Opt/Hair MPW
	REDSHIFT_RENDERER_OPT_GROUP_HAIR = 5100,
	REDSHIFT_RENDERER_MPW_HAIR_ENABLED,
	REDSHIFT_RENDERER_MPW_HAIR_AUTO_THRESHOLD,
	REDSHIFT_RENDERER_MPW_HAIR_THRESHOLD,
	REDSHIFT_RENDERER_MPW_HAIR_TRACE_DEPTH,

	// Opt/CutOff Thresholds
	REDSHIFT_RENDERER_OPT_GROUP_CUTOFF_THRESHOLDS = 5200,
	REDSHIFT_RENDERER_DIFFUSE_SAMPLING_CUT_OFF_THRESHOLD,
	REDSHIFT_RENDERER_REFLECTION_SAMPLING_CUT_OFF_THRESHOLD,
	REDSHIFT_RENDERER_REFRACTION_SAMPLING_CUT_OFF_THRESHOLD,
	REDSHIFT_RENDERER_DIRECT_LIGHTING_SHADOW_CUT_OFF_THRESHOLD,
	REDSHIFT_RENDERER_DIRECT_LIGHTING_CUT_OFF_THRESHOLD,

	// Opt/Russian Roulette
	REDSHIFT_RENDERER_OPT_GROUP_RUSSIAN_ROULETTE = 5300,
	REDSHIFT_RENDERER_RUSSIAN_ROULETTE_IMPORTANCE_THRESHOLD,
	REDSHIFT_RENDERER_RUSSIAN_ROULETTE_FALLOFF,

	// Opt/Texture Sampling
	REDSHIFT_RENDERER_OPT_GROUP_TEXTURE_SAMPLING = 5400,
	REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE,
	REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE_SECONDARY_RAYS_DEPRECATED,					// Deprecated as of 2.0.83
	REDSHIFT_RENDERER_SECONDARY_RAYS_TRACE_DEPTH_FOR_DISABLING_MIP_FILTERING_DEPRECATED,	// Deprecated as of 2.0.83
	REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE_SHADOWS_DEPRECATED,						// Deprecated as of 2.0.83
	REDSHIFT_RENDERER_SHADOW_RAYS_TRACE_DEPTH_FOR_DISABLING_MIP_FILTERING_DEPRECATED,		// Deprecated as of 2.0.83
	REDSHIFT_RENDERER_COPY_TO_TEXTURE_CACHE,
	REDSHIFT_RENDERER_BUMP_MAP_BIAS,														// As of 2.6.10

	// Opt/Global Overrides
	REDSHIFT_RENDERER_OPT_GROUP_GLOBAL_OVERRIDES = 5500,
	REDSHIFT_RENDERER_REFLECTIONS_ENABLE,
	REDSHIFT_RENDERER_REFRACTIONS_ENABLE,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_ENABLE,
	REDSHIFT_RENDERER_TESSELLATION_DISPLACEMENT_ENABLE,
	REDSHIFT_RENDERER_EMISSION_ENABLE,
	REDSHIFT_RENDERER_MATERIAL_MAX_COMBINE_TRACE_DEPTH_ENABLE,
	REDSHIFT_RENDERER_DOME_LIGHTS_AFFECTED_BY_REFRACTION_ENABLE,
	REDSHIFT_RENDERER_AREA_LIGHTS_AFFECTED_BY_REFRACTION_ENABLE,

	REDSHIFT_RENDERER_GLOBALS_GROUP_OPTIONS = 5600,

	//--------------------------------------------------------------------------
	// GI Tab
	// GI/General
	REDSHIFT_RENDERER_GI_GROUP_GENERAL = 7000,
	REDSHIFT_RENDERER_PRIMARY_GI_ENGINE,
	REDSHIFT_RENDERER_SECONDARY_GI_ENGINE,
	REDSHIFT_RENDERER_NUM_GI_BOUNCES,
	REDSHIFT_RENDERER_CONSERVE_GI_REFLECTION_ENERGY,
	REDSHIFT_RENDERER_GI_ENABLED,
	REDSHIFT_RENDERER_COMBINED_GI_BOUNCES,

	// GI/BruteForce
	REDSHIFT_RENDERER_GI_GROUP_BRUTE_FORCE_GI_DEPRECATED = 7100,
	REDSHIFT_RENDERER_BRUTE_FORCE_GI_NUM_RAYS,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_MODE,

	// GI/Irradiance Point Cloud
	REDSHIFT_RENDERER_GI_GROUP_IRRADIANCE_POINT_CLOUD = 7200,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_FILENAME,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_BLEND_FRAMES,
	REDSHIFT_RENDERER_SHOW_IRRADIANCE_POINT_CLOUD_CALCULATION,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_NUM_SAMPLES_PER_PIXEL,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_FILTER_SIZE,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_RETRACE_THRESHOLD,

	// GI/Irradiance Caching
	REDSHIFT_RENDERER_GI_GROUP_IRRADIANCE_CACHING = 7300,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_FILENAME,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_BLEND_FRAMES,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_FLYTHROUGH_MODE,
	REDSHIFT_RENDERER_SHOW_IRRADIANCE_CACHE_CALCULATION,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_USE_SEPARATE_POINTS_FOR_SECONDARY_RAYS,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_DEBUG_DRAW_POINTS,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_MIN_RATE,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_MAX_RATE,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_COLOR_THRESHOLD,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_DISTANCE_THRESHOLD,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_NORMAL_THRESHOLD,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_MIN_DETAIL,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_RADIUS_FACTOR,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_NUM_RAYS,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_ADAPTIVE_AMOUNT,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_ADAPTIVE_ERROR_THRESHOLD,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_NUM_SMOOTHING_PASSES,

	//--------------------------------------------------------------------------
	// Photon Tab
	// Photon/General
	REDSHIFT_RENDERER_PHOTON_GROUP_GENERAL = 9000,
	REDSHIFT_RENDERER_PHOTON_GI_ENABLE,
	REDSHIFT_RENDERER_PHOTON_CAUSTICS_ENABLE,
	REDSHIFT_RENDERER_PHOTON_MODE,
	REDSHIFT_RENDERER_PHOTON_FILENAME,
	REDSHIFT_RENDERER_PHOTON_MAX_TRACE_DEPTH_REFLECTION,
	REDSHIFT_RENDERER_PHOTON_MAX_TRACE_DEPTH_REFRACTION,
	REDSHIFT_RENDERER_PHOTON_MAX_TRACE_DEPTH_COMBINED,
	REDSHIFT_RENDERER_PHOTON_GI_MAX_NUM_TO_GATHER,
	REDSHIFT_RENDERER_PHOTON_GI_SEARCH_RADIUS,
	REDSHIFT_RENDERER_PHOTON_CAUSTICS_MAX_NUM_TO_GATHER,
	REDSHIFT_RENDERER_PHOTON_CAUSTICS_SEARCH_RADIUS,
	REDSHIFT_RENDERER_PHOTON_USE_PER_PHOTON_IRRADIANCE,

	//--------------------------------------------------------------------------
	// SSS Tab
	// SSS/General
	REDSHIFT_RENDERER_SSS_GROUP_GENERAL = 11000,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_FILENAME,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_INTERPOLATION_QUALITY,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_NUM_GI_RAYS,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_OVERRIDE_MODE,

	//--------------------------------------------------------------------------
	// System Tab
	// System/Log
	REDSHIFT_RENDERER_SYSTEM_GROUP_LOG = 20100,
	REDSHIFT_RENDERER_LOG_LEVEL,
	REDSHIFT_RENDERER_LOG_IPR,
	REDSHIFT_RENDERER_LOG_DIAGNOSTICS,
	REDSHIFT_RENDERER_LOG_SCENE_VALIDATION,

	// System/Feedback Display
	REDSHIFT_RENDERER_SYSTEM_GROUP_FEEDBACK_DISPLAY = 20200,
	REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL,

	// System/Error-Handling
	REDSHIFT_RENDERER_SYSTEM_GROUP_ERROR_HANDLING = 20300,
	REDSHIFT_RENDERER_ABORT_ON_LICENSE_FAIL,
	REDSHIFT_RENDERER_ABORT_ON_MISSING_RESOURCE,

	// System/Material Override
	REDSHIFT_RENDERER_SYSTEM_GROUP_MATERIAL_OVERRIDE = 20400,
	REDSHIFT_RENDERER_MATERIAL_OVERRIDE_ENABLED,
	REDSHIFT_RENDERER_MATERIAL_OVERRIDE_COLOR,

	// System/Raytracing Accelaration
	REDSHIFT_RENDERER_SYSTEM_GROUP_RAYTRACING_ACCELERATION_STRUCTURE = 20600,
	REDSHIFT_RENDERER_DO_COMPLETE_RTH_CONSTRUCTION,
	REDSHIFT_RENDERER_RTH_MAX_NUM_LEAF_PRIMITIVES,

	// System/ShadowLinking
	REDSHIFT_RENDERER_SYSTEM_GROUP_SHADOW_LINKING  = 20700,
	REDSHIFT_RENDERER_SHADOW_LINKING_MODE,

	// System/Hair Tessellation
	REDSHIFT_RENDERER_SYSTEM_GROUP_HAIR_TESSELLATION = 20800,
	REDSHIFT_RENDERER_HAIR_TESSELLATION_MODE,

	// System/Experimental options
	REDSHIFT_RENDERER_SYSTEM_GROUP_EXPERIMENTAL_OPTIONS = 20900,
	REDSHIFT_RENDERER_RENDER_IN_CAMERA_SPACE,
	REDSHIFT_RENDERER_DISABLE_BUMP_SMOOTHING_ON_LIGHTING_SILHOUETTES,
	REDSHIFT_RENDERER_ENABLE_FAULTY_MEMORY_CHECK_DEPRECATED,				// Deprecated as of 2.0.45
	REDSHIFT_RENDERER_FRAME_INDEPENDENT_PATTERN_RANDOMIZATION_DEPRECATED,	// Deprecated as of 2.0.45
	REDSHIFT_RENDERER_RENDER_TWO_PASSES_FOR_DENOISING_DEPRECATED,			// As of 2.0.45. Deprecated as of 2.6.00
	REDSHIFT_RENDERER_FREEZE_TESSELLATION,									// As of 2.0.66
	REDSHIFT_RENDERER_DISABLE_SHADOW_RAY_BIASING,							// As of 2.5.02 moved here from deprecated group
	REDSHIFT_RENDERER_ENABLE_SECONDARY_RAY_CLAMPING_ON_FIRST_BOUNCE,		// As of 2.5.02
	REDSHIFT_RENDERER_ENABLE_LEGACY_CUT_OFFS_RULES,
	REDSHIFT_RENDERER_ENABLE_LEGACY_VOLUME_GRID_EMISSION,					// As of 2.5.38
	REDSHIFT_RENDERER_ENABLE_LEGACY_NON_INVSQ_LIGHT_DECAY,					// As of 2.5.55
	REDSHIFT_RENDERER_ENABLE_LEGACY_BUMP_SAMPLING_TECHNIQUE,				// As of 2.5.72
	REDSHIFT_RENDERER_ENABLE_LEGACY_NO_GI_FROM_VOLUME_SCATTERING,			// As of 2.6.15
	REDSHIFT_RENDERER_ENABLE_LEGACY_COLOR_MANAGEMENT_HAIR,					// As of 2.6.39
	REDSHIFT_RENDERER_ENABLE_LEGACY_COLOR_MANAGEMENT_XPARTICLES,			// As of 2.6.39
	REDSHIFT_RENDERER_DISABLE_SAMPLING_OPTIMIZATIONS,						// As of 3.0.00
	REDSHIFT_RENDERER_ENABLE_HARDWARE_RAYTRACING,							// As of 3.0.00
	REDSHIFT_RENDERER_ENABLE_LEGACY_STANDARD_MATERIAL_CONVERSION,			// As of 2.6.45
	REDSHIFT_RENDERER_ENABLE_AUTOMATIC_SAMPLING_DEPRECATED,					// As of 3.0.13
	REDSHIFT_RENDERER_ENABLE_LEGACY_COLOR_MANAGEMENT_MATERIAL_OVERRIDE,		// As of 3.0.17
	REDSHIFT_RENDERER_ENABLE_LEGACY_NON_SCALING_OF_POINT_CLOUDS,			// As of 2.6.54/3.0.18
	REDSHIFT_RENDERER_ENABLE_LEGACY_CAMERA_TRANSFORMATION_BLUR,
	REDSHIFT_RENDERER_ENABLE_LEGACY_REFRACTION_AFFECTS_ALPHA_CHANNEL,		// As of 3.0.31
	REDSHIFT_RENDERER_ENABLE_LEGACY_STANDARD_SKY_CONVERSION,				// As of 3.0.38
	REDSHIFT_RENDERER_ENABLE_BUMP_SMOOTHING_ON_LIGHTING_SILHOUETTES,		// Virtual for REDSHIFT_RENDERER_DISABLE_BUMP_SMOOTHING_ON_LIGHTING_SILHOUETTES
	REDSHIFT_RENDERER_ENABLE_SHADOW_RAY_BIASING,							// Virtual for REDSHIFT_RENDERER_DISABLE_SHADOW_RAY_BIASING
	REDSHIFT_RENDERER_ENABLE_SAMPLING_OPTIMIZATIONS,						// Virtual for REDSHIFT_RENDERER_DISABLE_SAMPLING_OPTIMIZATIONS
	REDSHIFT_RENDERER_ENABLE_LEGACY_BLACKBODY_AND_DISPERSION_TECHNIQUE,		// As of 3.0.50
	REDSHIFT_RENDERER_ENABLE_LEGACY_STANDARD_AO_EMULATION,					// As of 3.0.58
	REDSHIFT_RENDERER_ENABLE_LEGACY_SSS_GI,									// As of 3.5.05
	REDSHIFT_RENDERER_ENABLE_LEGACY_VOLUME_PHASE,							// As of 3.5.05
	REDSHIFT_RENDERER_MATERIAL_PROCESSING_MODE,
	REDSHIFT_RENDERER_TEXTURE_PROJECTION_MODE,
	REDSHIFT_RENDERER_ENABLE_AUTOMATIC_VELOCITY_SOURCES,					// As of 3.5.09
	REDSHIFT_RENDERER_SHADING_NORMAL_ADAPTATION_TECHNIQUE,					// As of 3.5.11
	REDSHIFT_RENDERER_ENABLE_LEGACY_DISPERSION_NESTED_DIELECTRICS_TECHNIQUE,// As of 3.5.13
	REDSHIFT_RENDERER_LEGACY_C4D_HAIR_EVALUATION,							// As of 3.5.13
	REDSHIFT_RENDERER_LEGACY_TIME,

	// System/Bucket Rendering
	REDSHIFT_RENDERER_SYSTEM_GROUP_BUCKET_RENDERING = 21000,
	REDSHIFT_RENDERER_BLOCK_SIZE,
	REDSHIFT_RENDERER_BLOCK_RENDERING_ORDER,

	// System/Debug Capture
	REDSHIFT_RENDERER_SYSTEM_GROUP_DEBUG_CAPTURE = 21100,
	REDSHIFT_RENDERER_ENABLE_DEBUG_CAPTURE,
	REDSHIFT_RENDERER_ENABLE_DEBUG_CAPTURE_SHADER_INTEGRITY_CHECK,

	// System/Rendering Engine
	REDSHIFT_RENDERER_SYSTEM_GROUP_ENGINE = 21150,
	REDSHIFT_RENDERER_RENDERING_ENGINE,

	// System/Global Preferences
	REDSHIFT_RENDERER_SYSTEM_GROUP_DEBUG_GLOBAL_PREFERENCES = 21200,

	REDSHIFT_RENDERER_SYSTEM_GROUP_LEGACY_COMPATIBILITY_OPTIONS = 21250,

	//--------------------------------------------------------------------------
	// Memory Tab
	// Memory/General
	REDSHIFT_RENDERER_MEMORY_GROUP_GENERAL = 23000,
	REDSHIFT_RENDERER_PERCENTAGE_OF_GPU_MEMORY_TO_USE,
	REDSHIFT_RENDERER_MAX_NUM_GPU_MB_FOR_IRRADIANCE_POINT_CLOUD_HIERARCHY,
	REDSHIFT_RENDERER_MAX_NUM_GPU_MB_FOR_FOR_ICP_HIERARCHY,
	REDSHIFT_RENDERER_PERCENTAGE_OF_FREE_MEMORY_USED_FOR_TEXTURE_CACHE,
	REDSHIFT_RENDERER_MAX_NUM_GPU_MB_FOR_TEXTURE_CACHE,
	REDSHIFT_RENDERER_MAX_NUM_CPU_MB_FOR_TEXTURE_CACHE,
	REDSHIFT_RENDERER_NUM_GPU_MB_TO_RESERVE_FOR_RAYS,
	REDSHIFT_RENDERER_AUTOMATIC_MEMORY_MANAGEMENT,
	REDSHIFT_RENDERER_GPU_MEMORY_INACTIVITY_TIMEOUT,
	REDSHIFT_RENDERER_NVLINK_FOR_VOLUME_GRIDS,
	REDSHIFT_RENDERER_NVLINK_FOR_GEOMETRY,
	REDSHIFT_RENDERER_MAPPED_TEXTURE_CACHE_MODE,

	REDSHIFT_RENDERER_INTERNAL_GROUP = 23900,
	REDSHIFT_RENDERER_ENABLE_AUTOMATIC_REPROCESSING_OF_PRECONVERTED_TEXTURES,
	REDSHIFT_RENDERER_ENABLE_DETAILED_TEXTURE_PROCESSING_REPORTING,
	REDSHIFT_RENDERER_TEXTURE_RELOADING_ENABLED,

	//--------------------------------------------------------------------------
	// Integration Tab
	// Integration/Baking
	REDSHIFT_RENDERER_INTEGRATION_GROUP_SHADER_BAKING = 24000,
	REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_WIDTH,
	REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_HEIGHT,
	REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH,
	REDSHIFT_RENDERER_SHADER_BAKING_FREEZE,
	REDSHIFT_RENDERER_SHADER_BAKING_SKY_WIDTH,
	REDSHIFT_RENDERER_SHADER_BAKING_SKY_HEIGHT,
	REDSHIFT_RENDERER_SHADER_BAKING_SKY_DEPTH,
	REDSHIFT_RENDERER_SHADER_BAKING_MULTITHREADING,

	REDSHIFT_RENDERER_INTEGRATION_GROUP_OPTIONS = 25000,
	REDSHIFT_RENDERER_INTEGRATION_OPTIONS_DEFAULT_LIGHT,
	REDSHIFT_RENDERER_INTEGRATION_EXPORT_SCALE,
	REDSHIFT_RENDERER_INTEGRATION_EXPORT_SCALE_COMPENSATION,
	REDSHIFT_RENDERER_INTEGRATION_EXPORT_SCALE_LEGACY,
	REDSHIFT_RENDERER_INTEGRATION_EXPORT_EFFECTIVE_SCALE,
	REDSHIFT_RENDERER_INTEGRATION_EXPORT_SCALE_GEOMETRY,

	REDSHIFT_RENDERER_INTEGRATION_GROUP_UNITS = 25900,

	REDSHIFT_RENDERER_INTEGRATION_GROUP_EXPERIMENTAL = 26000,
	REDSHIFT_RENDERER_INTEGRATION_INSTANCE_OPTIMIZATIONS,
	REDSHIFT_RENDERER_INTEGRATION_RENDERVIEW_OPEN,
	REDSHIFT_RENDERER_INTEGRATION_POSTEFFECT_MODE,					// Internal Use
	REDSHIFT_RENDERER_INTEGRATION_BAKEID,							// Internal Use
	REDSHIFT_RENDERER_INTEGRATION_NOTIFY_PHOTON_MAP_DEPRECATION,	// Internal Use
	REDSHIFT_RENDERER_INTEGRATION_CINEWARE_FORMAT_VERSION,			// Internal Use
	REDSHIFT_RENDERER_INTEGRATION_ORIGINAL_CONTAINER_DIRTY,			// Internal Use

	//--------------------------------------------------------------------------
	// Overview
	REDSHIFT_RENDERER_SETTING_MODE = 60000,

	// Basic Tab
	REDSHIFT_RENDERER_BASIC_QUALITY_PRESET,
	REDSHIFT_RENDERER_BASIC_UNIFIED_ADAPTIVE_ERROR_THRESHOLD,
	REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED,
	REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_TRANSPARENCY,
	REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_REFLECTION,
	REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_REFRACTION,
	REDSHIFT_RENDERER_BASIC_GI_ENABLED,
	REDSHIFT_RENDERER_BASIC_DENOISE,
	REDSHIFT_RENDERER_BASIC_DENOISE_ENGINE,
	REDSHIFT_RENDERER_BASIC_MOTION_BLUR,
	REDSHIFT_RENDERER_BASIC_MOTION_BLUR_TRANSFORMATIOM_STEPS,
	REDSHIFT_RENDERER_BASIC_MOTION_BLUR_DEFORMATION_ENABLED,
	REDSHIFT_RENDERER_BASIC_HARDWARE_RAYTRACING,
	REDSHIFT_RENDERER_BASIC_MODIFIED,
	REDSHIFT_RENDERER_BASIC_COMBINED_GI_BOUNCES,
	REDSHIFT_RENDERER_BASIC_RENDERING_ENGINE,
	REDSHIFT_RENDERER_BASIC_PROGRESSIVE_RENDERING_NUM_PASSES,
	REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_VOLUME,


	// Virtual Parameters
	REDSHIFT_RENDERER_SETTING_MODE_TAB_SAMPLING = 60100,
	REDSHIFT_RENDERER_SETTING_MODE_TAB_MOTION_BLUR,
	REDSHIFT_RENDERER_SETTING_MODE_TAB_GLOBALS,
	REDSHIFT_RENDERER_SETTING_MODE_TAB_GI,
	REDSHIFT_RENDERER_SETTING_MODE_TAB_CAUSTICS,
	REDSHIFT_RENDERER_SETTING_MODE_TAB_AOV,
	REDSHIFT_RENDERER_SETTING_MODE_TAB_OPT,
	REDSHIFT_RENDERER_SETTING_MODE_TAB_SYSTEM,

	//--------------------------------------------------------------------------
	// Misc
	REDSHIFT_RENDERER_INTEGRATION_POSTEFFECT_MODE_INTERNAL = 0, // DEPRECATED
	REDSHIFT_RENDERER_INTEGRATION_POSTEFFECT_MODE_ENABLED,
	REDSHIFT_RENDERER_INTEGRATION_POSTEFFECT_MODE_DISABLED,

	//--------------------------------------------------------------------------
	// Enum Values
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_POSITION_CENTERONFRAME = 0,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_POSITION_STARTONFRAME,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_POSITION_ENDONFRAME,

	REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_OFF = 0,
	REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_2 = 2,
	REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_3 = 3,
	REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_5 = 5,
	REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_9 = 9,
	REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_17 = 17,

	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TYPE_CUSTOM = 0,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TYPE_STILL,
	REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TYPE_MOVIE,

	REDSHIFT_RENDERER_PROGRESSIVE_FAST_PREPROC_NONE = 0,
	REDSHIFT_RENDERER_PROGRESSIVE_FAST_PREPROC_IPR_ONLY,
	REDSHIFT_RENDERER_PROGRESSIVE_FAST_PREPROC_ALL,

	REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_BOX = 0,
	REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_TRIANGLE,
	REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_GAUSS,
	REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_MITCHELL,
	REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_LANCZOS,

	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_REPLACE = 0,
	REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_SCALE,

	// New enum order as of R2.0.77
	REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE_FELINE = 0,
	REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE_BILINEAR,
	REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE_POINT,

	REDSHIFT_RENDERER_AOV_GLOBAL_MODE_DISABLE = 0,
	REDSHIFT_RENDERER_AOV_GLOBAL_MODE_ENABLE,
	REDSHIFT_RENDERER_AOV_GLOBAL_MODE_BATCH_ONLY,

	// Keep in sync with drsaov
	REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH_INT8 = 0,
	REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH_INT16,
	REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH_INT32,
	REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH_FLOAT16,
	REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH_FLOAT32,
	REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH_MAX,

	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_NONE = 0,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_DEFAULT,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_TIFF_LZW = 100,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_TIFF_CCITTRLE,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_TIFF_ZIP,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_TIFF_PACKBITS,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_RLE = 200,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_ZIP,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_ZIPS,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_PIZ,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_PXR24,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_B44,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_DWAA,
	REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_DWAB,

	REDSHIFT_RENDERER_AOV_FILE_STORAGE_SCANLINE = 0,
	REDSHIFT_RENDERER_AOV_FILE_STORAGE_TILED,

	REDSHIFT_RENDERER_AOV_DEEP_MERGE_MODE_Z = 0,
	REDSHIFT_RENDERER_AOV_DEEP_MERGE_MODE_OBJECT_ID,
	REDSHIFT_RENDERER_AOV_DEEP_MERGE_MODE_MESH_ID,

	REDSHIFT_RENDERER_GIENGINE_NONE = 0,
	REDSHIFT_RENDERER_GIENGINE_PHOTON_MAPPING,
	REDSHIFT_RENDERER_GIENGINE_IRRADIANCE_POINT_CLOUD,
	REDSHIFT_RENDERER_GIENGINE_IRRADIANCE_CACHE,
	REDSHIFT_RENDERER_GIENGINE_BRUTE_FORCE,

	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_4 = 4,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_8 = 8,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_16 = 16,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_32 = 32,
	REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_64 = 64,

	REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD = 0,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_LOAD,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD_PREPASSONLY,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD_DONT_SAVE,

	REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET_CUSTOM = 0,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET_LOW,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET_MEDIUM,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET_HIGH,

	REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_VERY_LOW = 50,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_LOW = 100,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_MEDIUM = 200,
	REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_HIGH = 300,

	REDSHIFT_RENDERER_PHOTON_MODE_REBUILD = 0,
	REDSHIFT_RENDERER_PHOTON_MODE_LOAD,
	REDSHIFT_RENDERER_PHOTON_MODE_REBUILD_DONT_SAVE,
	REDSHIFT_RENDERER_PHOTON_MODE_REBUILD_PREPASSONLY,

	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE_REBUILD = 0,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE_LOAD,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE_REBUILD_PREPASSONLY,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE_REBUILD_DONT_SAVE,

	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_1_64 = 0,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_1_16,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_1_4,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_1_1,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_4_1,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_16_1,

	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_INTERPOLATION_QUALITY_LOW = 4,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_INTERPOLATION_QUALITY_MEDIUM = 16,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_INTERPOLATION_QUALITY_HIGH = 64,

	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_OVERRIDE_MODE_NONE = 0,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_OVERRIDE_MODE_RAY_TRACED,
	REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_OVERRIDE_MODE_POINT_BASED,

	REDSHIFT_RENDERER_LOG_LEVEL_ERRORS_AND_WARNINGS=0,
	REDSHIFT_RENDERER_LOG_LEVEL_DETAILED,
	REDSHIFT_RENDERER_LOG_LEVEL_DEBUG,

	REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL_ALWAYS=0,
	REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL_ERRORS_AND_WARNINGS,
	REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL_ERRORS,
	REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL_NEVER,

	REDSHIFT_RENDERER_SHADOW_LINKING_MODE_USELIGHTLINKS=0,
	REDSHIFT_RENDERER_SHADOW_LINKING_MODE_USESHADOWLINKS,
	REDSHIFT_RENDERER_SHADOW_LINKING_MODE_ALL,

	REDSHIFT_RENDERER_HAIR_TESSELLATION_MODE_NONE=0,
	REDSHIFT_RENDERER_HAIR_TESSELLATION_MODE_4,
	REDSHIFT_RENDERER_HAIR_TESSELLATION_MODE_8,

	REDSHIFT_RENDERER_BLOCK_SIZE_64 = 64,
	REDSHIFT_RENDERER_BLOCK_SIZE_128 = 128,
	REDSHIFT_RENDERER_BLOCK_SIZE_256 = 256,
	REDSHIFT_RENDERER_BLOCK_SIZE_512 = 512,

	REDSHIFT_RENDERER_BLOCK_RENDERING_ORDER_SCANLINE_X=0,
	REDSHIFT_RENDERER_BLOCK_RENDERING_ORDER_SPIRAL,
	REDSHIFT_RENDERER_BLOCK_RENDERING_ORDER_HILBERT,

	REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_8	= 0,
	REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_16,
	REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_32,

	REDSHIFT_RENDERER_DENOISE_ENGINE_NONE = 0,
	REDSHIFT_RENDERER_DENOISE_ENGINE_ALTUS_SINGLEPASS,
	REDSHIFT_RENDERER_DENOISE_ENGINE_ALTUS_DUALPASS,
	REDSHIFT_RENDERER_DENOISE_ENGINE_OPTIX,
	REDSHIFT_RENDERER_DENOISE_ENGINE_OIDN,
	REDSHIFT_RENDERER_DENOISE_ENGINE_MAX,

	REDSHIFT_RENDERER_NVLINK_MODE_AUTOMATIC = 0,
	REDSHIFT_RENDERER_NVLINK_MODE_FORCE_ENABLE,
	REDSHIFT_RENDERER_NVLINK_MODE_FORCE_DISABLE,

	REDSHIFT_RENDERER_RENDERING_ENGINE_PRODUCTION = 0,
	REDSHIFT_RENDERER_RENDERING_ENGINE_RT,

	REDSHIFT_RENDERER_RENDER_MODE_PROGRESSIVE=0,
	REDSHIFT_RENDERER_RENDER_MODE_BUCKET,

	REDSHIFT_RENDERER_SETTING_MODE_BASIC = 0,
	REDSHIFT_RENDERER_SETTING_MODE_ADVANCED,

	REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_LOW = 0,
	REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_MEDIUM,
	REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_HIGH,
	REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_VERY_HIGH,
	REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_CUSTOM,

	REDSHIFT_RENDERER_LEGACY_STANDARD_CONVERSION_NONE = 0,
	REDSHIFT_RENDERER_LEGACY_STANDARD_CONVERSION_ARCHITECTURAL,
	REDSHIFT_RENDERER_LEGACY_STANDARD_CONVERSION_RSMATERIAL,

	REDSHIFT_RENDERER_MATERIAL_PROCESSING_MODE_SINGLE = 0,
	REDSHIFT_RENDERER_MATERIAL_PROCESSING_MODE_STACKED,

	REDSHIFT_RENDERER_TEXTURE_PROJECTION_MODE_BAKED = 0,
	REDSHIFT_RENDERER_TEXTURE_PROJECTION_MODE_PROCEDURAL,

	REDSHIFT_RENDERER_SHADING_NORMAL_ADAPTATION_TECHNIQUE_NONE = 0,
	REDSHIFT_RENDERER_SHADING_NORMAL_ADAPTATION_TECHNIQUE_KELLER,

	REDSHIFT_RENDERER_AOV_MULTIPASS_PFX_PREVIEW_MODE_OFF = 0,
	REDSHIFT_RENDERER_AOV_MULTIPASS_PFX_PREVIEW_MODE_LOCAL,
	REDSHIFT_RENDERER_AOV_MULTIPASS_PFX_PREVIEW_MODE_GLOBAL,

	REDSHIFT_RENDERER_MAPPED_TEXTURE_CACHE_MODE_AUTOMATIC = 0,
	REDSHIFT_RENDERER_MAPPED_TEXTURE_CACHE_MODE_ENABLED,
	REDSHIFT_RENDERER_MAPPED_TEXTURE_CACHE_MODE_DISABLED,

	//--------------------------------------------------------------------------
	// UI Controls
	REDSHIFT_RENDERER_UI_START = 30000,
	REDSHIFT_RENDERER_MEMORY_GENERAL_RESET_TO_DEFAULTS,
	REDSHIFT_RENDERER_SYSTEM_FEEDBACK_DISPLAY_SHOW,
	REDSHIFT_RENDERER_SYSTEM_GLOBAL_PREFS_SHOW,
	REDSHIFT_RENDERER_ENVIRONMENT_CREATE_DEPRECATED,	// Deprecated
	REDSHIFT_RENDERER_ENVIRONMENT_REMOVE_DEPRECATED,	// Deprecated
	REDSHIFT_RENDERER_ATMOSPHERE_CREATE_DEPRECATED,		// Deprecated
	REDSHIFT_RENDERER_ATMOSPHERE_REMOVE_DEPRECATED,		// Deprecated
	REDSHIFT_RENDERER_AOV_QUICK_ADD,
	REDSHIFT_RENDERER_AOV_MANAGER_SHOW,

	//--------------------------------------------------------------------------
	// Tabs
	REDSHIFT_RENDERER_TAB_AOV = 40000,
	REDSHIFT_RENDERER_TAB_OPT,
	REDSHIFT_RENDERER_TAB_GI,
	REDSHIFT_RENDERER_TAB_CAUSTICS,
	REDSHIFT_RENDERER_TAB_SSS_LEGACY,
	REDSHIFT_RENDERER_TAB_SYSTEM,
	REDSHIFT_RENDERER_TAB_MEMORY_LEGACY,
	REDSHIFT_RENDERER_TAB_INTEGRATION_LEGACY,
	REDSHIFT_RENDERER_TAB_BASIC,
	REDSHIFT_RENDERER_TAB_GLOBALS,
	REDSHIFT_RENDERER_TAB_MOTION_BLUR,
	REDSHIFT_RENDERER_TAB_SAMPLING,

	//--------------------------------------------------------------------------
	// Groups
	REDSHIFT_RENDERER_GROUP_CAUSTICS_TRACEDEPTH = 40500,
	REDSHIFT_RENDERER_GROUP_PHOTON_GI,
	REDSHIFT_RENDERER_GROUP_MOTIONBLUR_SHUTTER,
};

#endif // VPRSRENDEDER_H__
