CONTAINER Trscamera
{
	NAME Trscamera;
	INCLUDE Tbase;

	GROUP Obaselist
	{
		DEFAULT 0;
	}

	GROUP REDSHIFT_CAMERA_GROUP_CAMERA_CONVERSION
	{
		DEFAULT 1;
		HIDDEN;
		GROUP
		{
			STRING REDSHIFT_CAMERA_CONVERSION_MESSAGE { ANIM OFF; CUSTOMGUI MULTISTRING; WORDWRAP; READONLY; SCALE_H;  }
		}
		BUTTON REDSHIFT_CAMERA_CONVERT_TO_RSCAMERA { ANIM OFF; }
	}

	GROUP ID_TAGPROPERTIES
	{
		BOOL REDSHIFT_CAMERA_MOTION_BLUR { }
		LONG REDSHIFT_CAMERA_TYPE
		{
			CYCLE
			{
				REDSHIFT_CAMERA_TYPE_STANDARD;
				REDSHIFT_CAMERA_TYPE_FISHEYE;
				REDSHIFT_CAMERA_TYPE_SPHERICAL;
				REDSHIFT_CAMERA_TYPE_CYLINDRICAL;
				REDSHIFT_CAMERA_TYPE_STEREOSPHERICAL;
			}
		}

		SEPARATOR { LINE; }

		GROUP REDSHIFT_CAMERA_GROUP_CAMERA_FISHEYE
		{
			DEFAULT 1;
			HIDDEN;

			REAL REDSHIFT_CAMERA_FISHEYE_ANGLE { MIN 1.0; MAX 180.0; STEP 0.1; UNIT DEGREE; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_CAMERA_FISHEYE_SCALE_X { MIN 0.0; STEP 0.01; CUSTOMGUI REALSLIDER; MAXSLIDER 2.0; }
			REAL REDSHIFT_CAMERA_FISHEYE_SCALE_Y { MIN 0.0; STEP 0.01; CUSTOMGUI REALSLIDER; MAXSLIDER 2.0; }
		}

		GROUP REDSHIFT_CAMERA_GROUP_CAMERA_SPHERICAL
		{
			DEFAULT 1;
			HIDDEN;
		}

		GROUP REDSHIFT_CAMERA_GROUP_CAMERA_CYLINDRICAL
		{
			DEFAULT 1;
			HIDDEN;

			BOOL REDSHIFT_CAMERA_CYLINDRICAL_ORTHOGRAPHIC { };
			REAL REDSHIFT_CAMERA_CYLINDRICAL_FOVH { MIN 0.0; MAX 360.0; STEP 0.1; UNIT DEGREE; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_CAMERA_CYLINDRICAL_FOVV { MIN 0.0; MAX 180.0; STEP 0.1; UNIT DEGREE; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_CAMERA_CYLINDRICAL_ORTHOGRAPHIC_HEIGHT { MIN 0.0; STEP 0.1; CUSTOMGUI REALSLIDER; MAXSLIDER 500.0; }
		}

		GROUP REDSHIFT_CAMERA_GROUP_CAMERA_STEREOSPHERICAL
		{
			DEFAULT 1;
			HIDDEN;

			LONG REDSHIFT_CAMERA_STEREOSPHERICAL_MODE
			{
				CYCLE
				{
					REDSHIFT_CAMERA_STEREOSPHERICAL_MODE_SIDEBYSIDE;
					REDSHIFT_CAMERA_STEREOSPHERICAL_MODE_TOPBOTTOM;
					REDSHIFT_CAMERA_STEREOSPHERICAL_MODE_LEFTONLY;
					REDSHIFT_CAMERA_STEREOSPHERICAL_MODE_RIGHTONLY;
				}
			}

			REAL REDSHIFT_CAMERA_STEREOSPHERICAL_SEPARATION { MIN 0.0; STEP 0.1; CUSTOMGUI REALSLIDER; MAXSLIDER 100.0; }
			BOOL REDSHIFT_CAMERA_STEREOSPHERICAL_FOCUS_ENABLED { }
			BOOL REDSHIFT_CAMERA_STEREOSPHERICAL_DERIVE_FOCUS_DISTANCE { }
			REAL REDSHIFT_CAMERA_STEREOSPHERICAL_FOCUS_DISTANCE { MIN 0.0; STEP 0.1; UNIT METER; CUSTOMGUI REALSLIDER; MAXSLIDER 10000.0; }
			REAL REDSHIFT_CAMERA_STEREOSPHERICAL_FOVH { MIN 1.0; MAX 360.0; STEP 0.1; UNIT DEGREE; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_CAMERA_STEREOSPHERICAL_FOVV { MIN 1.0; MAX 180.0; STEP 0.1; UNIT DEGREE; CUSTOMGUI REALSLIDER; }
		}

		GROUP REDSHIFT_CAMERA_GROUP_ENVIRONMENT
		{
			DEFAULT 1;
			LINK REDSHIFT_CAMERA_ENVIRONMENT
			{
				ACCEPT { Orssky; Mrsgraph; Mmaterial; }
			}
		}

		SEPARATOR { LINE; }

		BUTTON REDSHIFT_POSTEFFECTS_MAKE_GLOBAL { SCALE_H; }
	}

	INCLUDE Drsposteffects;
}
