/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.NoSuchElementException;
import org.apache.http.HeaderIterator;
import org.apache.http.ParseException;
import org.apache.http.TokenIterator;
import org.apache.http.util.Args;

public class BasicTokenIterator
implements TokenIterator {
    public static final String HTTP_SEPARATORS = " ,;=()<>@:\\\"/[]?{}\t";
    protected final HeaderIterator headerIt;
    protected String currentHeader;
    protected String currentToken;
    protected int searchPos;

    public BasicTokenIterator(HeaderIterator headerIterator) {
        this.headerIt = Args.notNull(headerIterator, "Header iterator");
        this.searchPos = this.findNext(-1);
    }

    @Override
    public boolean hasNext() {
        return this.currentToken != null;
    }

    @Override
    public String nextToken() {
        if (this.currentToken == null) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        String string = this.currentToken;
        this.searchPos = this.findNext(this.searchPos);
        return string;
    }

    @Override
    public final Object next() {
        return this.nextToken();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Removing tokens is not supported.");
    }

    protected int findNext(int n2) {
        int n3 = n2;
        if (n3 < 0) {
            if (!this.headerIt.hasNext()) {
                return -1;
            }
            this.currentHeader = this.headerIt.nextHeader().getValue();
            n3 = 0;
        } else {
            n3 = this.findTokenSeparator(n3);
        }
        int n4 = this.findTokenStart(n3);
        if (n4 < 0) {
            this.currentToken = null;
            return -1;
        }
        int n5 = this.findTokenEnd(n4);
        this.currentToken = this.createToken(this.currentHeader, n4, n5);
        return n5;
    }

    protected String createToken(String string, int n2, int n3) {
        return string.substring(n2, n3);
    }

    protected int findTokenStart(int n2) {
        int n3 = Args.notNegative(n2, "Search position");
        boolean bl = false;
        while (!bl && this.currentHeader != null) {
            int n4 = this.currentHeader.length();
            while (!bl && n3 < n4) {
                char c2 = this.currentHeader.charAt(n3);
                if (this.isTokenSeparator(c2) || this.isWhitespace(c2)) {
                    ++n3;
                    continue;
                }
                if (this.isTokenChar(this.currentHeader.charAt(n3))) {
                    bl = true;
                    continue;
                }
                throw new ParseException("Invalid character before token (pos " + n3 + "): " + this.currentHeader);
            }
            if (bl) continue;
            if (this.headerIt.hasNext()) {
                this.currentHeader = this.headerIt.nextHeader().getValue();
                n3 = 0;
                continue;
            }
            this.currentHeader = null;
        }
        return bl ? n3 : -1;
    }

    protected int findTokenSeparator(int n2) {
        int n3 = Args.notNegative(n2, "Search position");
        boolean bl = false;
        int n4 = this.currentHeader.length();
        while (!bl && n3 < n4) {
            char c2 = this.currentHeader.charAt(n3);
            if (this.isTokenSeparator(c2)) {
                bl = true;
                continue;
            }
            if (this.isWhitespace(c2)) {
                ++n3;
                continue;
            }
            if (this.isTokenChar(c2)) {
                throw new ParseException("Tokens without separator (pos " + n3 + "): " + this.currentHeader);
            }
            throw new ParseException("Invalid character after token (pos " + n3 + "): " + this.currentHeader);
        }
        return n3;
    }

    protected int findTokenEnd(int n2) {
        int n3;
        Args.notNegative(n2, "Search position");
        int n4 = this.currentHeader.length();
        for (n3 = n2 + 1; n3 < n4 && this.isTokenChar(this.currentHeader.charAt(n3)); ++n3) {
        }
        return n3;
    }

    protected boolean isTokenSeparator(char c2) {
        return c2 == ',';
    }

    protected boolean isWhitespace(char c2) {
        return c2 == '\t' || Character.isSpaceChar(c2);
    }

    protected boolean isTokenChar(char c2) {
        if (Character.isLetterOrDigit(c2)) {
            return true;
        }
        if (Character.isISOControl(c2)) {
            return false;
        }
        return !this.isHttpSeparator(c2);
    }

    protected boolean isHttpSeparator(char c2) {
        return HTTP_SEPARATORS.indexOf(c2) >= 0;
    }
}

