/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.util.Args;

public class ContentLengthOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private final long contentLength;
    private long total = 0L;
    private boolean closed = false;

    public ContentLengthOutputStream(SessionOutputBuffer sessionOutputBuffer, long l2) {
        this.out = Args.notNull(sessionOutputBuffer, "Session output buffer");
        this.contentLength = Args.notNegative(l2, "Content length");
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.out.flush();
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (this.total < this.contentLength) {
            int n4 = n3;
            long l2 = this.contentLength - this.total;
            if ((long)n4 > l2) {
                n4 = (int)l2;
            }
            this.out.write(byArray, n2, n4);
            this.total += (long)n4;
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (this.total < this.contentLength) {
            this.out.write(n2);
            ++this.total;
        }
    }
}

