/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.io.SessionOutputBuffer;

public class ChunkedOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private final byte[] cache;
    private int cachePosition = 0;
    private boolean wroteLastChunk = false;
    private boolean closed = false;

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer, int n2) {
        this(n2, sessionOutputBuffer);
    }

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer) {
        this(2048, sessionOutputBuffer);
    }

    public ChunkedOutputStream(int n2, SessionOutputBuffer sessionOutputBuffer) {
        this.cache = new byte[n2];
        this.out = sessionOutputBuffer;
    }

    protected void flushCache() {
        if (this.cachePosition > 0) {
            this.out.writeLine(Integer.toHexString(this.cachePosition));
            this.out.write(this.cache, 0, this.cachePosition);
            this.out.writeLine("");
            this.cachePosition = 0;
        }
    }

    protected void flushCacheWithAppend(byte[] byArray, int n2, int n3) {
        this.out.writeLine(Integer.toHexString(this.cachePosition + n3));
        this.out.write(this.cache, 0, this.cachePosition);
        this.out.write(byArray, n2, n3);
        this.out.writeLine("");
        this.cachePosition = 0;
    }

    protected void writeClosingChunk() {
        this.out.writeLine("0");
        this.out.writeLine("");
    }

    public void finish() {
        if (!this.wroteLastChunk) {
            this.flushCache();
            this.writeClosingChunk();
            this.wroteLastChunk = true;
        }
    }

    @Override
    public void write(int n2) {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.cache[this.cachePosition] = (byte)n2;
        ++this.cachePosition;
        if (this.cachePosition == this.cache.length) {
            this.flushCache();
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (n3 >= this.cache.length - this.cachePosition) {
            this.flushCacheWithAppend(byArray, n2, n3);
        } else {
            System.arraycopy(byArray, n2, this.cache, this.cachePosition, n3);
            this.cachePosition += n3;
        }
    }

    @Override
    public void flush() {
        this.flushCache();
        this.out.flush();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.finish();
            this.out.flush();
        }
    }
}

