/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.http.Consts;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

public abstract class AbstractSessionInputBuffer
implements BufferInfo,
SessionInputBuffer {
    private InputStream instream;
    private byte[] buffer;
    private ByteArrayBuffer linebuffer;
    private Charset charset;
    private boolean ascii;
    private int maxLineLen;
    private int minChunkLimit;
    private HttpTransportMetricsImpl metrics;
    private CodingErrorAction onMalformedCharAction;
    private CodingErrorAction onUnmappableCharAction;
    private int bufferpos;
    private int bufferlen;
    private CharsetDecoder decoder;
    private CharBuffer cbuf;

    protected void init(InputStream inputStream, int n2, HttpParams httpParams) {
        Args.notNull(inputStream, "Input stream");
        Args.notNegative(n2, "Buffer size");
        Args.notNull(httpParams, "HTTP parameters");
        this.instream = inputStream;
        this.buffer = new byte[n2];
        this.bufferpos = 0;
        this.bufferlen = 0;
        this.linebuffer = new ByteArrayBuffer(n2);
        String string = (String)httpParams.getParameter("http.protocol.element-charset");
        this.charset = string != null ? Charset.forName(string) : Consts.ASCII;
        this.ascii = this.charset.equals(Consts.ASCII);
        this.decoder = null;
        this.maxLineLen = httpParams.getIntParameter("http.connection.max-line-length", -1);
        this.minChunkLimit = httpParams.getIntParameter("http.connection.min-chunk-limit", 512);
        this.metrics = this.createTransportMetrics();
        CodingErrorAction codingErrorAction = (CodingErrorAction)httpParams.getParameter("http.malformed.input.action");
        this.onMalformedCharAction = codingErrorAction != null ? codingErrorAction : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction2 = (CodingErrorAction)httpParams.getParameter("http.unmappable.input.action");
        this.onUnmappableCharAction = codingErrorAction2 != null ? codingErrorAction2 : CodingErrorAction.REPORT;
    }

    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public int length() {
        return this.bufferlen - this.bufferpos;
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    protected int fillBuffer() {
        int n2;
        int n3;
        int n4;
        if (this.bufferpos > 0) {
            n4 = this.bufferlen - this.bufferpos;
            if (n4 > 0) {
                System.arraycopy(this.buffer, this.bufferpos, this.buffer, 0, n4);
            }
            this.bufferpos = 0;
            this.bufferlen = n4;
        }
        if ((n4 = this.instream.read(this.buffer, n3 = this.bufferlen, n2 = this.buffer.length - n3)) == -1) {
            return -1;
        }
        this.bufferlen = n3 + n4;
        this.metrics.incrementBytesTransferred(n4);
        return n4;
    }

    protected boolean hasBufferedData() {
        return this.bufferpos < this.bufferlen;
    }

    @Override
    public int read() {
        while (!this.hasBufferedData()) {
            int n2 = this.fillBuffer();
            if (n2 != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferpos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null) {
            return 0;
        }
        if (this.hasBufferedData()) {
            int n5 = Math.min(n3, this.bufferlen - this.bufferpos);
            System.arraycopy(this.buffer, this.bufferpos, byArray, n2, n5);
            this.bufferpos += n5;
            return n5;
        }
        if (n3 > this.minChunkLimit) {
            int n6 = this.instream.read(byArray, n2, n3);
            if (n6 > 0) {
                this.metrics.incrementBytesTransferred(n6);
            }
            return n6;
        }
        while (!this.hasBufferedData()) {
            n4 = this.fillBuffer();
            if (n4 != -1) continue;
            return -1;
        }
        n4 = Math.min(n3, this.bufferlen - this.bufferpos);
        System.arraycopy(this.buffer, this.bufferpos, byArray, n2, n4);
        this.bufferpos += n4;
        return n4;
    }

    @Override
    public int read(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    private int locateLF() {
        for (int i2 = this.bufferpos; i2 < this.bufferlen; ++i2) {
            if (this.buffer[i2] != 10) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int readLine(CharArrayBuffer charArrayBuffer) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            int n3;
            int n4 = this.locateLF();
            if (n4 != -1) {
                if (this.linebuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charArrayBuffer, n4);
                }
                bl = false;
                n3 = n4 + 1 - this.bufferpos;
                this.linebuffer.append(this.buffer, this.bufferpos, n3);
                this.bufferpos = n4 + 1;
            } else {
                if (this.hasBufferedData()) {
                    n3 = this.bufferlen - this.bufferpos;
                    this.linebuffer.append(this.buffer, this.bufferpos, n3);
                    this.bufferpos = this.bufferlen;
                }
                if ((n2 = this.fillBuffer()) == -1) {
                    bl = false;
                }
            }
            if (this.maxLineLen <= 0 || this.linebuffer.length() < this.maxLineLen) continue;
            throw new IOException("Maximum line length limit exceeded");
        }
        if (n2 == -1 && this.linebuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer(charArrayBuffer);
    }

    private int lineFromLineBuffer(CharArrayBuffer charArrayBuffer) {
        int n2 = this.linebuffer.length();
        if (n2 > 0) {
            if (this.linebuffer.byteAt(n2 - 1) == 10) {
                --n2;
            }
            if (n2 > 0 && this.linebuffer.byteAt(n2 - 1) == 13) {
                --n2;
            }
        }
        if (this.ascii) {
            charArrayBuffer.append(this.linebuffer, 0, n2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.linebuffer.buffer(), 0, n2);
            n2 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        this.linebuffer.clear();
        return n2;
    }

    private int lineFromReadBuffer(CharArrayBuffer charArrayBuffer, int n2) {
        int n3 = this.bufferpos;
        int n4 = n2;
        this.bufferpos = n4 + 1;
        if (n4 > n3 && this.buffer[n4 - 1] == 13) {
            --n4;
        }
        int n5 = n4 - n3;
        if (this.ascii) {
            charArrayBuffer.append(this.buffer, n3, n5);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer, n3, n5);
            n5 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        return n5;
    }

    private int appendDecoded(CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        if (!byteBuffer.hasRemaining()) {
            return 0;
        }
        if (this.decoder == null) {
            this.decoder = this.charset.newDecoder();
            this.decoder.onMalformedInput(this.onMalformedCharAction);
            this.decoder.onUnmappableCharacter(this.onUnmappableCharAction);
        }
        if (this.cbuf == null) {
            this.cbuf = CharBuffer.allocate(1024);
        }
        this.decoder.reset();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            coderResult = this.decoder.decode(byteBuffer, this.cbuf, true);
            n2 += this.handleDecodingResult(coderResult, charArrayBuffer, byteBuffer);
        }
        coderResult = this.decoder.flush(this.cbuf);
        this.cbuf.clear();
        return n2 += this.handleDecodingResult(coderResult, charArrayBuffer, byteBuffer);
    }

    private int handleDecodingResult(CoderResult coderResult, CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.cbuf.flip();
        int n2 = this.cbuf.remaining();
        while (this.cbuf.hasRemaining()) {
            charArrayBuffer.append(this.cbuf.get());
        }
        this.cbuf.compact();
        return n2;
    }

    @Override
    public String readLine() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        int n2 = this.readLine(charArrayBuffer);
        if (n2 != -1) {
            return charArrayBuffer.toString();
        }
        return null;
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

