/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache.memcached;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.client.cache.memcached.KeyHashingScheme;
import org.apache.http.impl.client.cache.memcached.MemcachedKeyHashingException;

public class SHA256KeyHashingScheme
implements KeyHashingScheme {
    private static final Log log = LogFactory.getLog(SHA256KeyHashingScheme.class);

    @Override
    public String hash(String string) {
        MessageDigest messageDigest = this.getDigest();
        messageDigest.update(string.getBytes());
        return Hex.encodeHexString(messageDigest.digest());
    }

    private MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error("can't find SHA-256 implementation for cache key hashing");
            throw new MemcachedKeyHashingException(noSuchAlgorithmException);
        }
    }
}

