/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.client.utils.DateUtils;

class WarningValue {
    private int offs;
    private int init_offs;
    private final String src;
    private int warnCode;
    private String warnAgent;
    private String warnText;
    private Date warnDate;
    private static final String TOPLABEL = "\\p{Alpha}([\\p{Alnum}-]*\\p{Alnum})?";
    private static final String DOMAINLABEL = "\\p{Alnum}([\\p{Alnum}-]*\\p{Alnum})?";
    private static final String HOSTNAME = "(\\p{Alnum}([\\p{Alnum}-]*\\p{Alnum})?\\.)*\\p{Alpha}([\\p{Alnum}-]*\\p{Alnum})?\\.?";
    private static final String IPV4ADDRESS = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    private static final String HOST = "((\\p{Alnum}([\\p{Alnum}-]*\\p{Alnum})?\\.)*\\p{Alpha}([\\p{Alnum}-]*\\p{Alnum})?\\.?)|(\\d+\\.\\d+\\.\\d+\\.\\d+)";
    private static final String PORT = "\\d*";
    private static final String HOSTPORT = "(((\\p{Alnum}([\\p{Alnum}-]*\\p{Alnum})?\\.)*\\p{Alpha}([\\p{Alnum}-]*\\p{Alnum})?\\.?)|(\\d+\\.\\d+\\.\\d+\\.\\d+))(\\:\\d*)?";
    private static final Pattern HOSTPORT_PATTERN = Pattern.compile("(((\\p{Alnum}([\\p{Alnum}-]*\\p{Alnum})?\\.)*\\p{Alpha}([\\p{Alnum}-]*\\p{Alnum})?\\.?)|(\\d+\\.\\d+\\.\\d+\\.\\d+))(\\:\\d*)?");
    private static final String MONTH = "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec";
    private static final String WEEKDAY = "Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday";
    private static final String WKDAY = "Mon|Tue|Wed|Thu|Fri|Sat|Sun";
    private static final String TIME = "\\d{2}:\\d{2}:\\d{2}";
    private static final String DATE3 = "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( |\\d)\\d";
    private static final String DATE2 = "\\d{2}-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-\\d{2}";
    private static final String DATE1 = "\\d{2} (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4}";
    private static final String ASCTIME_DATE = "(Mon|Tue|Wed|Thu|Fri|Sat|Sun) ((Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( |\\d)\\d) (\\d{2}:\\d{2}:\\d{2}) \\d{4}";
    private static final String RFC850_DATE = "(Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\\d{2}-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-\\d{2}) (\\d{2}:\\d{2}:\\d{2}) GMT";
    private static final String RFC1123_DATE = "(Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\\d{2} (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4}) (\\d{2}:\\d{2}:\\d{2}) GMT";
    private static final String HTTP_DATE = "((Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\\d{2} (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4}) (\\d{2}:\\d{2}:\\d{2}) GMT)|((Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\\d{2}-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-\\d{2}) (\\d{2}:\\d{2}:\\d{2}) GMT)|((Mon|Tue|Wed|Thu|Fri|Sat|Sun) ((Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( |\\d)\\d) (\\d{2}:\\d{2}:\\d{2}) \\d{4})";
    private static final String WARN_DATE = "\"(((Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\\d{2} (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4}) (\\d{2}:\\d{2}:\\d{2}) GMT)|((Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\\d{2}-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-\\d{2}) (\\d{2}:\\d{2}:\\d{2}) GMT)|((Mon|Tue|Wed|Thu|Fri|Sat|Sun) ((Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( |\\d)\\d) (\\d{2}:\\d{2}:\\d{2}) \\d{4}))\"";
    private static final Pattern WARN_DATE_PATTERN = Pattern.compile("\"(((Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\\d{2} (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4}) (\\d{2}:\\d{2}:\\d{2}) GMT)|((Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\\d{2}-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-\\d{2}) (\\d{2}:\\d{2}:\\d{2}) GMT)|((Mon|Tue|Wed|Thu|Fri|Sat|Sun) ((Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( |\\d)\\d) (\\d{2}:\\d{2}:\\d{2}) \\d{4}))\"");

    WarningValue(String string) {
        this(string, 0);
    }

    WarningValue(String string, int n2) {
        this.offs = this.init_offs = n2;
        this.src = string;
        this.consumeWarnValue();
    }

    public static WarningValue[] getWarningValues(Header header) {
        Object object;
        ArrayList<WarningValue[]> arrayList = new ArrayList<WarningValue[]>();
        String string = header.getValue();
        int n2 = 0;
        while (n2 < string.length()) {
            try {
                object = new WarningValue(string, n2);
                arrayList.add((WarningValue[])object);
                n2 = object.offs;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int n3 = string.indexOf(44, n2);
                if (n3 == -1) break;
                n2 = n3 + 1;
            }
        }
        object = new WarningValue[]{};
        return arrayList.toArray((T[])object);
    }

    protected void consumeLinearWhitespace() {
        while (this.offs < this.src.length()) {
            switch (this.src.charAt(this.offs)) {
                case '\r': {
                    if (this.offs + 2 >= this.src.length() || this.src.charAt(this.offs + 1) != '\n' || this.src.charAt(this.offs + 2) != ' ' && this.src.charAt(this.offs + 2) != '\t') {
                        return;
                    }
                    this.offs += 2;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                default: {
                    return;
                }
            }
            ++this.offs;
        }
    }

    private boolean isChar(char c2) {
        char c3 = c2;
        return c3 >= '\u0000' && c3 <= '\u007f';
    }

    private boolean isControl(char c2) {
        char c3 = c2;
        return c3 == '\u007f' || c3 >= '\u0000' && c3 <= '\u001f';
    }

    private boolean isSeparator(char c2) {
        return c2 == '(' || c2 == ')' || c2 == '<' || c2 == '>' || c2 == '@' || c2 == ',' || c2 == ';' || c2 == ':' || c2 == '\\' || c2 == '\"' || c2 == '/' || c2 == '[' || c2 == ']' || c2 == '?' || c2 == '=' || c2 == '{' || c2 == '}' || c2 == ' ' || c2 == '\t';
    }

    protected void consumeToken() {
        if (!this.isTokenChar(this.src.charAt(this.offs))) {
            this.parseError();
        }
        while (this.offs < this.src.length() && this.isTokenChar(this.src.charAt(this.offs))) {
            ++this.offs;
        }
    }

    private boolean isTokenChar(char c2) {
        return this.isChar(c2) && !this.isControl(c2) && !this.isSeparator(c2);
    }

    protected void consumeHostPort() {
        Matcher matcher = HOSTPORT_PATTERN.matcher(this.src.substring(this.offs));
        if (!matcher.find()) {
            this.parseError();
        }
        if (matcher.start() != 0) {
            this.parseError();
        }
        this.offs += matcher.end();
    }

    protected void consumeWarnAgent() {
        int n2 = this.offs;
        try {
            this.consumeHostPort();
            this.warnAgent = this.src.substring(n2, this.offs);
            this.consumeCharacter(' ');
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.offs = n2;
            this.consumeToken();
            this.warnAgent = this.src.substring(n2, this.offs);
            this.consumeCharacter(' ');
            return;
        }
    }

    protected void consumeQuotedString() {
        if (this.src.charAt(this.offs) != '\"') {
            this.parseError();
        }
        ++this.offs;
        boolean bl = false;
        while (this.offs < this.src.length() && !bl) {
            char c2 = this.src.charAt(this.offs);
            if (this.offs + 1 < this.src.length() && c2 == '\\' && this.isChar(this.src.charAt(this.offs + 1))) {
                this.offs += 2;
                continue;
            }
            if (c2 == '\"') {
                bl = true;
                ++this.offs;
                continue;
            }
            if (c2 != '\"' && !this.isControl(c2)) {
                ++this.offs;
                continue;
            }
            this.parseError();
        }
        if (!bl) {
            this.parseError();
        }
    }

    protected void consumeWarnText() {
        int n2 = this.offs;
        this.consumeQuotedString();
        this.warnText = this.src.substring(n2, this.offs);
    }

    protected void consumeWarnDate() {
        int n2 = this.offs;
        Matcher matcher = WARN_DATE_PATTERN.matcher(this.src.substring(this.offs));
        if (!matcher.lookingAt()) {
            this.parseError();
        }
        this.offs += matcher.end();
        this.warnDate = DateUtils.parseDate(this.src.substring(n2 + 1, this.offs - 1));
    }

    protected void consumeWarnValue() {
        this.consumeLinearWhitespace();
        this.consumeWarnCode();
        this.consumeWarnAgent();
        this.consumeWarnText();
        if (this.offs + 1 < this.src.length() && this.src.charAt(this.offs) == ' ' && this.src.charAt(this.offs + 1) == '\"') {
            this.consumeCharacter(' ');
            this.consumeWarnDate();
        }
        this.consumeLinearWhitespace();
        if (this.offs != this.src.length()) {
            this.consumeCharacter(',');
        }
    }

    protected void consumeCharacter(char c2) {
        if (this.offs + 1 > this.src.length() || c2 != this.src.charAt(this.offs)) {
            this.parseError();
        }
        ++this.offs;
    }

    protected void consumeWarnCode() {
        if (!(this.offs + 4 <= this.src.length() && Character.isDigit(this.src.charAt(this.offs)) && Character.isDigit(this.src.charAt(this.offs + 1)) && Character.isDigit(this.src.charAt(this.offs + 2)) && this.src.charAt(this.offs + 3) == ' ')) {
            this.parseError();
        }
        this.warnCode = Integer.parseInt(this.src.substring(this.offs, this.offs + 3));
        this.offs += 4;
    }

    private void parseError() {
        String string = this.src.substring(this.init_offs);
        throw new IllegalArgumentException("Bad warn code \"" + string + "\"");
    }

    public int getWarnCode() {
        return this.warnCode;
    }

    public String getWarnAgent() {
        return this.warnAgent;
    }

    public String getWarnText() {
        return this.warnText;
    }

    public Date getWarnDate() {
        return this.warnDate;
    }

    public String toString() {
        if (this.warnDate != null) {
            return String.format("%d %s %s \"%s\"", this.warnCode, this.warnAgent, this.warnText, DateUtils.formatDate(this.warnDate));
        }
        return String.format("%d %s %s", this.warnCode, this.warnAgent, this.warnText);
    }
}

