/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.cache.AsynchronousValidationRequest;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.SchedulingStrategy;
import org.apache.http.util.Args;

public class ImmediateSchedulingStrategy
implements SchedulingStrategy {
    private final ExecutorService executor;

    public ImmediateSchedulingStrategy(CacheConfig cacheConfig) {
        this(new ThreadPoolExecutor(cacheConfig.getAsynchronousWorkersCore(), cacheConfig.getAsynchronousWorkersMax(), cacheConfig.getAsynchronousWorkerIdleLifetimeSecs(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(cacheConfig.getRevalidationQueueSize())));
    }

    ImmediateSchedulingStrategy(ExecutorService executorService) {
        this.executor = executorService;
    }

    @Override
    public void schedule(AsynchronousValidationRequest asynchronousValidationRequest) {
        Args.notNull(asynchronousValidationRequest, "AsynchronousValidationRequest");
        this.executor.execute(asynchronousValidationRequest);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    void awaitTermination(long l2, TimeUnit timeUnit) {
        this.executor.awaitTermination(l2, timeUnit);
    }
}

