/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.BasicHttpCache;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheKeyGenerator;
import org.apache.http.impl.client.cache.CacheValidityPolicy;
import org.apache.http.impl.client.cache.CacheableRequestPolicy;
import org.apache.http.impl.client.cache.CachedHttpResponseGenerator;
import org.apache.http.impl.client.cache.CachedResponseSuitabilityChecker;
import org.apache.http.impl.client.cache.ConditionalRequestBuilder;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.apache.http.impl.client.cache.HttpCache;
import org.apache.http.impl.client.cache.IOUtils;
import org.apache.http.impl.client.cache.OptionsHttp11Response;
import org.apache.http.impl.client.cache.RequestProtocolCompliance;
import org.apache.http.impl.client.cache.RequestProtocolError;
import org.apache.http.impl.client.cache.ResponseCachingPolicy;
import org.apache.http.impl.client.cache.ResponseProtocolCompliance;
import org.apache.http.impl.client.cache.Variant;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.VersionInfo;

public class CachingHttpClient
implements HttpClient {
    public static final String CACHE_RESPONSE_STATUS = "http.cache.response.status";
    private static final boolean SUPPORTS_RANGE_AND_CONTENT_RANGE_HEADERS = false;
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final AtomicLong cacheUpdates = new AtomicLong();
    private final Map<ProtocolVersion, String> viaHeaders = new HashMap<ProtocolVersion, String>(4);
    private final HttpClient backend;
    private final HttpCache responseCache;
    private final CacheValidityPolicy validityPolicy;
    private final ResponseCachingPolicy responseCachingPolicy;
    private final CachedHttpResponseGenerator responseGenerator;
    private final CacheableRequestPolicy cacheableRequestPolicy;
    private final CachedResponseSuitabilityChecker suitabilityChecker;
    private final ConditionalRequestBuilder conditionalRequestBuilder;
    private final long maxObjectSizeBytes;
    private final boolean sharedCache;
    private final ResponseProtocolCompliance responseCompliance;
    private final RequestProtocolCompliance requestCompliance;
    private final AsynchronousValidator asynchRevalidator;
    private final Log log = LogFactory.getLog(this.getClass());

    CachingHttpClient(HttpClient httpClient, HttpCache httpCache, CacheConfig cacheConfig) {
        Args.notNull(httpClient, "HttpClient");
        Args.notNull(httpCache, "HttpCache");
        Args.notNull(cacheConfig, "CacheConfig");
        this.maxObjectSizeBytes = cacheConfig.getMaxObjectSize();
        this.sharedCache = cacheConfig.isSharedCache();
        this.backend = httpClient;
        this.responseCache = httpCache;
        this.validityPolicy = new CacheValidityPolicy();
        this.responseCachingPolicy = new ResponseCachingPolicy(this.maxObjectSizeBytes, this.sharedCache, cacheConfig.isNeverCacheHTTP10ResponsesWithQuery(), cacheConfig.is303CachingEnabled());
        this.responseGenerator = new CachedHttpResponseGenerator(this.validityPolicy);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker(this.validityPolicy, cacheConfig);
        this.conditionalRequestBuilder = new ConditionalRequestBuilder();
        this.responseCompliance = new ResponseProtocolCompliance();
        this.requestCompliance = new RequestProtocolCompliance(cacheConfig.isWeakETagOnPutDeleteAllowed());
        this.asynchRevalidator = this.makeAsynchronousValidator(cacheConfig);
    }

    public CachingHttpClient() {
        this((HttpClient)new DefaultHttpClient(), new BasicHttpCache(), new CacheConfig());
    }

    public CachingHttpClient(CacheConfig cacheConfig) {
        this((HttpClient)new DefaultHttpClient(), new BasicHttpCache(cacheConfig), cacheConfig);
    }

    public CachingHttpClient(HttpClient httpClient) {
        this(httpClient, new BasicHttpCache(), new CacheConfig());
    }

    public CachingHttpClient(HttpClient httpClient, CacheConfig cacheConfig) {
        this(httpClient, new BasicHttpCache(cacheConfig), cacheConfig);
    }

    public CachingHttpClient(HttpClient httpClient, ResourceFactory resourceFactory, HttpCacheStorage httpCacheStorage, CacheConfig cacheConfig) {
        this(httpClient, new BasicHttpCache(resourceFactory, httpCacheStorage, cacheConfig), cacheConfig);
    }

    public CachingHttpClient(HttpClient httpClient, HttpCacheStorage httpCacheStorage, CacheConfig cacheConfig) {
        this(httpClient, new BasicHttpCache(new HeapResourceFactory(), httpCacheStorage, cacheConfig), cacheConfig);
    }

    CachingHttpClient(HttpClient httpClient, CacheValidityPolicy cacheValidityPolicy, ResponseCachingPolicy responseCachingPolicy, HttpCache httpCache, CachedHttpResponseGenerator cachedHttpResponseGenerator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker cachedResponseSuitabilityChecker, ConditionalRequestBuilder conditionalRequestBuilder, ResponseProtocolCompliance responseProtocolCompliance, RequestProtocolCompliance requestProtocolCompliance) {
        CacheConfig cacheConfig = new CacheConfig();
        this.maxObjectSizeBytes = cacheConfig.getMaxObjectSize();
        this.sharedCache = cacheConfig.isSharedCache();
        this.backend = httpClient;
        this.validityPolicy = cacheValidityPolicy;
        this.responseCachingPolicy = responseCachingPolicy;
        this.responseCache = httpCache;
        this.responseGenerator = cachedHttpResponseGenerator;
        this.cacheableRequestPolicy = cacheableRequestPolicy;
        this.suitabilityChecker = cachedResponseSuitabilityChecker;
        this.conditionalRequestBuilder = conditionalRequestBuilder;
        this.responseCompliance = responseProtocolCompliance;
        this.requestCompliance = requestProtocolCompliance;
        this.asynchRevalidator = this.makeAsynchronousValidator(cacheConfig);
    }

    private AsynchronousValidator makeAsynchronousValidator(CacheConfig cacheConfig) {
        if (cacheConfig.getAsynchronousWorkersMax() > 0) {
            return new AsynchronousValidator(this, cacheConfig);
        }
        return null;
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    public long getCacheUpdates() {
        return this.cacheUpdates.get();
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) {
        HttpContext httpContext = null;
        return this.execute(httpHost, httpRequest, httpContext);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) {
        return this.execute(httpHost, httpRequest, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        HttpResponse httpResponse = this.execute(httpHost, httpRequest, httpContext);
        return this.handleAndConsume(responseHandler, httpResponse);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest) {
        HttpContext httpContext = null;
        return this.execute(httpUriRequest, httpContext);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) {
        URI uRI = httpUriRequest.getURI();
        HttpHost httpHost = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
        return this.execute(httpHost, (HttpRequest)httpUriRequest, httpContext);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) {
        return this.execute(httpUriRequest, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        HttpResponse httpResponse = this.execute(httpUriRequest, httpContext);
        return this.handleAndConsume(responseHandler, httpResponse);
    }

    private <T> T handleAndConsume(ResponseHandler<? extends T> responseHandler, HttpResponse httpResponse) {
        T t2;
        try {
            t2 = responseHandler.handleResponse(httpResponse);
        }
        catch (Exception exception) {
            HttpEntity httpEntity = httpResponse.getEntity();
            try {
                IOUtils.consume(httpEntity);
            }
            catch (Exception exception2) {
                this.log.warn("Error consuming content after an exception.", exception2);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        IOUtils.consume(httpEntity);
        return t2;
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    @Override
    public HttpParams getParams() {
        return this.backend.getParams();
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        HttpRequestWrapper httpRequestWrapper = httpRequest instanceof HttpRequestWrapper ? (HttpRequestWrapper)httpRequest : HttpRequestWrapper.wrap(httpRequest);
        String string = this.generateViaHeader(httpRequest);
        this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_MISS);
        if (this.clientRequestsOurOptions(httpRequestWrapper)) {
            this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return new OptionsHttp11Response();
        }
        HttpResponse httpResponse = this.getFatallyNoncompliantResponse(httpRequestWrapper, httpContext);
        if (httpResponse != null) {
            return httpResponse;
        }
        this.requestCompliance.makeRequestCompliant(httpRequestWrapper);
        httpRequestWrapper.addHeader("Via", string);
        this.flushEntriesInvalidatedByRequest(httpHost, httpRequestWrapper);
        if (!this.cacheableRequestPolicy.isServableFromCache(httpRequestWrapper)) {
            this.log.debug("Request is not servable from cache");
            return this.callBackend(httpHost, httpRequestWrapper, httpContext);
        }
        HttpCacheEntry httpCacheEntry = this.satisfyFromCache(httpHost, httpRequestWrapper);
        if (httpCacheEntry == null) {
            this.log.debug("Cache miss");
            return this.handleCacheMiss(httpHost, httpRequestWrapper, httpContext);
        }
        return this.handleCacheHit(httpHost, httpRequestWrapper, httpContext, httpCacheEntry);
    }

    private HttpResponse handleCacheHit(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry) {
        this.recordCacheHit(httpHost, httpRequestWrapper);
        HttpResponse httpResponse = null;
        Date date = this.getCurrentDate();
        if (this.suitabilityChecker.canCachedResponseBeUsed(httpHost, httpRequestWrapper, httpCacheEntry, date)) {
            this.log.debug("Cache hit");
            httpResponse = this.generateCachedResponse(httpRequestWrapper, httpContext, httpCacheEntry, date);
        } else if (!this.mayCallBackend(httpRequestWrapper)) {
            this.log.debug("Cache entry not suitable but only-if-cached requested");
            httpResponse = this.generateGatewayTimeout(httpContext);
        } else {
            this.log.debug("Revalidating cache entry");
            return this.revalidateCacheEntry(httpHost, httpRequestWrapper, httpContext, httpCacheEntry, date);
        }
        if (httpContext != null) {
            httpContext.setAttribute("http.target_host", httpHost);
            httpContext.setAttribute("http.request", httpRequestWrapper);
            httpContext.setAttribute("http.response", httpResponse);
            httpContext.setAttribute("http.request_sent", Boolean.TRUE);
        }
        return httpResponse;
    }

    private HttpResponse revalidateCacheEntry(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry, Date date) {
        try {
            if (this.asynchRevalidator != null && !this.staleResponseNotAllowed(httpRequestWrapper, httpCacheEntry, date) && this.validityPolicy.mayReturnStaleWhileRevalidating(httpCacheEntry, date)) {
                this.log.trace("Serving stale with asynchronous revalidation");
                HttpResponse httpResponse = this.generateCachedResponse(httpRequestWrapper, httpContext, httpCacheEntry, date);
                this.asynchRevalidator.revalidateCacheEntry(httpHost, httpRequestWrapper, httpContext, httpCacheEntry);
                return httpResponse;
            }
            return this.revalidateCacheEntry(httpHost, httpRequestWrapper, httpContext, httpCacheEntry);
        }
        catch (IOException iOException) {
            return this.handleRevalidationFailure(httpRequestWrapper, httpContext, httpCacheEntry, date);
        }
        catch (ProtocolException protocolException) {
            throw new ClientProtocolException(protocolException);
        }
    }

    private HttpResponse handleCacheMiss(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext) {
        this.recordCacheMiss(httpHost, httpRequestWrapper);
        if (!this.mayCallBackend(httpRequestWrapper)) {
            return new BasicHttpResponse(HttpVersion.HTTP_1_1, 504, "Gateway Timeout");
        }
        Map<String, Variant> map = this.getExistingCacheVariants(httpHost, httpRequestWrapper);
        if (map != null && map.size() > 0) {
            return this.negotiateResponseFromVariants(httpHost, httpRequestWrapper, httpContext, map);
        }
        return this.callBackend(httpHost, httpRequestWrapper, httpContext);
    }

    private HttpCacheEntry satisfyFromCache(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        HttpCacheEntry httpCacheEntry = null;
        try {
            httpCacheEntry = this.responseCache.getCacheEntry(httpHost, httpRequestWrapper);
        }
        catch (IOException iOException) {
            this.log.warn("Unable to retrieve entries from cache", iOException);
        }
        return httpCacheEntry;
    }

    private HttpResponse getFatallyNoncompliantResponse(HttpRequestWrapper httpRequestWrapper, HttpContext httpContext) {
        HttpResponse httpResponse = null;
        List<RequestProtocolError> list = this.requestCompliance.requestIsFatallyNonCompliant(httpRequestWrapper);
        for (RequestProtocolError requestProtocolError : list) {
            this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            httpResponse = this.requestCompliance.getErrorForRequest(requestProtocolError);
        }
        return httpResponse;
    }

    private Map<String, Variant> getExistingCacheVariants(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        Map<String, Variant> map = null;
        try {
            map = this.responseCache.getVariantCacheEntriesWithEtags(httpHost, httpRequestWrapper);
        }
        catch (IOException iOException) {
            this.log.warn("Unable to retrieve variant entries from cache", iOException);
        }
        return map;
    }

    private void recordCacheMiss(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        this.cacheMisses.getAndIncrement();
        if (this.log.isTraceEnabled()) {
            RequestLine requestLine = httpRequestWrapper.getRequestLine();
            this.log.trace("Cache miss [host: " + httpHost + "; uri: " + requestLine.getUri() + "]");
        }
    }

    private void recordCacheHit(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        this.cacheHits.getAndIncrement();
        if (this.log.isTraceEnabled()) {
            RequestLine requestLine = httpRequestWrapper.getRequestLine();
            this.log.trace("Cache hit [host: " + httpHost + "; uri: " + requestLine.getUri() + "]");
        }
    }

    private void recordCacheUpdate(HttpContext httpContext) {
        this.cacheUpdates.getAndIncrement();
        this.setResponseStatus(httpContext, CacheResponseStatus.VALIDATED);
    }

    private void flushEntriesInvalidatedByRequest(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        try {
            this.responseCache.flushInvalidatedCacheEntriesFor(httpHost, httpRequestWrapper);
        }
        catch (IOException iOException) {
            this.log.warn("Unable to flush invalidated entries from cache", iOException);
        }
    }

    private HttpResponse generateCachedResponse(HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry, Date date) {
        CloseableHttpResponse closeableHttpResponse = httpRequestWrapper.containsHeader("If-None-Match") || httpRequestWrapper.containsHeader("If-Modified-Since") ? this.responseGenerator.generateNotModifiedResponse(httpCacheEntry) : this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry);
        this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_HIT);
        if (this.validityPolicy.getStalenessSecs(httpCacheEntry, date) > 0L) {
            closeableHttpResponse.addHeader("Warning", "110 localhost \"Response is stale\"");
        }
        return closeableHttpResponse;
    }

    private HttpResponse handleRevalidationFailure(HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry, Date date) {
        if (this.staleResponseNotAllowed(httpRequestWrapper, httpCacheEntry, date)) {
            return this.generateGatewayTimeout(httpContext);
        }
        return this.unvalidatedCacheHit(httpRequestWrapper, httpContext, httpCacheEntry);
    }

    private HttpResponse generateGatewayTimeout(HttpContext httpContext) {
        this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_MODULE_RESPONSE);
        return new BasicHttpResponse(HttpVersion.HTTP_1_1, 504, "Gateway Timeout");
    }

    private HttpResponse unvalidatedCacheHit(HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry) {
        CloseableHttpResponse closeableHttpResponse = this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry);
        this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_HIT);
        closeableHttpResponse.addHeader("Warning", "111 localhost \"Revalidation failed\"");
        return closeableHttpResponse;
    }

    private boolean staleResponseNotAllowed(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry, Date date) {
        return this.validityPolicy.mustRevalidate(httpCacheEntry) || this.isSharedCache() && this.validityPolicy.proxyRevalidate(httpCacheEntry) || this.explicitFreshnessRequest(httpRequestWrapper, httpCacheEntry, date);
    }

    private boolean mayCallBackend(HttpRequestWrapper httpRequestWrapper) {
        for (Header header : httpRequestWrapper.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"only-if-cached".equals(headerElement.getName())) continue;
                this.log.trace("Request marked only-if-cached");
                return false;
            }
        }
        return true;
    }

    private boolean explicitFreshnessRequest(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry, Date date) {
        for (Header header : httpRequestWrapper.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if ("max-stale".equals(headerElement.getName())) {
                    try {
                        int n2 = Integer.parseInt(headerElement.getValue());
                        long l2 = this.validityPolicy.getCurrentAgeSecs(httpCacheEntry, date);
                        long l3 = this.validityPolicy.getFreshnessLifetimeSecs(httpCacheEntry);
                        if (l2 - l3 <= (long)n2) continue;
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return true;
                    }
                }
                if (!"min-fresh".equals(headerElement.getName()) && !"max-age".equals(headerElement.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private String generateViaHeader(HttpMessage httpMessage) {
        ProtocolVersion protocolVersion = httpMessage.getProtocolVersion();
        String string = this.viaHeaders.get(protocolVersion);
        if (string != null) {
            return string;
        }
        VersionInfo versionInfo = VersionInfo.loadVersionInfo("org.apache.http.client", this.getClass().getClassLoader());
        String string2 = versionInfo != null ? versionInfo.getRelease() : "UNAVAILABLE";
        String string3 = "http".equalsIgnoreCase(protocolVersion.getProtocol()) ? String.format("%d.%d localhost (Apache-HttpClient/%s (cache))", protocolVersion.getMajor(), protocolVersion.getMinor(), string2) : String.format("%s/%d.%d localhost (Apache-HttpClient/%s (cache))", protocolVersion.getProtocol(), protocolVersion.getMajor(), protocolVersion.getMinor(), string2);
        this.viaHeaders.put(protocolVersion, string3);
        return string3;
    }

    private void setResponseStatus(HttpContext httpContext, CacheResponseStatus cacheResponseStatus) {
        if (httpContext != null) {
            httpContext.setAttribute(CACHE_RESPONSE_STATUS, (Object)cacheResponseStatus);
        }
    }

    public boolean supportsRangeAndContentRangeHeaders() {
        return false;
    }

    public boolean isSharedCache() {
        return this.sharedCache;
    }

    Date getCurrentDate() {
        return new Date();
    }

    boolean clientRequestsOurOptions(HttpRequest httpRequest) {
        RequestLine requestLine = httpRequest.getRequestLine();
        if (!"OPTIONS".equals(requestLine.getMethod())) {
            return false;
        }
        if (!"*".equals(requestLine.getUri())) {
            return false;
        }
        return "0".equals(httpRequest.getFirstHeader("Max-Forwards").getValue());
    }

    HttpResponse callBackend(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext) {
        Date date = this.getCurrentDate();
        this.log.trace("Calling the backend");
        HttpResponse httpResponse = this.backend.execute(httpHost, (HttpRequest)httpRequestWrapper, httpContext);
        httpResponse.addHeader("Via", this.generateViaHeader(httpResponse));
        return this.handleBackendResponse(httpHost, httpRequestWrapper, date, this.getCurrentDate(), httpResponse);
    }

    private boolean revalidationResponseIsTooOld(HttpResponse httpResponse, HttpCacheEntry httpCacheEntry) {
        Header header = httpCacheEntry.getFirstHeader("Date");
        Header header2 = httpResponse.getFirstHeader("Date");
        if (header != null && header2 != null) {
            try {
                Date date = DateUtils.parseDate(header.getValue());
                Date date2 = DateUtils.parseDate(header2.getValue());
                if (date2.before(date)) {
                    return true;
                }
            }
            catch (DateParseException dateParseException) {
                // empty catch block
            }
        }
        return false;
    }

    HttpResponse negotiateResponseFromVariants(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, Map<String, Variant> map) {
        HttpRequestWrapper httpRequestWrapper2 = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(httpRequestWrapper, map);
        Date date = this.getCurrentDate();
        HttpResponse httpResponse = this.backend.execute(httpHost, (HttpRequest)httpRequestWrapper2, httpContext);
        Date date2 = this.getCurrentDate();
        httpResponse.addHeader("Via", this.generateViaHeader(httpResponse));
        if (httpResponse.getStatusLine().getStatusCode() != 304) {
            return this.handleBackendResponse(httpHost, httpRequestWrapper, date, date2, httpResponse);
        }
        Header header = httpResponse.getFirstHeader("ETag");
        if (header == null) {
            this.log.warn("304 response did not contain ETag");
            return this.callBackend(httpHost, httpRequestWrapper, httpContext);
        }
        String string = header.getValue();
        Variant variant = map.get(string);
        if (variant == null) {
            this.log.debug("304 response did not contain ETag matching one sent in If-None-Match");
            return this.callBackend(httpHost, httpRequestWrapper, httpContext);
        }
        HttpCacheEntry httpCacheEntry = variant.getEntry();
        if (this.revalidationResponseIsTooOld(httpResponse, httpCacheEntry)) {
            IOUtils.consume(httpResponse.getEntity());
            return this.retryRequestUnconditionally(httpHost, httpRequestWrapper, httpContext, httpCacheEntry);
        }
        this.recordCacheUpdate(httpContext);
        HttpCacheEntry httpCacheEntry2 = this.getUpdatedVariantEntry(httpHost, httpRequestWrapper2, date, date2, httpResponse, variant, httpCacheEntry);
        CloseableHttpResponse closeableHttpResponse = this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry2);
        this.tryToUpdateVariantMap(httpHost, httpRequestWrapper, variant);
        if (this.shouldSendNotModifiedResponse(httpRequestWrapper, httpCacheEntry2)) {
            return this.responseGenerator.generateNotModifiedResponse(httpCacheEntry2);
        }
        return closeableHttpResponse;
    }

    private HttpResponse retryRequestUnconditionally(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry) {
        HttpRequestWrapper httpRequestWrapper2 = this.conditionalRequestBuilder.buildUnconditionalRequest(httpRequestWrapper, httpCacheEntry);
        return this.callBackend(httpHost, httpRequestWrapper2, httpContext);
    }

    private HttpCacheEntry getUpdatedVariantEntry(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, Date date, Date date2, HttpResponse httpResponse, Variant variant, HttpCacheEntry httpCacheEntry) {
        HttpCacheEntry httpCacheEntry2 = httpCacheEntry;
        try {
            httpCacheEntry2 = this.responseCache.updateVariantCacheEntry(httpHost, httpRequestWrapper, httpCacheEntry, httpResponse, date, date2, variant.getCacheKey());
        }
        catch (IOException iOException) {
            this.log.warn("Could not update cache entry", iOException);
        }
        return httpCacheEntry2;
    }

    private void tryToUpdateVariantMap(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, Variant variant) {
        try {
            this.responseCache.reuseVariantEntryFor(httpHost, httpRequestWrapper, variant);
        }
        catch (IOException iOException) {
            this.log.warn("Could not update cache entry to reuse variant", iOException);
        }
    }

    private boolean shouldSendNotModifiedResponse(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry) {
        return this.suitabilityChecker.isConditional(httpRequestWrapper) && this.suitabilityChecker.allConditionalsMatch(httpRequestWrapper, httpCacheEntry, new Date());
    }

    HttpResponse revalidateCacheEntry(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry) {
        HttpRequestWrapper httpRequestWrapper2 = this.conditionalRequestBuilder.buildConditionalRequest(httpRequestWrapper, httpCacheEntry);
        Date date = this.getCurrentDate();
        HttpResponse httpResponse = this.backend.execute(httpHost, (HttpRequest)httpRequestWrapper2, httpContext);
        Date date2 = this.getCurrentDate();
        if (this.revalidationResponseIsTooOld(httpResponse, httpCacheEntry)) {
            IOUtils.consume(httpResponse.getEntity());
            HttpRequestWrapper httpRequestWrapper3 = this.conditionalRequestBuilder.buildUnconditionalRequest(httpRequestWrapper, httpCacheEntry);
            date = this.getCurrentDate();
            httpResponse = this.backend.execute(httpHost, (HttpRequest)httpRequestWrapper3, httpContext);
            date2 = this.getCurrentDate();
        }
        httpResponse.addHeader("Via", this.generateViaHeader(httpResponse));
        int n2 = httpResponse.getStatusLine().getStatusCode();
        if (n2 == 304 || n2 == 200) {
            this.recordCacheUpdate(httpContext);
        }
        if (n2 == 304) {
            HttpCacheEntry httpCacheEntry2 = this.responseCache.updateCacheEntry(httpHost, httpRequestWrapper, httpCacheEntry, httpResponse, date, date2);
            if (this.suitabilityChecker.isConditional(httpRequestWrapper) && this.suitabilityChecker.allConditionalsMatch(httpRequestWrapper, httpCacheEntry2, new Date())) {
                return this.responseGenerator.generateNotModifiedResponse(httpCacheEntry2);
            }
            return this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry2);
        }
        if (this.staleIfErrorAppliesTo(n2) && !this.staleResponseNotAllowed(httpRequestWrapper, httpCacheEntry, this.getCurrentDate()) && this.validityPolicy.mayReturnStaleIfError(httpRequestWrapper, httpCacheEntry, date2)) {
            CloseableHttpResponse closeableHttpResponse = this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry);
            closeableHttpResponse.addHeader("Warning", "110 localhost \"Response is stale\"");
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                IOUtils.consume(httpEntity);
            }
            return closeableHttpResponse;
        }
        return this.handleBackendResponse(httpHost, httpRequestWrapper2, date, date2, httpResponse);
    }

    private boolean staleIfErrorAppliesTo(int n2) {
        return n2 == 500 || n2 == 502 || n2 == 503 || n2 == 504;
    }

    HttpResponse handleBackendResponse(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, Date date, Date date2, HttpResponse httpResponse) {
        this.log.trace("Handling Backend response");
        this.responseCompliance.ensureProtocolCompliance(httpRequestWrapper, httpResponse);
        boolean bl = this.responseCachingPolicy.isResponseCacheable(httpRequestWrapper, httpResponse);
        this.responseCache.flushInvalidatedCacheEntriesFor(httpHost, httpRequestWrapper, httpResponse);
        if (bl && !this.alreadyHaveNewerCacheEntry(httpHost, httpRequestWrapper, httpResponse)) {
            try {
                this.storeRequestIfModifiedSinceFor304Response(httpRequestWrapper, httpResponse);
                return this.responseCache.cacheAndReturnResponse(httpHost, (HttpRequest)httpRequestWrapper, httpResponse, date, date2);
            }
            catch (IOException iOException) {
                this.log.warn("Unable to store entries in cache", iOException);
            }
        }
        if (!bl) {
            try {
                this.responseCache.flushCacheEntriesFor(httpHost, httpRequestWrapper);
            }
            catch (IOException iOException) {
                this.log.warn("Unable to flush invalid cache entries", iOException);
            }
        }
        return httpResponse;
    }

    private void storeRequestIfModifiedSinceFor304Response(HttpRequest httpRequest, HttpResponse httpResponse) {
        Header header;
        if (httpResponse.getStatusLine().getStatusCode() == 304 && (header = httpRequest.getFirstHeader("If-Modified-Since")) != null) {
            httpResponse.addHeader("Last-Modified", header.getValue());
        }
    }

    private boolean alreadyHaveNewerCacheEntry(HttpHost httpHost, HttpRequest httpRequest, HttpResponse httpResponse) {
        HttpCacheEntry httpCacheEntry = null;
        try {
            httpCacheEntry = this.responseCache.getCacheEntry(httpHost, httpRequest);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (httpCacheEntry == null) {
            return false;
        }
        Header header = httpCacheEntry.getFirstHeader("Date");
        if (header == null) {
            return false;
        }
        Header header2 = httpResponse.getFirstHeader("Date");
        if (header2 == null) {
            return false;
        }
        try {
            Date date = DateUtils.parseDate(header.getValue());
            Date date2 = DateUtils.parseDate(header2.getValue());
            return date2.before(date);
        }
        catch (DateParseException dateParseException) {
            return false;
        }
    }

    static class AsynchronousValidationRequest
    implements Runnable {
        private final AsynchronousValidator parent;
        private final CachingHttpClient cachingClient;
        private final HttpHost target;
        private final HttpRequestWrapper request;
        private final HttpContext context;
        private final HttpCacheEntry cacheEntry;
        private final String identifier;
        private final Log log = LogFactory.getLog(this.getClass());

        AsynchronousValidationRequest(AsynchronousValidator asynchronousValidator, CachingHttpClient cachingHttpClient, HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry, String string) {
            this.parent = asynchronousValidator;
            this.cachingClient = cachingHttpClient;
            this.target = httpHost;
            this.request = httpRequestWrapper;
            this.context = httpContext;
            this.cacheEntry = httpCacheEntry;
            this.identifier = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.cachingClient.revalidateCacheEntry(this.target, this.request, this.context, this.cacheEntry);
            }
            catch (IOException iOException) {
                this.log.debug("Asynchronous revalidation failed due to exception: " + iOException);
            }
            catch (ProtocolException protocolException) {
                this.log.error("ProtocolException thrown during asynchronous revalidation: " + protocolException);
            }
            finally {
                this.parent.markComplete(this.identifier);
            }
        }

        String getIdentifier() {
            return this.identifier;
        }
    }

    static class AsynchronousValidator {
        private final CachingHttpClient cachingClient;
        private final ExecutorService executor;
        private final Set<String> queued;
        private final CacheKeyGenerator cacheKeyGenerator;
        private final Log log = LogFactory.getLog(this.getClass());

        public AsynchronousValidator(CachingHttpClient cachingHttpClient, CacheConfig cacheConfig) {
            this(cachingHttpClient, new ThreadPoolExecutor(cacheConfig.getAsynchronousWorkersCore(), cacheConfig.getAsynchronousWorkersMax(), cacheConfig.getAsynchronousWorkerIdleLifetimeSecs(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(cacheConfig.getRevalidationQueueSize())));
        }

        AsynchronousValidator(CachingHttpClient cachingHttpClient, ExecutorService executorService) {
            this.cachingClient = cachingHttpClient;
            this.executor = executorService;
            this.queued = new HashSet<String>();
            this.cacheKeyGenerator = new CacheKeyGenerator();
        }

        public synchronized void revalidateCacheEntry(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry) {
            String string = this.cacheKeyGenerator.getVariantURI(httpHost, httpRequestWrapper, httpCacheEntry);
            if (!this.queued.contains(string)) {
                AsynchronousValidationRequest asynchronousValidationRequest = new AsynchronousValidationRequest(this, this.cachingClient, httpHost, httpRequestWrapper, httpContext, httpCacheEntry, string);
                try {
                    this.executor.execute(asynchronousValidationRequest);
                    this.queued.add(string);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.log.debug("Revalidation for [" + string + "] not scheduled: " + rejectedExecutionException);
                }
            }
        }

        synchronized void markComplete(String string) {
            this.queued.remove(string);
        }

        Set<String> getScheduledIdentifiers() {
            return Collections.unmodifiableSet(this.queued);
        }

        ExecutorService getExecutor() {
            return this.executor;
        }
    }
}

