/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.cache.AsynchronousValidator;
import org.apache.http.impl.client.cache.BasicHttpCache;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheValidityPolicy;
import org.apache.http.impl.client.cache.CacheableRequestPolicy;
import org.apache.http.impl.client.cache.CachedHttpResponseGenerator;
import org.apache.http.impl.client.cache.CachedResponseSuitabilityChecker;
import org.apache.http.impl.client.cache.ConditionalRequestBuilder;
import org.apache.http.impl.client.cache.HttpCache;
import org.apache.http.impl.client.cache.IOUtils;
import org.apache.http.impl.client.cache.OptionsHttp11Response;
import org.apache.http.impl.client.cache.Proxies;
import org.apache.http.impl.client.cache.RequestProtocolCompliance;
import org.apache.http.impl.client.cache.RequestProtocolError;
import org.apache.http.impl.client.cache.ResponseCachingPolicy;
import org.apache.http.impl.client.cache.ResponseProtocolCompliance;
import org.apache.http.impl.client.cache.Variant;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.VersionInfo;

public class CachingExec
implements ClientExecChain {
    private static final boolean SUPPORTS_RANGE_AND_CONTENT_RANGE_HEADERS = false;
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final AtomicLong cacheUpdates = new AtomicLong();
    private final Map<ProtocolVersion, String> viaHeaders = new HashMap<ProtocolVersion, String>(4);
    private final CacheConfig cacheConfig;
    private final ClientExecChain backend;
    private final HttpCache responseCache;
    private final CacheValidityPolicy validityPolicy;
    private final CachedHttpResponseGenerator responseGenerator;
    private final CacheableRequestPolicy cacheableRequestPolicy;
    private final CachedResponseSuitabilityChecker suitabilityChecker;
    private final ConditionalRequestBuilder conditionalRequestBuilder;
    private final ResponseProtocolCompliance responseCompliance;
    private final RequestProtocolCompliance requestCompliance;
    private final ResponseCachingPolicy responseCachingPolicy;
    private final AsynchronousValidator asynchRevalidator;
    private final Log log = LogFactory.getLog(this.getClass());

    public CachingExec(ClientExecChain clientExecChain, HttpCache httpCache, CacheConfig cacheConfig) {
        this(clientExecChain, httpCache, cacheConfig, null);
    }

    public CachingExec(ClientExecChain clientExecChain, HttpCache httpCache, CacheConfig cacheConfig, AsynchronousValidator asynchronousValidator) {
        Args.notNull(clientExecChain, "HTTP backend");
        Args.notNull(httpCache, "HttpCache");
        this.cacheConfig = cacheConfig != null ? cacheConfig : CacheConfig.DEFAULT;
        this.backend = clientExecChain;
        this.responseCache = httpCache;
        this.validityPolicy = new CacheValidityPolicy();
        this.responseGenerator = new CachedHttpResponseGenerator(this.validityPolicy);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker(this.validityPolicy, this.cacheConfig);
        this.conditionalRequestBuilder = new ConditionalRequestBuilder();
        this.responseCompliance = new ResponseProtocolCompliance();
        this.requestCompliance = new RequestProtocolCompliance(this.cacheConfig.isWeakETagOnPutDeleteAllowed());
        this.responseCachingPolicy = new ResponseCachingPolicy(this.cacheConfig.getMaxObjectSize(), this.cacheConfig.isSharedCache(), this.cacheConfig.isNeverCacheHTTP10ResponsesWithQuery(), this.cacheConfig.is303CachingEnabled());
        this.asynchRevalidator = asynchronousValidator;
    }

    public CachingExec(ClientExecChain clientExecChain, ResourceFactory resourceFactory, HttpCacheStorage httpCacheStorage, CacheConfig cacheConfig) {
        this(clientExecChain, new BasicHttpCache(resourceFactory, httpCacheStorage, cacheConfig), cacheConfig);
    }

    public CachingExec(ClientExecChain clientExecChain) {
        this(clientExecChain, new BasicHttpCache(), CacheConfig.DEFAULT);
    }

    CachingExec(ClientExecChain clientExecChain, HttpCache httpCache, CacheValidityPolicy cacheValidityPolicy, ResponseCachingPolicy responseCachingPolicy, CachedHttpResponseGenerator cachedHttpResponseGenerator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker cachedResponseSuitabilityChecker, ConditionalRequestBuilder conditionalRequestBuilder, ResponseProtocolCompliance responseProtocolCompliance, RequestProtocolCompliance requestProtocolCompliance, CacheConfig cacheConfig, AsynchronousValidator asynchronousValidator) {
        this.cacheConfig = cacheConfig != null ? cacheConfig : CacheConfig.DEFAULT;
        this.backend = clientExecChain;
        this.responseCache = httpCache;
        this.validityPolicy = cacheValidityPolicy;
        this.responseCachingPolicy = responseCachingPolicy;
        this.responseGenerator = cachedHttpResponseGenerator;
        this.cacheableRequestPolicy = cacheableRequestPolicy;
        this.suitabilityChecker = cachedResponseSuitabilityChecker;
        this.conditionalRequestBuilder = conditionalRequestBuilder;
        this.responseCompliance = responseProtocolCompliance;
        this.requestCompliance = requestProtocolCompliance;
        this.asynchRevalidator = asynchronousValidator;
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    public long getCacheUpdates() {
        return this.cacheUpdates.get();
    }

    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper) {
        return this.execute(httpRoute, httpRequestWrapper, HttpClientContext.create(), null);
    }

    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext) {
        return this.execute(httpRoute, httpRequestWrapper, httpClientContext, null);
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) {
        HttpHost httpHost = httpClientContext.getTargetHost();
        String string = this.generateViaHeader(httpRequestWrapper.getOriginal());
        this.setResponseStatus(httpClientContext, CacheResponseStatus.CACHE_MISS);
        if (this.clientRequestsOurOptions(httpRequestWrapper)) {
            this.setResponseStatus(httpClientContext, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return Proxies.enhanceResponse(new OptionsHttp11Response());
        }
        HttpResponse httpResponse = this.getFatallyNoncompliantResponse(httpRequestWrapper, httpClientContext);
        if (httpResponse != null) {
            return Proxies.enhanceResponse(httpResponse);
        }
        this.requestCompliance.makeRequestCompliant(httpRequestWrapper);
        httpRequestWrapper.addHeader("Via", string);
        this.flushEntriesInvalidatedByRequest(httpClientContext.getTargetHost(), httpRequestWrapper);
        if (!this.cacheableRequestPolicy.isServableFromCache(httpRequestWrapper)) {
            this.log.debug("Request is not servable from cache");
            return this.callBackend(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        }
        HttpCacheEntry httpCacheEntry = this.satisfyFromCache(httpHost, httpRequestWrapper);
        if (httpCacheEntry == null) {
            this.log.debug("Cache miss");
            return this.handleCacheMiss(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        }
        return this.handleCacheHit(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware, httpCacheEntry);
    }

    private CloseableHttpResponse handleCacheHit(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware, HttpCacheEntry httpCacheEntry) {
        HttpHost httpHost = httpClientContext.getTargetHost();
        this.recordCacheHit(httpHost, httpRequestWrapper);
        CloseableHttpResponse closeableHttpResponse = null;
        Date date = this.getCurrentDate();
        if (this.suitabilityChecker.canCachedResponseBeUsed(httpHost, httpRequestWrapper, httpCacheEntry, date)) {
            this.log.debug("Cache hit");
            closeableHttpResponse = this.generateCachedResponse(httpRequestWrapper, httpClientContext, httpCacheEntry, date);
        } else if (!this.mayCallBackend(httpRequestWrapper)) {
            this.log.debug("Cache entry not suitable but only-if-cached requested");
            closeableHttpResponse = this.generateGatewayTimeout(httpClientContext);
        } else {
            if (httpCacheEntry.getStatusCode() != 304 || this.suitabilityChecker.isConditional(httpRequestWrapper)) {
                this.log.debug("Revalidating cache entry");
                return this.revalidateCacheEntry(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware, httpCacheEntry, date);
            }
            this.log.debug("Cache entry not usable; calling backend");
            return this.callBackend(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        }
        httpClientContext.setAttribute("http.route", httpRoute);
        httpClientContext.setAttribute("http.target_host", httpHost);
        httpClientContext.setAttribute("http.request", httpRequestWrapper);
        httpClientContext.setAttribute("http.response", closeableHttpResponse);
        httpClientContext.setAttribute("http.request_sent", Boolean.TRUE);
        return closeableHttpResponse;
    }

    private CloseableHttpResponse revalidateCacheEntry(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware, HttpCacheEntry httpCacheEntry, Date date) {
        try {
            if (this.asynchRevalidator != null && !this.staleResponseNotAllowed(httpRequestWrapper, httpCacheEntry, date) && this.validityPolicy.mayReturnStaleWhileRevalidating(httpCacheEntry, date)) {
                this.log.trace("Serving stale with asynchronous revalidation");
                CloseableHttpResponse closeableHttpResponse = this.generateCachedResponse(httpRequestWrapper, httpClientContext, httpCacheEntry, date);
                this.asynchRevalidator.revalidateCacheEntry(this, httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware, httpCacheEntry);
                return closeableHttpResponse;
            }
            return this.revalidateCacheEntry(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware, httpCacheEntry);
        }
        catch (IOException iOException) {
            return this.handleRevalidationFailure(httpRequestWrapper, httpClientContext, httpCacheEntry, date);
        }
    }

    private CloseableHttpResponse handleCacheMiss(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) {
        HttpHost httpHost = httpClientContext.getTargetHost();
        this.recordCacheMiss(httpHost, httpRequestWrapper);
        if (!this.mayCallBackend(httpRequestWrapper)) {
            return Proxies.enhanceResponse(new BasicHttpResponse(HttpVersion.HTTP_1_1, 504, "Gateway Timeout"));
        }
        Map<String, Variant> map = this.getExistingCacheVariants(httpHost, httpRequestWrapper);
        if (map != null && !map.isEmpty()) {
            return this.negotiateResponseFromVariants(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware, map);
        }
        return this.callBackend(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
    }

    private HttpCacheEntry satisfyFromCache(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        HttpCacheEntry httpCacheEntry = null;
        try {
            httpCacheEntry = this.responseCache.getCacheEntry(httpHost, httpRequestWrapper);
        }
        catch (IOException iOException) {
            this.log.warn("Unable to retrieve entries from cache", iOException);
        }
        return httpCacheEntry;
    }

    private HttpResponse getFatallyNoncompliantResponse(HttpRequestWrapper httpRequestWrapper, HttpContext httpContext) {
        HttpResponse httpResponse = null;
        List<RequestProtocolError> list = this.requestCompliance.requestIsFatallyNonCompliant(httpRequestWrapper);
        for (RequestProtocolError requestProtocolError : list) {
            this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            httpResponse = this.requestCompliance.getErrorForRequest(requestProtocolError);
        }
        return httpResponse;
    }

    private Map<String, Variant> getExistingCacheVariants(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        Map<String, Variant> map = null;
        try {
            map = this.responseCache.getVariantCacheEntriesWithEtags(httpHost, httpRequestWrapper);
        }
        catch (IOException iOException) {
            this.log.warn("Unable to retrieve variant entries from cache", iOException);
        }
        return map;
    }

    private void recordCacheMiss(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        this.cacheMisses.getAndIncrement();
        if (this.log.isTraceEnabled()) {
            RequestLine requestLine = httpRequestWrapper.getRequestLine();
            this.log.trace("Cache miss [host: " + httpHost + "; uri: " + requestLine.getUri() + "]");
        }
    }

    private void recordCacheHit(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        this.cacheHits.getAndIncrement();
        if (this.log.isTraceEnabled()) {
            RequestLine requestLine = httpRequestWrapper.getRequestLine();
            this.log.trace("Cache hit [host: " + httpHost + "; uri: " + requestLine.getUri() + "]");
        }
    }

    private void recordCacheUpdate(HttpContext httpContext) {
        this.cacheUpdates.getAndIncrement();
        this.setResponseStatus(httpContext, CacheResponseStatus.VALIDATED);
    }

    private void flushEntriesInvalidatedByRequest(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper) {
        try {
            this.responseCache.flushInvalidatedCacheEntriesFor(httpHost, httpRequestWrapper);
        }
        catch (IOException iOException) {
            this.log.warn("Unable to flush invalidated entries from cache", iOException);
        }
    }

    private CloseableHttpResponse generateCachedResponse(HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry, Date date) {
        CloseableHttpResponse closeableHttpResponse = httpRequestWrapper.containsHeader("If-None-Match") || httpRequestWrapper.containsHeader("If-Modified-Since") ? this.responseGenerator.generateNotModifiedResponse(httpCacheEntry) : this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry);
        this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_HIT);
        if (this.validityPolicy.getStalenessSecs(httpCacheEntry, date) > 0L) {
            closeableHttpResponse.addHeader("Warning", "110 localhost \"Response is stale\"");
        }
        return closeableHttpResponse;
    }

    private CloseableHttpResponse handleRevalidationFailure(HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry, Date date) {
        if (this.staleResponseNotAllowed(httpRequestWrapper, httpCacheEntry, date)) {
            return this.generateGatewayTimeout(httpContext);
        }
        return this.unvalidatedCacheHit(httpRequestWrapper, httpContext, httpCacheEntry);
    }

    private CloseableHttpResponse generateGatewayTimeout(HttpContext httpContext) {
        this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_MODULE_RESPONSE);
        return Proxies.enhanceResponse(new BasicHttpResponse(HttpVersion.HTTP_1_1, 504, "Gateway Timeout"));
    }

    private CloseableHttpResponse unvalidatedCacheHit(HttpRequestWrapper httpRequestWrapper, HttpContext httpContext, HttpCacheEntry httpCacheEntry) {
        CloseableHttpResponse closeableHttpResponse = this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry);
        this.setResponseStatus(httpContext, CacheResponseStatus.CACHE_HIT);
        closeableHttpResponse.addHeader("Warning", "111 localhost \"Revalidation failed\"");
        return closeableHttpResponse;
    }

    private boolean staleResponseNotAllowed(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry, Date date) {
        return this.validityPolicy.mustRevalidate(httpCacheEntry) || this.cacheConfig.isSharedCache() && this.validityPolicy.proxyRevalidate(httpCacheEntry) || this.explicitFreshnessRequest(httpRequestWrapper, httpCacheEntry, date);
    }

    private boolean mayCallBackend(HttpRequestWrapper httpRequestWrapper) {
        for (Header header : httpRequestWrapper.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"only-if-cached".equals(headerElement.getName())) continue;
                this.log.trace("Request marked only-if-cached");
                return false;
            }
        }
        return true;
    }

    private boolean explicitFreshnessRequest(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry, Date date) {
        for (Header header : httpRequestWrapper.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if ("max-stale".equals(headerElement.getName())) {
                    try {
                        int n2 = Integer.parseInt(headerElement.getValue());
                        long l2 = this.validityPolicy.getCurrentAgeSecs(httpCacheEntry, date);
                        long l3 = this.validityPolicy.getFreshnessLifetimeSecs(httpCacheEntry);
                        if (l2 - l3 <= (long)n2) continue;
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return true;
                    }
                }
                if (!"min-fresh".equals(headerElement.getName()) && !"max-age".equals(headerElement.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private String generateViaHeader(HttpMessage httpMessage) {
        ProtocolVersion protocolVersion = httpMessage.getProtocolVersion();
        String string = this.viaHeaders.get(protocolVersion);
        if (string != null) {
            return string;
        }
        VersionInfo versionInfo = VersionInfo.loadVersionInfo("org.apache.http.client", this.getClass().getClassLoader());
        String string2 = versionInfo != null ? versionInfo.getRelease() : "UNAVAILABLE";
        int n2 = protocolVersion.getMajor();
        int n3 = protocolVersion.getMinor();
        String string3 = "http".equalsIgnoreCase(protocolVersion.getProtocol()) ? String.format("%d.%d localhost (Apache-HttpClient/%s (cache))", n2, n3, string2) : String.format("%s/%d.%d localhost (Apache-HttpClient/%s (cache))", protocolVersion.getProtocol(), n2, n3, string2);
        this.viaHeaders.put(protocolVersion, string3);
        return string3;
    }

    private void setResponseStatus(HttpContext httpContext, CacheResponseStatus cacheResponseStatus) {
        if (httpContext != null) {
            httpContext.setAttribute("http.cache.response.status", (Object)cacheResponseStatus);
        }
    }

    public boolean supportsRangeAndContentRangeHeaders() {
        return false;
    }

    Date getCurrentDate() {
        return new Date();
    }

    boolean clientRequestsOurOptions(HttpRequest httpRequest) {
        RequestLine requestLine = httpRequest.getRequestLine();
        if (!"OPTIONS".equals(requestLine.getMethod())) {
            return false;
        }
        if (!"*".equals(requestLine.getUri())) {
            return false;
        }
        return "0".equals(httpRequest.getFirstHeader("Max-Forwards").getValue());
    }

    CloseableHttpResponse callBackend(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) {
        Date date = this.getCurrentDate();
        this.log.trace("Calling the backend");
        CloseableHttpResponse closeableHttpResponse = this.backend.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        try {
            closeableHttpResponse.addHeader("Via", this.generateViaHeader(closeableHttpResponse));
            return this.handleBackendResponse(httpRequestWrapper, httpClientContext, date, this.getCurrentDate(), closeableHttpResponse);
        }
        catch (IOException iOException) {
            closeableHttpResponse.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            closeableHttpResponse.close();
            throw runtimeException;
        }
    }

    private boolean revalidationResponseIsTooOld(HttpResponse httpResponse, HttpCacheEntry httpCacheEntry) {
        Header header = httpCacheEntry.getFirstHeader("Date");
        Header header2 = httpResponse.getFirstHeader("Date");
        if (header != null && header2 != null) {
            Date date = DateUtils.parseDate(header.getValue());
            Date date2 = DateUtils.parseDate(header2.getValue());
            if (date == null || date2 == null) {
                return false;
            }
            if (date2.before(date)) {
                return true;
            }
        }
        return false;
    }

    CloseableHttpResponse negotiateResponseFromVariants(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware, Map<String, Variant> map) {
        HttpRequestWrapper httpRequestWrapper2 = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(httpRequestWrapper, map);
        Date date = this.getCurrentDate();
        CloseableHttpResponse closeableHttpResponse = this.backend.execute(httpRoute, httpRequestWrapper2, httpClientContext, httpExecutionAware);
        try {
            Date date2 = this.getCurrentDate();
            closeableHttpResponse.addHeader("Via", this.generateViaHeader(closeableHttpResponse));
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 304) {
                return this.handleBackendResponse(httpRequestWrapper, httpClientContext, date, date2, closeableHttpResponse);
            }
            Header header = closeableHttpResponse.getFirstHeader("ETag");
            if (header == null) {
                this.log.warn("304 response did not contain ETag");
                IOUtils.consume(closeableHttpResponse.getEntity());
                closeableHttpResponse.close();
                return this.callBackend(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            }
            String string = header.getValue();
            Variant variant = map.get(string);
            if (variant == null) {
                this.log.debug("304 response did not contain ETag matching one sent in If-None-Match");
                IOUtils.consume(closeableHttpResponse.getEntity());
                closeableHttpResponse.close();
                return this.callBackend(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            }
            HttpCacheEntry httpCacheEntry = variant.getEntry();
            if (this.revalidationResponseIsTooOld(closeableHttpResponse, httpCacheEntry)) {
                IOUtils.consume(closeableHttpResponse.getEntity());
                closeableHttpResponse.close();
                return this.retryRequestUnconditionally(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware, httpCacheEntry);
            }
            this.recordCacheUpdate(httpClientContext);
            HttpCacheEntry httpCacheEntry2 = this.getUpdatedVariantEntry(httpClientContext.getTargetHost(), httpRequestWrapper2, date, date2, closeableHttpResponse, variant, httpCacheEntry);
            closeableHttpResponse.close();
            CloseableHttpResponse closeableHttpResponse2 = this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry2);
            this.tryToUpdateVariantMap(httpClientContext.getTargetHost(), httpRequestWrapper, variant);
            if (this.shouldSendNotModifiedResponse(httpRequestWrapper, httpCacheEntry2)) {
                return this.responseGenerator.generateNotModifiedResponse(httpCacheEntry2);
            }
            return closeableHttpResponse2;
        }
        catch (IOException iOException) {
            closeableHttpResponse.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            closeableHttpResponse.close();
            throw runtimeException;
        }
    }

    private CloseableHttpResponse retryRequestUnconditionally(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware, HttpCacheEntry httpCacheEntry) {
        HttpRequestWrapper httpRequestWrapper2 = this.conditionalRequestBuilder.buildUnconditionalRequest(httpRequestWrapper, httpCacheEntry);
        return this.callBackend(httpRoute, httpRequestWrapper2, httpClientContext, httpExecutionAware);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpCacheEntry getUpdatedVariantEntry(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, Date date, Date date2, CloseableHttpResponse closeableHttpResponse, Variant variant, HttpCacheEntry httpCacheEntry) {
        HttpCacheEntry httpCacheEntry2 = httpCacheEntry;
        try {
            httpCacheEntry2 = this.responseCache.updateVariantCacheEntry(httpHost, httpRequestWrapper, httpCacheEntry, closeableHttpResponse, date, date2, variant.getCacheKey());
        }
        catch (IOException iOException) {
            this.log.warn("Could not update cache entry", iOException);
        }
        finally {
            closeableHttpResponse.close();
        }
        return httpCacheEntry2;
    }

    private void tryToUpdateVariantMap(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, Variant variant) {
        try {
            this.responseCache.reuseVariantEntryFor(httpHost, httpRequestWrapper, variant);
        }
        catch (IOException iOException) {
            this.log.warn("Could not update cache entry to reuse variant", iOException);
        }
    }

    private boolean shouldSendNotModifiedResponse(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry) {
        return this.suitabilityChecker.isConditional(httpRequestWrapper) && this.suitabilityChecker.allConditionalsMatch(httpRequestWrapper, httpCacheEntry, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableHttpResponse revalidateCacheEntry(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware, HttpCacheEntry httpCacheEntry) {
        HttpRequestWrapper httpRequestWrapper2 = this.conditionalRequestBuilder.buildConditionalRequest(httpRequestWrapper, httpCacheEntry);
        URI uRI = httpRequestWrapper2.getURI();
        if (uRI != null) {
            try {
                httpRequestWrapper2.setURI(URIUtils.rewriteURIForRoute(uRI, httpRoute));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException("Invalid URI: " + uRI, uRISyntaxException);
            }
        }
        Date date = this.getCurrentDate();
        CloseableHttpResponse closeableHttpResponse = this.backend.execute(httpRoute, httpRequestWrapper2, httpClientContext, httpExecutionAware);
        Date date2 = this.getCurrentDate();
        if (this.revalidationResponseIsTooOld(closeableHttpResponse, httpCacheEntry)) {
            closeableHttpResponse.close();
            HttpRequestWrapper httpRequestWrapper3 = this.conditionalRequestBuilder.buildUnconditionalRequest(httpRequestWrapper, httpCacheEntry);
            date = this.getCurrentDate();
            closeableHttpResponse = this.backend.execute(httpRoute, httpRequestWrapper3, httpClientContext, httpExecutionAware);
            date2 = this.getCurrentDate();
        }
        closeableHttpResponse.addHeader("Via", this.generateViaHeader(closeableHttpResponse));
        int n2 = closeableHttpResponse.getStatusLine().getStatusCode();
        if (n2 == 304 || n2 == 200) {
            this.recordCacheUpdate(httpClientContext);
        }
        if (n2 == 304) {
            HttpCacheEntry httpCacheEntry2 = this.responseCache.updateCacheEntry(httpClientContext.getTargetHost(), httpRequestWrapper, httpCacheEntry, closeableHttpResponse, date, date2);
            if (this.suitabilityChecker.isConditional(httpRequestWrapper) && this.suitabilityChecker.allConditionalsMatch(httpRequestWrapper, httpCacheEntry2, new Date())) {
                return this.responseGenerator.generateNotModifiedResponse(httpCacheEntry2);
            }
            return this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry2);
        }
        if (this.staleIfErrorAppliesTo(n2) && !this.staleResponseNotAllowed(httpRequestWrapper, httpCacheEntry, this.getCurrentDate()) && this.validityPolicy.mayReturnStaleIfError(httpRequestWrapper, httpCacheEntry, date2)) {
            try {
                CloseableHttpResponse closeableHttpResponse2 = this.responseGenerator.generateResponse(httpRequestWrapper, httpCacheEntry);
                closeableHttpResponse2.addHeader("Warning", "110 localhost \"Response is stale\"");
                CloseableHttpResponse closeableHttpResponse3 = closeableHttpResponse2;
                return closeableHttpResponse3;
            }
            finally {
                closeableHttpResponse.close();
            }
        }
        return this.handleBackendResponse(httpRequestWrapper2, httpClientContext, date, date2, closeableHttpResponse);
    }

    private boolean staleIfErrorAppliesTo(int n2) {
        return n2 == 500 || n2 == 502 || n2 == 503 || n2 == 504;
    }

    CloseableHttpResponse handleBackendResponse(HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, Date date, Date date2, CloseableHttpResponse closeableHttpResponse) {
        this.log.trace("Handling Backend response");
        this.responseCompliance.ensureProtocolCompliance(httpRequestWrapper, closeableHttpResponse);
        HttpHost httpHost = httpClientContext.getTargetHost();
        boolean bl = this.responseCachingPolicy.isResponseCacheable(httpRequestWrapper, (HttpResponse)closeableHttpResponse);
        this.responseCache.flushInvalidatedCacheEntriesFor(httpHost, httpRequestWrapper, closeableHttpResponse);
        if (bl && !this.alreadyHaveNewerCacheEntry(httpHost, httpRequestWrapper, closeableHttpResponse)) {
            this.storeRequestIfModifiedSinceFor304Response(httpRequestWrapper, closeableHttpResponse);
            return this.responseCache.cacheAndReturnResponse(httpHost, (HttpRequest)httpRequestWrapper, closeableHttpResponse, date, date2);
        }
        if (!bl) {
            try {
                this.responseCache.flushCacheEntriesFor(httpHost, httpRequestWrapper);
            }
            catch (IOException iOException) {
                this.log.warn("Unable to flush invalid cache entries", iOException);
            }
        }
        return closeableHttpResponse;
    }

    private void storeRequestIfModifiedSinceFor304Response(HttpRequest httpRequest, HttpResponse httpResponse) {
        Header header;
        if (httpResponse.getStatusLine().getStatusCode() == 304 && (header = httpRequest.getFirstHeader("If-Modified-Since")) != null) {
            httpResponse.addHeader("Last-Modified", header.getValue());
        }
    }

    private boolean alreadyHaveNewerCacheEntry(HttpHost httpHost, HttpRequestWrapper httpRequestWrapper, HttpResponse httpResponse) {
        HttpCacheEntry httpCacheEntry = null;
        try {
            httpCacheEntry = this.responseCache.getCacheEntry(httpHost, httpRequestWrapper);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (httpCacheEntry == null) {
            return false;
        }
        Header header = httpCacheEntry.getFirstHeader("Date");
        if (header == null) {
            return false;
        }
        Header header2 = httpResponse.getFirstHeader("Date");
        if (header2 == null) {
            return false;
        }
        Date date = DateUtils.parseDate(header.getValue());
        Date date2 = DateUtils.parseDate(header2.getValue());
        if (date == null || date2 == null) {
            return false;
        }
        return date2.before(date);
    }
}

