/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import org.apache.http.util.Args;

public class CacheConfig
implements Cloneable {
    public static final int DEFAULT_MAX_OBJECT_SIZE_BYTES = 8192;
    public static final int DEFAULT_MAX_CACHE_ENTRIES = 1000;
    public static final int DEFAULT_MAX_UPDATE_RETRIES = 1;
    public static final boolean DEFAULT_303_CACHING_ENABLED = false;
    public static final boolean DEFAULT_WEAK_ETAG_ON_PUTDELETE_ALLOWED = false;
    public static final boolean DEFAULT_HEURISTIC_CACHING_ENABLED = false;
    public static final float DEFAULT_HEURISTIC_COEFFICIENT = 0.1f;
    public static final long DEFAULT_HEURISTIC_LIFETIME = 0L;
    public static final int DEFAULT_ASYNCHRONOUS_WORKERS_MAX = 1;
    public static final int DEFAULT_ASYNCHRONOUS_WORKERS_CORE = 1;
    public static final int DEFAULT_ASYNCHRONOUS_WORKER_IDLE_LIFETIME_SECS = 60;
    public static final int DEFAULT_REVALIDATION_QUEUE_SIZE = 100;
    public static final CacheConfig DEFAULT = new Builder().build();
    private long maxObjectSize;
    private int maxCacheEntries;
    private int maxUpdateRetries;
    private final boolean allow303Caching;
    private final boolean weakETagOnPutDeleteAllowed;
    private boolean heuristicCachingEnabled;
    private float heuristicCoefficient;
    private long heuristicDefaultLifetime;
    private boolean isSharedCache;
    private int asynchronousWorkersMax;
    private int asynchronousWorkersCore;
    private int asynchronousWorkerIdleLifetimeSecs;
    private int revalidationQueueSize;
    private boolean neverCacheHTTP10ResponsesWithQuery;

    public CacheConfig() {
        this.maxObjectSize = 8192L;
        this.maxCacheEntries = 1000;
        this.maxUpdateRetries = 1;
        this.allow303Caching = false;
        this.weakETagOnPutDeleteAllowed = false;
        this.heuristicCachingEnabled = false;
        this.heuristicCoefficient = 0.1f;
        this.heuristicDefaultLifetime = 0L;
        this.isSharedCache = true;
        this.asynchronousWorkersMax = 1;
        this.asynchronousWorkersCore = 1;
        this.asynchronousWorkerIdleLifetimeSecs = 60;
        this.revalidationQueueSize = 100;
    }

    CacheConfig(long l2, int n2, int n3, boolean bl, boolean bl2, boolean bl3, float f2, long l3, boolean bl4, int n4, int n5, int n6, int n7, boolean bl5) {
        this.maxObjectSize = l2;
        this.maxCacheEntries = n2;
        this.maxUpdateRetries = n3;
        this.allow303Caching = bl;
        this.weakETagOnPutDeleteAllowed = bl2;
        this.heuristicCachingEnabled = bl3;
        this.heuristicCoefficient = f2;
        this.heuristicDefaultLifetime = l3;
        this.isSharedCache = bl4;
        this.asynchronousWorkersMax = n4;
        this.asynchronousWorkersCore = n5;
        this.asynchronousWorkerIdleLifetimeSecs = n6;
        this.revalidationQueueSize = n7;
    }

    public int getMaxObjectSizeBytes() {
        return this.maxObjectSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.maxObjectSize;
    }

    public void setMaxObjectSizeBytes(int n2) {
        this.maxObjectSize = n2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (long)n2;
    }

    public long getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(long l2) {
        this.maxObjectSize = l2;
    }

    public boolean isNeverCacheHTTP10ResponsesWithQuery() {
        return this.neverCacheHTTP10ResponsesWithQuery;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int n2) {
        this.maxCacheEntries = n2;
    }

    public int getMaxUpdateRetries() {
        return this.maxUpdateRetries;
    }

    public void setMaxUpdateRetries(int n2) {
        this.maxUpdateRetries = n2;
    }

    public boolean is303CachingEnabled() {
        return this.allow303Caching;
    }

    public boolean isWeakETagOnPutDeleteAllowed() {
        return this.weakETagOnPutDeleteAllowed;
    }

    public boolean isHeuristicCachingEnabled() {
        return this.heuristicCachingEnabled;
    }

    public void setHeuristicCachingEnabled(boolean bl) {
        this.heuristicCachingEnabled = bl;
    }

    public float getHeuristicCoefficient() {
        return this.heuristicCoefficient;
    }

    public void setHeuristicCoefficient(float f2) {
        this.heuristicCoefficient = f2;
    }

    public long getHeuristicDefaultLifetime() {
        return this.heuristicDefaultLifetime;
    }

    public void setHeuristicDefaultLifetime(long l2) {
        this.heuristicDefaultLifetime = l2;
    }

    public boolean isSharedCache() {
        return this.isSharedCache;
    }

    public void setSharedCache(boolean bl) {
        this.isSharedCache = bl;
    }

    public int getAsynchronousWorkersMax() {
        return this.asynchronousWorkersMax;
    }

    public void setAsynchronousWorkersMax(int n2) {
        this.asynchronousWorkersMax = n2;
    }

    public int getAsynchronousWorkersCore() {
        return this.asynchronousWorkersCore;
    }

    public void setAsynchronousWorkersCore(int n2) {
        this.asynchronousWorkersCore = n2;
    }

    public int getAsynchronousWorkerIdleLifetimeSecs() {
        return this.asynchronousWorkerIdleLifetimeSecs;
    }

    public void setAsynchronousWorkerIdleLifetimeSecs(int n2) {
        this.asynchronousWorkerIdleLifetimeSecs = n2;
    }

    public int getRevalidationQueueSize() {
        return this.revalidationQueueSize;
    }

    public void setRevalidationQueueSize(int n2) {
        this.revalidationQueueSize = n2;
    }

    protected CacheConfig clone() {
        return (CacheConfig)super.clone();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(CacheConfig cacheConfig) {
        Args.notNull(cacheConfig, "Cache config");
        return new Builder().setMaxObjectSize(cacheConfig.getMaxObjectSize()).setMaxCacheEntries(cacheConfig.getMaxCacheEntries()).setMaxUpdateRetries(cacheConfig.getMaxUpdateRetries()).setHeuristicCachingEnabled(cacheConfig.isHeuristicCachingEnabled()).setHeuristicCoefficient(cacheConfig.getHeuristicCoefficient()).setHeuristicDefaultLifetime(cacheConfig.getHeuristicDefaultLifetime()).setSharedCache(cacheConfig.isSharedCache()).setAsynchronousWorkersMax(cacheConfig.getAsynchronousWorkersMax()).setAsynchronousWorkersCore(cacheConfig.getAsynchronousWorkersCore()).setAsynchronousWorkerIdleLifetimeSecs(cacheConfig.getAsynchronousWorkerIdleLifetimeSecs()).setRevalidationQueueSize(cacheConfig.getRevalidationQueueSize()).setNeverCacheHTTP10ResponsesWithQueryString(cacheConfig.isNeverCacheHTTP10ResponsesWithQuery());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[maxObjectSize=").append(this.maxObjectSize).append(", maxCacheEntries=").append(this.maxCacheEntries).append(", maxUpdateRetries=").append(this.maxUpdateRetries).append(", 303CachingEnabled=").append(this.allow303Caching).append(", weakETagOnPutDeleteAllowed=").append(this.weakETagOnPutDeleteAllowed).append(", heuristicCachingEnabled=").append(this.heuristicCachingEnabled).append(", heuristicCoefficient=").append(this.heuristicCoefficient).append(", heuristicDefaultLifetime=").append(this.heuristicDefaultLifetime).append(", isSharedCache=").append(this.isSharedCache).append(", asynchronousWorkersMax=").append(this.asynchronousWorkersMax).append(", asynchronousWorkersCore=").append(this.asynchronousWorkersCore).append(", asynchronousWorkerIdleLifetimeSecs=").append(this.asynchronousWorkerIdleLifetimeSecs).append(", revalidationQueueSize=").append(this.revalidationQueueSize).append(", neverCacheHTTP10ResponsesWithQuery=").append(this.neverCacheHTTP10ResponsesWithQuery).append("]");
        return stringBuilder.toString();
    }

    public static class Builder {
        private long maxObjectSize = 8192L;
        private int maxCacheEntries = 1000;
        private int maxUpdateRetries = 1;
        private boolean allow303Caching = false;
        private boolean weakETagOnPutDeleteAllowed = false;
        private boolean heuristicCachingEnabled = false;
        private float heuristicCoefficient = 0.1f;
        private long heuristicDefaultLifetime = 0L;
        private boolean isSharedCache = true;
        private int asynchronousWorkersMax = 1;
        private int asynchronousWorkersCore = 1;
        private int asynchronousWorkerIdleLifetimeSecs = 60;
        private int revalidationQueueSize = 100;
        private boolean neverCacheHTTP10ResponsesWithQuery;

        Builder() {
        }

        public Builder setMaxObjectSize(long l2) {
            this.maxObjectSize = l2;
            return this;
        }

        public Builder setMaxCacheEntries(int n2) {
            this.maxCacheEntries = n2;
            return this;
        }

        public Builder setMaxUpdateRetries(int n2) {
            this.maxUpdateRetries = n2;
            return this;
        }

        public Builder setAllow303Caching(boolean bl) {
            this.allow303Caching = bl;
            return this;
        }

        public Builder setWeakETagOnPutDeleteAllowed(boolean bl) {
            this.weakETagOnPutDeleteAllowed = bl;
            return this;
        }

        public Builder setHeuristicCachingEnabled(boolean bl) {
            this.heuristicCachingEnabled = bl;
            return this;
        }

        public Builder setHeuristicCoefficient(float f2) {
            this.heuristicCoefficient = f2;
            return this;
        }

        public Builder setHeuristicDefaultLifetime(long l2) {
            this.heuristicDefaultLifetime = l2;
            return this;
        }

        public Builder setSharedCache(boolean bl) {
            this.isSharedCache = bl;
            return this;
        }

        public Builder setAsynchronousWorkersMax(int n2) {
            this.asynchronousWorkersMax = n2;
            return this;
        }

        public Builder setAsynchronousWorkersCore(int n2) {
            this.asynchronousWorkersCore = n2;
            return this;
        }

        public Builder setAsynchronousWorkerIdleLifetimeSecs(int n2) {
            this.asynchronousWorkerIdleLifetimeSecs = n2;
            return this;
        }

        public Builder setRevalidationQueueSize(int n2) {
            this.revalidationQueueSize = n2;
            return this;
        }

        public Builder setNeverCacheHTTP10ResponsesWithQueryString(boolean bl) {
            this.neverCacheHTTP10ResponsesWithQuery = bl;
            return this;
        }

        public CacheConfig build() {
            return new CacheConfig(this.maxObjectSize, this.maxCacheEntries, this.maxUpdateRetries, this.allow303Caching, this.weakETagOnPutDeleteAllowed, this.heuristicCachingEnabled, this.heuristicCoefficient, this.heuristicDefaultLifetime, this.isSharedCache, this.asynchronousWorkersMax, this.asynchronousWorkersCore, this.asynchronousWorkerIdleLifetimeSecs, this.revalidationQueueSize, this.neverCacheHTTP10ResponsesWithQuery);
        }
    }
}

