/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.BackoffManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.Clock;
import org.apache.http.impl.client.SystemClock;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.util.Args;

public class AIMDBackoffManager
implements BackoffManager {
    private final ConnPoolControl<HttpRoute> connPerRoute;
    private final Clock clock;
    private final Map<HttpRoute, Long> lastRouteProbes;
    private final Map<HttpRoute, Long> lastRouteBackoffs;
    private long coolDown = 5000L;
    private double backoffFactor = 0.5;
    private int cap = 2;

    public AIMDBackoffManager(ConnPoolControl<HttpRoute> connPoolControl) {
        this(connPoolControl, new SystemClock());
    }

    AIMDBackoffManager(ConnPoolControl<HttpRoute> connPoolControl, Clock clock) {
        this.clock = clock;
        this.connPerRoute = connPoolControl;
        this.lastRouteProbes = new HashMap<HttpRoute, Long>();
        this.lastRouteBackoffs = new HashMap<HttpRoute, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backOff(HttpRoute httpRoute) {
        ConnPoolControl<HttpRoute> connPoolControl = this.connPerRoute;
        synchronized (connPoolControl) {
            int n2 = this.connPerRoute.getMaxPerRoute(httpRoute);
            Long l2 = this.getLastUpdate(this.lastRouteBackoffs, httpRoute);
            long l3 = this.clock.getCurrentTime();
            if (l3 - l2 < this.coolDown) {
                return;
            }
            this.connPerRoute.setMaxPerRoute(httpRoute, this.getBackedOffPoolSize(n2));
            this.lastRouteBackoffs.put(httpRoute, l3);
        }
    }

    private int getBackedOffPoolSize(int n2) {
        if (n2 <= 1) {
            return 1;
        }
        return (int)Math.floor(this.backoffFactor * (double)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void probe(HttpRoute httpRoute) {
        ConnPoolControl<HttpRoute> connPoolControl = this.connPerRoute;
        synchronized (connPoolControl) {
            int n2 = this.connPerRoute.getMaxPerRoute(httpRoute);
            int n3 = n2 >= this.cap ? this.cap : n2 + 1;
            Long l2 = this.getLastUpdate(this.lastRouteProbes, httpRoute);
            Long l3 = this.getLastUpdate(this.lastRouteBackoffs, httpRoute);
            long l4 = this.clock.getCurrentTime();
            if (l4 - l2 < this.coolDown || l4 - l3 < this.coolDown) {
                return;
            }
            this.connPerRoute.setMaxPerRoute(httpRoute, n3);
            this.lastRouteProbes.put(httpRoute, l4);
        }
    }

    private Long getLastUpdate(Map<HttpRoute, Long> map, HttpRoute httpRoute) {
        Long l2 = map.get(httpRoute);
        if (l2 == null) {
            l2 = 0L;
        }
        return l2;
    }

    public void setBackoffFactor(double d2) {
        Args.check(d2 > 0.0 && d2 < 1.0, "Backoff factor must be 0.0 < f < 1.0");
        this.backoffFactor = d2;
    }

    public void setCooldownMillis(long l2) {
        Args.positive(this.coolDown, "Cool down");
        this.coolDown = l2;
    }

    public void setPerHostConnectionCap(int n2) {
        Args.positive(n2, "Per host connection cap");
        this.cap = n2;
    }
}

