/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

public class StringBody
extends AbstractContentBody {
    private final byte[] content;

    public static StringBody create(String string, String string2, Charset charset) {
        try {
            return new StringBody(string, string2, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Charset " + charset + " is not supported", unsupportedEncodingException);
        }
    }

    public static StringBody create(String string, Charset charset) {
        return StringBody.create(string, null, charset);
    }

    public static StringBody create(String string) {
        return StringBody.create(string, null, null);
    }

    public StringBody(String string, String string2, Charset charset) {
        this(string, ContentType.create(string2, charset != null ? charset : Consts.ASCII));
    }

    public StringBody(String string, Charset charset) {
        this(string, "text/plain", charset);
    }

    public StringBody(String string) {
        this(string, "text/plain", Consts.ASCII);
    }

    public StringBody(String string, ContentType contentType) {
        super(contentType);
        Args.notNull(string, "Text");
        Charset charset = contentType.getCharset();
        this.content = string.getBytes(charset != null ? charset : Consts.ASCII);
    }

    public Reader getReader() {
        Charset charset = this.getContentType().getCharset();
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), charset != null ? charset : Consts.ASCII);
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        int n2;
        Args.notNull(outputStream, "Output stream");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.content);
        byte[] byArray = new byte[4096];
        while ((n2 = byteArrayInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.flush();
    }

    @Override
    public String getTransferEncoding() {
        return "8bit";
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public String getFilename() {
        return null;
    }
}

