/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

public class ByteArrayBody
extends AbstractContentBody {
    private final byte[] data;
    private final String filename;

    public ByteArrayBody(byte[] byArray, String string, String string2) {
        this(byArray, ContentType.create(string), string2);
    }

    public ByteArrayBody(byte[] byArray, ContentType contentType, String string) {
        super(contentType);
        Args.notNull(byArray, "byte[]");
        this.data = byArray;
        this.filename = string;
    }

    public ByteArrayBody(byte[] byArray, String string) {
        this(byArray, "application/octet-stream", string);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        outputStream.write(this.data);
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public long getContentLength() {
        return this.data.length;
    }
}

