/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.http.util.Args;

public class EofSensorInputStream
extends InputStream
implements ConnectionReleaseTrigger {
    protected InputStream wrappedStream;
    private boolean selfClosed;
    private final EofSensorWatcher eofWatcher;

    public EofSensorInputStream(InputStream inputStream, EofSensorWatcher eofSensorWatcher) {
        Args.notNull(inputStream, "Wrapped stream");
        this.wrappedStream = inputStream;
        this.selfClosed = false;
        this.eofWatcher = eofSensorWatcher;
    }

    boolean isSelfClosed() {
        return this.selfClosed;
    }

    InputStream getWrappedStream() {
        return this.wrappedStream;
    }

    protected boolean isReadAllowed() {
        if (this.selfClosed) {
            throw new IOException("Attempted read on closed stream.");
        }
        return this.wrappedStream != null;
    }

    @Override
    public int read() {
        int n2 = -1;
        if (this.isReadAllowed()) {
            try {
                n2 = this.wrappedStream.read();
                this.checkEOF(n2);
            }
            catch (IOException iOException) {
                this.checkAbort();
                throw iOException;
            }
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = -1;
        if (this.isReadAllowed()) {
            try {
                n4 = this.wrappedStream.read(byArray, n2, n3);
                this.checkEOF(n4);
            }
            catch (IOException iOException) {
                this.checkAbort();
                throw iOException;
            }
        }
        return n4;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int available() {
        int n2 = 0;
        if (this.isReadAllowed()) {
            try {
                n2 = this.wrappedStream.available();
            }
            catch (IOException iOException) {
                this.checkAbort();
                throw iOException;
            }
        }
        return n2;
    }

    @Override
    public void close() {
        this.selfClosed = true;
        this.checkClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkEOF(int n2) {
        if (this.wrappedStream != null && n2 < 0) {
            try {
                boolean bl = true;
                if (this.eofWatcher != null) {
                    bl = this.eofWatcher.eofDetected(this.wrappedStream);
                }
                if (bl) {
                    this.wrappedStream.close();
                }
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkClose() {
        if (this.wrappedStream != null) {
            try {
                boolean bl = true;
                if (this.eofWatcher != null) {
                    bl = this.eofWatcher.streamClosed(this.wrappedStream);
                }
                if (bl) {
                    this.wrappedStream.close();
                }
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAbort() {
        if (this.wrappedStream != null) {
            try {
                boolean bl = true;
                if (this.eofWatcher != null) {
                    bl = this.eofWatcher.streamAbort(this.wrappedStream);
                }
                if (bl) {
                    this.wrappedStream.close();
                }
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    @Override
    public void releaseConnection() {
        this.close();
    }

    @Override
    public void abortConnection() {
        this.selfClosed = true;
        this.checkAbort();
    }
}

