/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

class InternalInputStreamEntity
extends AbstractHttpEntity {
    private final InputStream content;
    private final long length;

    public InternalInputStreamEntity(InputStream inputStream, long l2, ContentType contentType) {
        this.content = Args.notNull(inputStream, "Source input stream");
        this.length = l2;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) {
        block7: {
            Args.notNull(outputStream, "Output stream");
            InputStream inputStream = this.content;
            try {
                int n2;
                byte[] byArray = new byte[4096];
                if (this.length < 0L) {
                    int n3;
                    while ((n3 = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n3);
                    }
                    break block7;
                }
                for (long i2 = this.length; i2 > 0L; i2 -= (long)n2) {
                    n2 = inputStream.read(byArray, 0, (int)Math.min(4096L, i2));
                    if (n2 == -1) {
                        break;
                    }
                    outputStream.write(byArray, 0, n2);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    @Override
    public boolean isStreaming() {
        return true;
    }
}

