/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class Executor {
    static final PoolingHttpClientConnectionManager CONNMGR;
    static final HttpClient CLIENT;
    private final HttpClient httpclient;
    private volatile AuthCache authCache;
    private volatile CredentialsProvider credentialsProvider;
    private volatile CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(HttpClient httpClient) {
        return new Executor(httpClient != null ? httpClient : CLIENT);
    }

    Executor(HttpClient httpClient) {
        this.httpclient = httpClient;
        this.authCache = new BasicAuthCache();
    }

    public Executor use(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public Executor auth(AuthScope authScope, Credentials credentials) {
        if (this.credentialsProvider == null) {
            this.credentialsProvider = new BasicCredentialsProvider();
        }
        this.credentialsProvider.setCredentials(authScope, credentials);
        return this;
    }

    public Executor auth(HttpHost httpHost, Credentials credentials) {
        AuthScope authScope = httpHost != null ? new AuthScope(httpHost.getHostName(), httpHost.getPort()) : AuthScope.ANY;
        return this.auth(authScope, credentials);
    }

    public Executor auth(String string, Credentials credentials) {
        return this.auth(HttpHost.create(string), credentials);
    }

    public Executor authPreemptive(HttpHost httpHost) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("WWW-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(httpHost, basicScheme);
        return this;
    }

    public Executor authPreemptive(String string) {
        return this.authPreemptive(HttpHost.create(string));
    }

    public Executor authPreemptiveProxy(HttpHost httpHost) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("Proxy-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(httpHost, basicScheme);
        return this;
    }

    public Executor authPreemptiveProxy(String string) {
        return this.authPreemptiveProxy(HttpHost.create(string));
    }

    public Executor auth(Credentials credentials) {
        return this.auth(AuthScope.ANY, credentials);
    }

    public Executor auth(String string, String string2) {
        return this.auth(new UsernamePasswordCredentials(string, string2));
    }

    public Executor auth(String string, String string2, String string3, String string4) {
        return this.auth(new NTCredentials(string, string2, string3, string4));
    }

    public Executor auth(HttpHost httpHost, String string, String string2) {
        return this.auth(httpHost, (Credentials)new UsernamePasswordCredentials(string, string2));
    }

    public Executor auth(HttpHost httpHost, String string, String string2, String string3, String string4) {
        return this.auth(httpHost, (Credentials)new NTCredentials(string, string2, string3, string4));
    }

    public Executor clearAuth() {
        if (this.credentialsProvider != null) {
            this.credentialsProvider.clear();
        }
        return this;
    }

    public Executor cookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor use(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        if (this.cookieStore != null) {
            this.cookieStore.clear();
        }
        return this;
    }

    public Response execute(Request request) {
        HttpClientContext httpClientContext = HttpClientContext.create();
        if (this.credentialsProvider != null) {
            httpClientContext.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        }
        if (this.authCache != null) {
            httpClientContext.setAttribute("http.auth.auth-cache", this.authCache);
        }
        if (this.cookieStore != null) {
            httpClientContext.setAttribute("http.cookie-store", this.cookieStore);
        }
        return new Response(request.internalExecute(this.httpclient, httpClientContext));
    }

    public static void registerScheme(Scheme scheme) {
    }

    public static void unregisterScheme(String string) {
    }

    public static void closeIdleConnections() {
        CONNMGR.closeIdleConnections(0L, TimeUnit.MICROSECONDS);
    }

    static {
        SSLConnectionSocketFactory sSLConnectionSocketFactory = null;
        try {
            sSLConnectionSocketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException sSLInitializationException) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, null, null);
                sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext);
            }
            catch (SecurityException securityException) {
            }
            catch (KeyManagementException keyManagementException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(sSLConnectionSocketFactory != null ? sSLConnectionSocketFactory : SSLConnectionSocketFactory.getSocketFactory()))).build();
        CONNMGR = new PoolingHttpClientConnectionManager(registry);
        CONNMGR.setDefaultMaxPerRoute(100);
        CONNMGR.setMaxTotal(200);
        CONNMGR.setValidateAfterInactivity(1000);
        CLIENT = HttpClientBuilder.create().setConnectionManager(CONNMGR).build();
    }
}

