/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images.util;

import com.mathworks.toolbox.images.ImviewResourceBundle;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageFactory {
    private static final int PIXEL_STRIDE_GRAY = 1;
    private static final int PIXEL_STRIDE_RGB = 3;

    public static BufferedImage createGrayscaleImage(int n, int n2, byte[] byArray) {
        int n3 = 0;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n);
        return ImageFactory.createGrayscaleImage(n, n2, n3, dataBufferByte);
    }

    public static BufferedImage createGrayscaleImage(int n, int n2, short[] sArray) {
        int n3 = 1;
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n);
        return ImageFactory.createGrayscaleImage(n, n2, n3, dataBufferUShort);
    }

    private static BufferedImage createGrayscaleImage(int n, int n2, int n3, DataBuffer dataBuffer) {
        WritableRaster writableRaster;
        ComponentColorModel componentColorModel = ImageFactory.getGrayColorModel(n3);
        ComponentSampleModel componentSampleModel = ImageFactory.getGraySampleModel(n, n2, n3);
        if (dataBuffer == null || componentSampleModel == null) {
            throw new NullPointerException();
        }
        try {
            writableRaster = Raster.createWritableRaster(componentSampleModel, dataBuffer, new Point(0, 0));
        }
        catch (NullPointerException nullPointerException) {
            throw new OutOfMemoryError(ImviewResourceBundle.getString("error.outOfMemory"));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError(ImviewResourceBundle.getString("error.outOfMemory"));
        }
        return new BufferedImage(componentColorModel, writableRaster, false, new Hashtable());
    }

    private static ComponentColorModel getGrayColorModel(int n) {
        int n2 = ImageFactory.getImageDepth(n);
        return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{n2}, false, false, 1, n);
    }

    private static ComponentSampleModel getGraySampleModel(int n, int n2, int n3) {
        return new ComponentSampleModel(n3, n, n2, 1, n, new int[]{0});
    }

    public static BufferedImage createInterleavedRGBImage(int n, int n2, short[] sArray) {
        int n3 = 1;
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n * n2 * 3);
        return ImageFactory.createInterleavedRGBImage(n, n2, n3, dataBufferUShort);
    }

    public static BufferedImage createInterleavedRGBImage(int n, int n2, byte[] byArray) {
        int n3 = 0;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2 * 3);
        return ImageFactory.createInterleavedRGBImage(n, n2, n3, dataBufferByte);
    }

    private static BufferedImage createInterleavedRGBImage(int n, int n2, int n3, DataBuffer dataBuffer) {
        WritableRaster writableRaster;
        ComponentColorModel componentColorModel = ImageFactory.getSRGBColorModel(n3);
        PixelInterleavedSampleModel pixelInterleavedSampleModel = ImageFactory.getRGBSampleModel(n, n2, n3);
        if (dataBuffer == null || pixelInterleavedSampleModel == null) {
            throw new NullPointerException();
        }
        try {
            writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBuffer, new Point(0, 0));
        }
        catch (NullPointerException nullPointerException) {
            throw new OutOfMemoryError(ImviewResourceBundle.getString("error.outOfMemory"));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError(ImviewResourceBundle.getString("error.outOfMemory"));
        }
        return new BufferedImage(componentColorModel, writableRaster, false, new Hashtable());
    }

    private static ComponentColorModel getSRGBColorModel(int n) {
        int n2 = ImageFactory.getImageDepth(n);
        int[] nArray = new int[3];
        int n3 = 0;
        while (n3 < 3) {
            nArray[n3] = n2;
            ++n3;
        }
        return new ComponentColorModel(ColorSpace.getInstance(1000), nArray, false, false, 1, n);
    }

    private static PixelInterleavedSampleModel getRGBSampleModel(int n, int n2, int n3) {
        int[] nArray = new int[3];
        int n4 = 0;
        while (n4 < 3) {
            nArray[n4] = n4;
            ++n4;
        }
        return new PixelInterleavedSampleModel(n3, n, n2, 3, n * 3, nArray);
    }

    private static int getImageDepth(int n) {
        int n2 = 8;
        if (n == 0) {
            n2 = 8;
        } else if (n == 1) {
            n2 = 16;
        } else if (n == 3) {
            n2 = 32;
        } else {
            System.err.println("Unknown image depth.");
        }
        return n2;
    }

    public static BufferedImage createIndexedImage(int n, int n2, byte[] byArray, int n3, byte[] byArray2) {
        WritableRaster writableRaster;
        int n4 = 0;
        int n5 = ImageFactory.getImageDepth(n4);
        IndexColorModel indexColorModel = new IndexColorModel(n5, n3, byArray2, 0, false);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n);
        if (dataBufferByte == null) {
            throw new NullPointerException();
        }
        try {
            writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n5, new Point(0, 0));
        }
        catch (NullPointerException nullPointerException) {
            throw new OutOfMemoryError(ImviewResourceBundle.getString("error.outOfMemory"));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError(ImviewResourceBundle.getString("error.outOfMemory"));
        }
        return new BufferedImage(indexColorModel, writableRaster, false, new Hashtable());
    }

    public static BufferedImage createIndexedImage(int n, int n2, short[] sArray, int n3, byte[] byArray) {
        int n4 = 1;
        int n5 = ImageFactory.getImageDepth(n4);
        IndexColorModel indexColorModel = new IndexColorModel(n5, n3, byArray, 0, false);
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n);
        return ImageFactory.createIndexedImage(n, n2, n4, dataBufferUShort, indexColorModel);
    }

    private static BufferedImage createIndexedImage(int n, int n2, int n3, DataBuffer dataBuffer, IndexColorModel indexColorModel) {
        WritableRaster writableRaster;
        if (dataBuffer == null) {
            throw new NullPointerException();
        }
        int n4 = ImageFactory.getImageDepth(n3);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(n3, n, n2, n4);
        try {
            writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, dataBuffer, new Point(0, 0));
        }
        catch (NullPointerException nullPointerException) {
            throw new OutOfMemoryError(ImviewResourceBundle.getString("error.outOfMemory"));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError(ImviewResourceBundle.getString("error.outOfMemory"));
        }
        return new BufferedImage(indexColorModel, writableRaster, false, new Hashtable());
    }

    public static BufferedImage createSameTypeBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = null;
        if (n > 0 && n2 > 0) {
            bufferedImage2 = bufferedImage.getSampleModel().getNumBands() == 1 ? ImageFactory.createSingleBandSameTypeBufferedImage(bufferedImage, n, n2) : ImageFactory.createRGBSameTypeBufferedImage(bufferedImage, n, n2);
        }
        return bufferedImage2;
    }

    private static BufferedImage createSingleBandSameTypeBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        DataBuffer dataBuffer;
        Object object;
        int n3 = bufferedImage.getRaster().getTransferType();
        if (n3 == 0) {
            object = new byte[n * n2];
            dataBuffer = new DataBufferByte((byte[])object, n);
        } else {
            object = new short[n * n2];
            dataBuffer = new DataBufferUShort((short[])object, n);
        }
        object = new MultiPixelPackedSampleModel(n3, n, n2, ImageFactory.getImageDepth(n3));
        WritableRaster writableRaster = Raster.createWritableRaster((SampleModel)object, dataBuffer, new Point(0, 0));
        return new BufferedImage(bufferedImage.getColorModel(), writableRaster, false, new Hashtable());
    }

    private static BufferedImage createRGBSameTypeBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = null;
        int n3 = bufferedImage.getRaster().getTransferType();
        int n4 = bufferedImage.getRaster().getNumBands();
        if (n3 == 0) {
            byte[] byArray = new byte[n * n2 * n4];
            bufferedImage2 = ImageFactory.createInterleavedRGBImage(n, n2, byArray);
        } else {
            short[] sArray = new short[n * n2 * n4];
            bufferedImage2 = ImageFactory.createInterleavedRGBImage(n, n2, sArray);
        }
        return bufferedImage2;
    }
}

