/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images.cpselect;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwt.MWTwoColumnLayout;
import com.mathworks.toolbox.images.MagnificationComboBox;
import com.mathworks.toolbox.images.MagnificationComboBoxListener;
import com.mathworks.toolbox.images.cpselect.CPScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InputBasePanel
extends MJPanel {
    private CPScrollPane fInputScrollPane;
    private CPScrollPane fBaseScrollPane;
    private MagnificationComboBox fInputMagBox;
    private MagnificationComboBox fBaseMagBox;
    private String fInputLabelString;
    private String fBaseLabelString;
    private String fScopeString;
    private MJLabel fInputLabel;
    private MJLabel fBaseLabel;
    private double fInputOverBaseMagnification;
    private MJCheckBox fLinkCheckBox;
    private static ResourceBundle fCPBundle = ResourceBundle.getBundle("com.mathworks.toolbox.images.resources.RES_CPSelect");

    public InputBasePanel(JComponent jComponent, JComponent jComponent2, String string) {
        MJPanel mJPanel = new MJPanel();
        MJPanel mJPanel2 = new MJPanel();
        MJPanel mJPanel3 = new MJPanel();
        MJPanel mJPanel4 = new MJPanel();
        this.fScopeString = string;
        this.fInputLabel = new MJLabel();
        this.fBaseLabel = new MJLabel();
        this.fInputMagBox = new MagnificationComboBox();
        this.fBaseMagBox = new MagnificationComboBox();
        this.fInputMagBox.setName("Input Mag Box");
        this.fBaseMagBox.setName("Base Mag Box");
        this.fLinkCheckBox = new MJCheckBox(fCPBundle.getString("checkbox.lock_ratio"));
        this.fLinkCheckBox.setName("Link Check Box");
        MJPanel mJPanel5 = new MJPanel();
        mJPanel5.setLayout((LayoutManager)new BoxLayout((Container)mJPanel5, 0));
        Dimension dimension = this.fLinkCheckBox.getPreferredSize();
        dimension.width += 4;
        mJPanel5.setPreferredSize(dimension);
        mJPanel5.setBorder(BorderFactory.createEtchedBorder());
        mJPanel5.add((Component)this.fLinkCheckBox);
        this.fLinkCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    InputBasePanel.this.fInputOverBaseMagnification = InputBasePanel.this.getInputMagBox().getMag() / InputBasePanel.this.getBaseMagBox().getMag();
                }
            }
        });
        this.setInputScrollPane(new CPScrollPane(jComponent, null, this.getInputMagBox()));
        this.setBaseScrollPane(new CPScrollPane(jComponent2, null, this.getBaseMagBox()));
        MagChangeListener magChangeListener = new MagChangeListener();
        this.getInputScrollPane().addMagChangeListener(magChangeListener);
        this.getBaseScrollPane().addMagChangeListener(magChangeListener);
        this.getInputScrollPane().setBorder(new EmptyBorder(0, 0, 0, 3));
        this.getBaseScrollPane().setBorder(new EmptyBorder(0, 3, 0, 0));
        MatteBorder matteBorder = BorderFactory.createMatteBorder(3, 0, 0, 0, Color.black);
        Border border = BorderFactory.createEmptyBorder(2, 0, 0, 0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(matteBorder, border);
        CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(border, compoundBorder);
        this.setBorder(compoundBorder2);
        this.setLayout(new BorderLayout());
        mJPanel.setLayout((LayoutManager)new MWTwoColumnLayout());
        mJPanel2.setLayout((LayoutManager)new GridLayout(1, 2));
        mJPanel3.setLayout((LayoutManager)new BorderLayout());
        mJPanel4.setLayout((LayoutManager)new BorderLayout());
        mJPanel.setBorder((Border)new EmptyBorder(0, 20, 0, 20));
        mJPanel3.add((Component)((Object)this.fInputMagBox), (Object)"East");
        mJPanel3.add((Component)this.fInputLabel, (Object)"West");
        mJPanel4.add((Component)((Object)this.fBaseMagBox), (Object)"West");
        mJPanel4.add((Component)this.fBaseLabel, (Object)"East");
        mJPanel.add((Component)mJPanel5, (Object)"Center");
        mJPanel.add((Component)mJPanel3, (Object)"West");
        mJPanel.add((Component)mJPanel4, (Object)"East");
        mJPanel2.add((Component)((Object)this.getInputScrollPane()));
        mJPanel2.add((Component)((Object)this.getBaseScrollPane()));
        this.add((Component)mJPanel2, "Center");
        this.add((Component)mJPanel, "North");
        this.getInputMagBox().addActionListener(new MagnificationComboBoxListener(this.getInputScrollPane()));
        this.getBaseMagBox().addActionListener(new MagnificationComboBoxListener(this.getBaseScrollPane()));
    }

    private void setInputOverBaseMagnification(double d) {
        this.fInputOverBaseMagnification = d;
    }

    public double getInputOverBaseMagnification() {
        return this.fInputOverBaseMagnification;
    }

    private void setInputScrollPane(CPScrollPane cPScrollPane) {
        this.fInputScrollPane = cPScrollPane;
        this.fInputScrollPane.setName("Input ScrollPane");
    }

    public CPScrollPane getInputScrollPane() {
        return this.fInputScrollPane;
    }

    private void setBaseScrollPane(CPScrollPane cPScrollPane) {
        this.fBaseScrollPane = cPScrollPane;
        this.fBaseScrollPane.setName("Base ScrollPane");
    }

    public CPScrollPane getBaseScrollPane() {
        return this.fBaseScrollPane;
    }

    public MagnificationComboBox getInputMagBox() {
        return this.fInputMagBox;
    }

    public MagnificationComboBox getBaseMagBox() {
        return this.fBaseMagBox;
    }

    public double getInputMagBoxMag() {
        return this.getInputMagBox().getMag();
    }

    public double getBaseMagBoxMag() {
        return this.getBaseMagBox().getMag();
    }

    public MJCheckBox getLinkCheckBox() {
        return this.fLinkCheckBox;
    }

    public void setInputImage(BufferedImage bufferedImage) {
        this.getInputScrollPane().setBufImage(bufferedImage);
    }

    public void setBaseImage(BufferedImage bufferedImage) {
        this.getBaseScrollPane().setBufImage(bufferedImage);
    }

    public double getInputScreenPerImagePixel() {
        return this.getInputScrollPane().getScreenPerImagePixel();
    }

    public double getBaseScreenPerImagePixel() {
        return this.getBaseScrollPane().getScreenPerImagePixel();
    }

    public void setInputLabelString(String string) {
        this.fInputLabelString = fCPBundle.getString("label.input") + " " + this.fScopeString + ": " + string;
        this.fInputLabel.setText(this.fInputLabelString);
        this.fInputLabel.setToolTipText(this.fInputLabelString);
    }

    public void setBaseLabelString(String string) {
        this.fBaseLabelString = fCPBundle.getString("label.base") + " " + this.fScopeString + ": " + string;
        this.fBaseLabel.setText(this.fBaseLabelString);
        this.fBaseLabel.setToolTipText(this.fBaseLabelString);
    }

    public String getInputLabelString() {
        return this.fInputLabelString;
    }

    public String getBaseLabelString() {
        return this.fBaseLabelString;
    }

    void initializeView(int n) {
        this.getInputScrollPane().initializeView(n);
        this.getBaseScrollPane().initializeView(n);
    }

    class MagChangeListener
    implements ChangeListener {
        MagChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (InputBasePanel.this.fLinkCheckBox.isSelected()) {
                double d;
                MagnificationComboBox magnificationComboBox;
                CPScrollPane cPScrollPane;
                CPScrollPane cPScrollPane2 = (CPScrollPane)((Object)changeEvent.getSource());
                if (((Object)((Object)cPScrollPane2)).equals((Object)InputBasePanel.this.getInputScrollPane())) {
                    cPScrollPane = InputBasePanel.this.getBaseScrollPane();
                    magnificationComboBox = InputBasePanel.this.getBaseMagBox();
                    d = InputBasePanel.this.getInputMagBox().getMag() / InputBasePanel.this.getInputOverBaseMagnification();
                } else {
                    cPScrollPane = InputBasePanel.this.getInputScrollPane();
                    magnificationComboBox = InputBasePanel.this.getInputMagBox();
                    d = InputBasePanel.this.getBaseMagBox().getMag() * InputBasePanel.this.getInputOverBaseMagnification();
                }
                cPScrollPane.updateView(d, (ChangeListener)this);
                magnificationComboBox.setMag(d);
            }
        }
    }
}

