/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images.cpselect;

import com.mathworks.toolbox.images.AbstractModeHandler;
import com.mathworks.toolbox.images.ImagePanel;
import com.mathworks.toolbox.images.ImageScrollPane;
import com.mathworks.toolbox.images.cpselect.CPScrollPane;
import com.mathworks.toolbox.images.cpselect.ControlPoint;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class CPDefaultModeHandler
extends AbstractModeHandler {
    private ControlPoint fTarget = null;
    private ActionListener fChangeActivePairActionListener = null;

    public CPDefaultModeHandler(ImageScrollPane imageScrollPane) {
        super(imageScrollPane);
    }

    void setChangeActivePairActionListener(ActionListener actionListener) {
        this.fChangeActivePairActionListener = actionListener;
    }

    ActionListener getChangeActivePairActionListener() {
        return this.fChangeActivePairActionListener;
    }

    void setTarget(ControlPoint controlPoint) {
        this.fTarget = controlPoint;
        this.getCPScrollPane().getCPKeyHandler().setTarget(controlPoint);
    }

    ControlPoint getTarget() {
        return this.fTarget;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        ImagePanel imagePanel = this.getScrollPane().getImPanel();
        Point2D point2D = imagePanel.toImageCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.setTarget(this.hit(mouseEvent.getX(), mouseEvent.getY()));
        this.getScrollPane().getImPanel().requestFocus();
        if (this.fTarget != null && this.fChangeActivePairActionListener != null) {
            this.fChangeActivePairActionListener.actionPerformed(new ActionEvent(this.fTarget.getPair(), 0, "change_active_pair"));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        ImagePanel imagePanel = this.getScrollPane().getImPanel();
        Point2D point2D = imagePanel.toImageCoordinates(mouseEvent.getX(), mouseEvent.getY());
        if (this.getTarget() != null) {
            this.getTarget().dragPoint(point2D.getX(), point2D.getY(), this.getCPScrollPane());
            this.getCPScrollPane().firePairsChangeListener();
        }
    }

    private ControlPoint hit(double d, double d2) {
        int n = 0;
        while (n < this.getCPScrollPane().getPoints().size()) {
            ControlPoint controlPoint = this.getCPScrollPane().getPoint(n);
            Point point = this.getCPScrollPane().getCPPanel().toScreenCoordinates(controlPoint);
            ControlPoint controlPoint2 = new ControlPoint(point.x, point.y);
            if (controlPoint2.hit(d, d2)) {
                return controlPoint;
            }
            ++n;
        }
        return null;
    }

    CPScrollPane getCPScrollPane() {
        return (CPScrollPane)this.getScrollPane();
    }

    public void setCursor() {
        this.getScrollPane().getClient().setCursor(Cursor.getDefaultCursor());
    }
}

