/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;

public class MagnificationComboBox
extends MJComboBox {
    private double[] fScreenPerImagePixelArray = new double[]{Double.NaN, 0.33, 0.5, 0.67, 1.0, 2.0, 4.0, 8.0};
    private double fMag;
    private double fMinAllowableMag = 1.0E-10;

    public MagnificationComboBox() {
        int n = 0;
        while (n < this.fScreenPerImagePixelArray.length) {
            String string = MagnificationComboBox.toPercentString(this.fScreenPerImagePixelArray[n]);
            this.addItem(string);
            ++n;
        }
        this.getEditor().getEditorComponent().setCursor(Cursor.getPredefinedCursor(2));
        this.setEditable(true);
    }

    public MagnificationComboBox(double d) {
        this();
        this.setMinAllowableMag(d);
    }

    public void setMinAllowableMag(double d) {
        this.fMinAllowableMag = d;
    }

    private double getMinAllowableMag() {
        return this.fMinAllowableMag;
    }

    double findMinAllowableMag(double d) {
        return Math.max(d, this.getMinAllowableMag());
    }

    public double getSelectedScreenPerImagePixel(int n) {
        return this.fScreenPerImagePixelArray[n];
    }

    public void setMag(double d) {
        this.fMag = d;
        this.updateString(d);
        int n = -1;
        int n2 = 1;
        while (n2 < this.fScreenPerImagePixelArray.length) {
            if (this.fMag == this.fScreenPerImagePixelArray[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        this.setSelectedIndex(n);
    }

    public double getMag() {
        return this.fMag;
    }

    private void updateString(double d) {
        this.getEditor().setItem(MagnificationComboBox.toPercentString(d));
    }

    public void updateString() {
        this.updateString(this.getMag());
    }

    private static String toPercentString(double d) {
        double d2;
        double d3;
        String string = Double.isNaN(d) ? "Fit to window" : ((d3 = (double)Math.round(d2 = MagnificationComboBox.toPercent(d))) == d2 ? (int)d2 + "%" : (d3 >= 10.0 ? (int)d3 + "%" : (d3 >= 1.0 ? d2 + "%" : d2 + "%")));
        return string;
    }

    public static double toPercent(double d) {
        double d2 = d * 100.0;
        double d3 = Math.round(d2);
        if (d3 != d2) {
            if (d3 >= 10.0) {
                d2 = d3;
            } else if (d3 >= 1.0) {
                double d4 = 100.0;
                d2 = (double)Math.round(d2 * d4) / d4;
            } else {
                double d5 = 1000.0;
                d2 = (double)Math.round(d2 * d5) / d5;
            }
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        MJFrame mJFrame = new MJFrame();
        Container container = mJFrame.getContentPane();
        container.setLayout(new FlowLayout());
        double d = 0.1;
        MagnificationComboBox magnificationComboBox = new MagnificationComboBox(d);
        MJCheckBox mJCheckBox = new MJCheckBox("Link");
        MagnificationComboBox magnificationComboBox2 = new MagnificationComboBox(d);
        container.add((Component)((Object)magnificationComboBox));
        container.add((Component)mJCheckBox);
        container.add((Component)((Object)magnificationComboBox2));
        mJFrame.pack();
        mJFrame.show();
    }

    public double findMagnification() {
        double d;
        block5: {
            String string = (String)this.getEditor().getItem();
            try {
                d = Math.abs(Double.valueOf(string)) / 100.0;
            }
            catch (NumberFormatException numberFormatException) {
                if (string.endsWith("%")) {
                    try {
                        int n = string.length();
                        String string2 = string.substring(0, n - 1);
                        d = Double.valueOf(string2);
                        d = Math.abs(d) / 100.0;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        d = this.getMag();
                    }
                    break block5;
                }
                d = this.getMag();
            }
        }
        return this.findMinAllowableMag(d);
    }
}

