/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.images.AbstractModeHandler;
import com.mathworks.toolbox.images.DefaultModeHandler;
import com.mathworks.toolbox.images.ImagePanel;
import com.mathworks.toolbox.images.MagnificationComboBox;
import com.mathworks.toolbox.images.PanModeHandler;
import com.mathworks.toolbox.images.ZoomInModeHandler;
import com.mathworks.toolbox.images.ZoomOutModeHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageScrollPane
extends MJScrollPane {
    public static final int DEFAULT_MODE = 0;
    public static final int ZOOM_IN_MODE = 1;
    public static final int ZOOM_OUT_MODE = 2;
    public static final int PAN_MODE = 3;
    private int fMode;
    private AbstractModeHandler fCurrentModeHandler;
    private final AbstractModeHandler fDefaultModeHandler = new DefaultModeHandler(this);
    private final AbstractModeHandler fPanModeHandler = new PanModeHandler(this);
    private final AbstractModeHandler fZoomInModeHandler = new ZoomInModeHandler(this);
    private final AbstractModeHandler fZoomOutModeHandler = new ZoomOutModeHandler(this);
    private static ResourceBundle fCPBundle = ResourceBundle.getBundle("com.mathworks.toolbox.images.resources.RES_CPSelect");
    private boolean fTriggeredByScrollPaneStateChange = false;
    private MagnificationComboBox fMagComboBox;
    private ChangeListener fOverviewChangeListener = null;

    public ImageScrollPane(JComponent jComponent, MagnificationComboBox magnificationComboBox) {
        super((Component)jComponent, 22, 32);
        this.getImPanel().setImScrollPane(this);
        this.setMagComboBox(magnificationComboBox);
        this.setViewportBorder(BorderFactory.createEtchedBorder());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ImageScrollPane.this.updateView();
            }
        });
    }

    public ImageScrollPane(JComponent jComponent, BufferedImage bufferedImage, MagnificationComboBox magnificationComboBox) {
        this(jComponent, magnificationComboBox);
        if (bufferedImage != null) {
            this.setBufImage(bufferedImage);
        }
    }

    public ImageScrollPane(BufferedImage bufferedImage, MagnificationComboBox magnificationComboBox) {
        this((JComponent)((Object)new ImagePanel()), bufferedImage, magnificationComboBox);
    }

    public void setBufImage(BufferedImage bufferedImage) {
        this.getImPanel().setBufImage(bufferedImage);
    }

    private void setMagComboBox(MagnificationComboBox magnificationComboBox) {
        this.fMagComboBox = magnificationComboBox;
    }

    MagnificationComboBox getMagComboBox() {
        return this.fMagComboBox;
    }

    int getMode() {
        return this.fMode;
    }

    public void setCurrentModeHandler(AbstractModeHandler abstractModeHandler) {
        this.removeCurrentModeHandler();
        this.fCurrentModeHandler = abstractModeHandler;
        abstractModeHandler.setCursor();
        this.getImPanel().addMouseListener(abstractModeHandler);
        this.getImPanel().addMouseMotionListener(abstractModeHandler);
    }

    public void removeCurrentModeHandler() {
        this.getImPanel().removeMouseListener(this.getCurrentModeHandler());
        this.getImPanel().removeMouseMotionListener(this.getCurrentModeHandler());
    }

    private AbstractModeHandler getCurrentModeHandler() {
        return this.fCurrentModeHandler;
    }

    public void makeDefaultModeCurrent() {
        this.setCurrentModeHandler(this.fDefaultModeHandler);
    }

    public void makePanModeCurrent() {
        this.setCurrentModeHandler(this.fPanModeHandler);
    }

    public void makeZoomInModeCurrent() {
        this.setCurrentModeHandler(this.fZoomInModeHandler);
    }

    public void makeZoomOutModeCurrent() {
        this.setCurrentModeHandler(this.fZoomOutModeHandler);
    }

    public void initializeView(int n) {
        double d = (double)n * this.findFitMag();
        Point2D.Double double_ = new Point2D.Double((double)this.getImPanel().getImageWidth() / 2.0, (double)this.getImPanel().getImageHeight() / 2.0);
        this.updateView((Point2D)double_, d);
        if (this.getMagComboBox() != null) {
            this.getMagComboBox().setMag(d);
        }
    }

    void updateScrollBars() {
        JScrollBar jScrollBar;
        Dimension dimension = this.getViewport().getExtentSize();
        Dimension dimension2 = this.getViewport().getViewSize();
        Point point = this.getImPanel().getLocation();
        JScrollBar jScrollBar2 = this.getVerticalScrollBar();
        if (jScrollBar2 != null) {
            jScrollBar2.setValues(-point.y, dimension.height, 0, dimension2.height);
        }
        if ((jScrollBar = this.getHorizontalScrollBar()) != null) {
            jScrollBar.setValues(-point.x, dimension.width, 0, dimension2.width);
        }
    }

    public void updateView(Point2D point2D, double d) {
        Dimension dimension = this.getViewport().getExtentSize();
        this.getImPanel().setImageAndScreenRects(point2D, d, dimension);
        this.updateScrollBars();
        this.getImPanel().revalidate();
        this.getImPanel().repaint();
        if (this.getOverviewChangeListener() != null && !this.isTriggeredByScrollPaneStateChange()) {
            this.getOverviewChangeListener().stateChanged(new ChangeEvent((Object)this));
        } else {
            this.setTriggeredByScrollPaneStateChange(false);
        }
    }

    void updateView(Point2D point2D) {
        this.updateView(point2D, this.getImPanel().getScreenPerImagePixel());
    }

    public void updateView(double d) {
        this.updateView(this.getImPanel().getVisibleCenterInImageCoords(), d);
    }

    public void updateView(Point point, double d) {
        this.updateView((Point2D)new Point2D.Double(point.x, point.y), d);
    }

    void updateView() {
        this.updateView(this.getImPanel().getVisibleCenterInImageCoords(), this.getImPanel().getScreenPerImagePixel());
    }

    public void updateView(Point2D point2D, ChangeListener changeListener) {
        this.updateView(point2D, this.getImPanel().getScreenPerImagePixel());
    }

    void fireStateChanged() {
        if (this.getOverviewChangeListener() != null) {
            this.getOverviewChangeListener().stateChanged(new ChangeEvent((Object)this));
        }
    }

    public double getScreenPerImagePixel() {
        return this.getImPanel().getScreenPerImagePixel();
    }

    double findFitMag() {
        int n = this.getImPanel().getImageWidth();
        int n2 = this.getImPanel().getImageHeight();
        double d = this.findScreenPerImagePixel(n, n2);
        return this.getMagComboBox().findMinAllowableMag(d);
    }

    double findScreenPerImagePixel(double d, double d2) {
        Dimension dimension = this.getViewport().getExtentSize();
        double d3 = (double)dimension.width / d;
        double d4 = (double)dimension.height / d2;
        double d5 = Math.min(d3, d4);
        return d5;
    }

    public void addOverviewChangeListener(ChangeListener changeListener) {
        this.fOverviewChangeListener = changeListener;
    }

    public void removeOverviewChangeListener() {
        this.fOverviewChangeListener = null;
    }

    public ChangeListener getOverviewChangeListener() {
        return this.fOverviewChangeListener;
    }

    public boolean isTriggeredByScrollPaneStateChange() {
        return this.fTriggeredByScrollPaneStateChange;
    }

    public void setTriggeredByScrollPaneStateChange(boolean bl) {
        this.fTriggeredByScrollPaneStateChange = bl;
    }

    public Component getClient() {
        return this.getViewport().getView();
    }

    public ImagePanel getImPanel() {
        return (ImagePanel)((Object)this.getViewport().getView());
    }
}

