/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import com.mathworks.toolbox.images.ContextRect;
import com.mathworks.toolbox.images.ImagePanel;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class ContextRectMouseListener
extends MouseAdapter
implements MouseMotionListener {
    private ImagePanel fImagePanel = null;
    private Point fPressScreen = null;
    private boolean fInitialPressInsideContextRect = false;
    private Point2D fDragRectMin = null;
    private Point2D fDragRectMax = null;
    private Point fLastScreenOffset = new Point();
    private Point fLastTopLeft = null;
    private ContextRect fContextRect;

    public ContextRectMouseListener(ImagePanel imagePanel, ContextRect contextRect) {
        this.setImagePanel(imagePanel);
        this.setContextRect(contextRect);
    }

    public boolean isInitialPressInsideContextRect() {
        return this.fInitialPressInsideContextRect;
    }

    private void setInitialPressInsideContextRect(boolean bl) {
        this.fInitialPressInsideContextRect = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fPressScreen = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.setInitialPressInsideContextRect(this.isRectHit(this.fPressScreen));
        if (this.isInitialPressInsideContextRect()) {
            this.storeStateToDragContextRect();
        }
    }

    private void storeStateToDragContextRect() {
        Rectangle2D rectangle2D = this.getImagePanel().getImageRect();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        this.fDragRectMin = new Point2D.Double(d, d2);
        ContextRect contextRect = this.getContextRect();
        double d5 = ((RectangularShape)contextRect).getWidth();
        double d6 = ((RectangularShape)contextRect).getHeight();
        this.fDragRectMax = new Point2D.Double(d + d3 - d5, d2 + d4 - d6);
        Rectangle rectangle = this.getContextRect().getScreenRect();
        this.fLastTopLeft = new Point((int)Math.round(rectangle.getX()), (int)Math.round(rectangle.getY()));
        this.fLastScreenOffset = new Point(0, 0);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isRectHit(new Point(mouseEvent.getX(), mouseEvent.getY()))) {
            this.getImagePanel().setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.getImagePanel().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isInitialPressInsideContextRect()) {
            this.dragContextRect(new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
    }

    private void dragContextRect(Point point) {
        int n = point.x - this.fPressScreen.x;
        int n2 = point.y - this.fPressScreen.y;
        if (n != this.fLastScreenOffset.x || n2 != this.fLastScreenOffset.y) {
            int n3 = this.fLastTopLeft.x + n;
            int n4 = this.fLastTopLeft.y + n2;
            Point2D point2D = this.getImagePanel().toImageCoordinates(n3, n4);
            point2D.setLocation(Math.max(this.fDragRectMin.getX(), Math.min(point2D.getX(), this.fDragRectMax.getX())), Math.max(this.fDragRectMin.getY(), Math.min(point2D.getY(), this.fDragRectMax.getY())));
            this.getContextRect().setRect(point2D.getX(), point2D.getY(), this.getContextRect().getWidth(), this.getContextRect().getHeight());
            this.getImagePanel().repaint();
            this.fLastScreenOffset.x = n;
            this.fLastScreenOffset.y = n2;
        }
    }

    abstract boolean isRectHit(Point2D var1);

    private void setImagePanel(ImagePanel imagePanel) {
        this.fImagePanel = imagePanel;
    }

    private ImagePanel getImagePanel() {
        return this.fImagePanel;
    }

    private void setContextRect(ContextRect contextRect) {
        this.fContextRect = contextRect;
    }

    protected ContextRect getContextRect() {
        return this.fContextRect;
    }
}

