/*******************************************************************************

Copyright Datapath Ltd. 2010, 2014

File:    RGBERROR.H

Purpose: Definitions of RGB errors.


History:
         18 JAN 08    SB   Created.
         28 OCT 10    TM   Added error codes for rotation.
         08 MAR 12    JW   Added error code for invalid window handle.
         17 JUL 14    TM   Added error codes to support the offline editor.
         17 JUN 14    SB   Added error code for LiveStream.

*******************************************************************************/

#define RGBERROR_BASE 0x10000

typedef enum tagRGBERROR
{
   RGBERROR_NO_ERROR                           = 0,
   RGBERROR_DRIVER_NOT_FOUND                   =( RGBERROR_BASE + 0x0000 ),
   RGBERROR_UNABLE_TO_LOAD_DRIVER              =( RGBERROR_BASE + 0x0001 ),
   RGBERROR_HARDWARE_NOT_FOUND                 =( RGBERROR_BASE + 0x0002 ),
   RGBERROR_INVALID_INDEX                      =( RGBERROR_BASE + 0x0003 ),
   RGBERROR_DEVICE_IN_USE                      =( RGBERROR_BASE + 0x0004 ),
   RGBERROR_INVALID_HRGBCAPTURE                =( RGBERROR_BASE + 0x0005 ),
   RGBERROR_INVALID_POINTER                    =( RGBERROR_BASE + 0x0006 ),
   RGBERROR_INVALID_SIZE                       =( RGBERROR_BASE + 0x0007 ),
   RGBERROR_INVALID_FLAGS                      =( RGBERROR_BASE + 0x0008 ),
   RGBERROR_INVALID_DEVICE                     =( RGBERROR_BASE + 0x0009 ),
   RGBERROR_INVALID_INPUT                      =( RGBERROR_BASE + 0x000A ),
   RGBERROR_INVALID_FORMAT                     =( RGBERROR_BASE + 0x000D ),
   RGBERROR_INVALID_VDIF_CLOCKS                =( RGBERROR_BASE + 0x000E ),
   RGBERROR_INVALID_PHASE                      =( RGBERROR_BASE + 0x0011 ),
   RGBERROR_INVALID_BRIGHTNESS                 =( RGBERROR_BASE + 0x0013 ),
   RGBERROR_INVALID_CONTRAST                   =( RGBERROR_BASE + 0x0014 ),
   RGBERROR_INVALID_BLACKLEVEL                 =( RGBERROR_BASE + 0x0015 ),
   RGBERROR_INVALID_SAMPLERATE                 =( RGBERROR_BASE + 0x0016 ),
   RGBERROR_INVALID_PIXEL_FORMAT               =( RGBERROR_BASE + 0x0017 ),
   RGBERROR_INVALID_HWND                       =( RGBERROR_BASE + 0x0018 ),
   RGBERROR_INSUFFICIENT_RESOURCES             =( RGBERROR_BASE + 0x0019 ),
   RGBERROR_INSUFFICIENT_BUFFERS               =( RGBERROR_BASE + 0x001A ),
   RGBERROR_INSUFFICIENT_MEMORY                =( RGBERROR_BASE + 0x001B ),
   RGBERROR_SIGNAL_NOT_DETECTED                =( RGBERROR_BASE + 0x001C ),
   RGBERROR_INVALID_SYNCEDGE                   =( RGBERROR_BASE + 0x001D ),
   RGBERROR_OLD_FIRMWARE                       =( RGBERROR_BASE + 0x001E ),
   RGBERROR_HWND_AND_FRAMECAPTUREDFN           =( RGBERROR_BASE + 0x001F ),
   RGBERROR_HSCALED_OUT_OF_RANGE               =( RGBERROR_BASE + 0x0020 ),
   RGBERROR_VSCALED_OUT_OF_RANGE               =( RGBERROR_BASE + 0x0021 ),
   RGBERROR_SCALING_NOT_SUPPORTED              =( RGBERROR_BASE + 0x0022 ),
   RGBERROR_BUFFER_TOO_SMALL                   =( RGBERROR_BASE + 0x0023 ),
   RGBERROR_HSCALE_NOT_WORD_DIVISIBLE          =( RGBERROR_BASE + 0x0024 ),
   RGBERROR_HSCALE_NOT_DWORD_DIVISIBLE         =( RGBERROR_BASE + 0x0025 ),
   RGBERROR_HORADDRTIME_NOT_WORD_DIVISIBLE     =( RGBERROR_BASE + 0x0026 ),
   RGBERROR_HORADDRTIME_NOT_DWORD_DIVISIBLE    =( RGBERROR_BASE + 0x0027 ),
   RGBERROR_VERSION_MISMATCH                   =( RGBERROR_BASE + 0x0028 ),
   RGBERROR_ACC_REALLOCATE_BUFFERS             =( RGBERROR_BASE + 0x0029 ),
   RGBERROR_BUFFER_NOT_VALID                   =( RGBERROR_BASE + 0x002A ),
   RGBERROR_BUFFERS_STILL_ALLOCATED            =( RGBERROR_BASE + 0x002B ),
   RGBERROR_NO_NOTIFICATION_SET                =( RGBERROR_BASE + 0x002C ),
   RGBERROR_CAPTURE_DISABLED                   =( RGBERROR_BASE + 0x002D ),
   RGBERROR_INVALID_PIXELFORMAT                =( RGBERROR_BASE + 0x002E ),
   RGBERROR_ILLEGAL_CALL                       =( RGBERROR_BASE + 0x002F ),
   RGBERROR_CAPTURE_OUTSTANDING                =( RGBERROR_BASE + 0x0030 ),
   RGBERROR_MODE_NOT_FOUND                     =( RGBERROR_BASE + 0x0031 ),
   RGBERROR_CANNOT_DETECT                      =( RGBERROR_BASE + 0x0032 ),
   RGBERROR_NO_MODE_DATABASE                   =( RGBERROR_BASE + 0x0033 ),
   RGBERROR_CANT_DELETE_MODE                   =( RGBERROR_BASE + 0x0034 ),
   RGBERROR_MUTEX_FAILURE                      =( RGBERROR_BASE + 0x0035 ),
   RGBERROR_THREAD_FAILURE                     =( RGBERROR_BASE + 0x0036 ),
   RGBERROR_NO_COMPLETION                      =( RGBERROR_BASE + 0x0037 ),
   RGBERROR_INSUFFICIENT_RESOURCES_HALLOC      =( RGBERROR_BASE + 0x0038 ),
   RGBERROR_INSUFFICIENT_RESOURCES_RGBLIST     =( RGBERROR_BASE + 0x0039 ),
   RGBERROR_DEVICE_NOT_READY                   =( RGBERROR_BASE + 0x003a ),
   RGBERROR_HORADDRTIME_NOT_QWORD_DIVISIBLE    =( RGBERROR_BASE + 0x003b ),
   RGBERROR_HSCALE_NOT_QWORD_DIVISIBLE         =( RGBERROR_BASE + 0x003c ),
   RGBERROR_INVALID_AOI                        =( RGBERROR_BASE + 0x003d ),
   RGBCAPTURE_AOI_NOT_QWORD_ALIGNED            =( RGBERROR_BASE + 0x003d ),
   RGBCAPTURE_AOI_NOT_DWORD_ALIGNED            =( RGBERROR_BASE + 0x003e ),
   RGBERROR_INVALID_HTIMINGS                   =( RGBERROR_BASE + 0x003f ),
   RGBERROR_INVALID_PITCH                      =( RGBERROR_BASE + 0x0040 ),
   RGBERROR_INVALID_PIXELCOUNT                 =( RGBERROR_BASE + 0x0041 ),
   RGBERROR_FLASH_ONLY                         =( RGBERROR_BASE + 0x0042 ),
   RGBERROR_CPU_CODE_LOAD_FAILED               =( RGBERROR_BASE + 0x0043 ),
   RGBERROR_IRQ_LINE_FAILED                    =( RGBERROR_BASE + 0x0044 ),
   RGBERROR_CPU_CODE_LOAD_ERROR                =( RGBERROR_BASE + 0x0045 ),
   RGBERROR_CPU_STARTUP_UNSIGNALLED            =( RGBERROR_BASE + 0x0046 ),
   RGBERROR_HW_INTEGRITY_VIOLATION             =( RGBERROR_BASE + 0x0047 ),
   RGBERROR_MEMORY_TEST_FAILED                 =( RGBERROR_BASE + 0x0048 ),
   RGBERROR_PCI_BUS_FAILURE                    =( RGBERROR_BASE + 0x0049 ),
   RGBERROR_CPU_NO_HANDSHAKE                   =( RGBERROR_BASE + 0x004a ),
   RGBERROR_INVALID_VTIMINGS                   =( RGBERROR_BASE + 0x004b ),
   RGBERROR_INVALID_ENVIRONMENT                =( RGBERROR_BASE + 0x004c ),
   RGBERROR_FILE_NOT_FOUND                     =( RGBERROR_BASE + 0x004d ),
   RGBERROR_INVALID_GAIN                       =( RGBERROR_BASE + 0x004e ),
   RGBERROR_INVALID_OFFSET                     =( RGBERROR_BASE + 0x004f ),
   RGBERROR_CANT_ADJUST_DVI                    =( RGBERROR_BASE + 0x0050 ),
   RGBERROR_INCOMPATIBLE_INTERFACE             =( RGBERROR_BASE + 0x0051 ),
   RGBERROR_FLASH_INPROGRESS                   =( RGBERROR_BASE + 0x0052 ),
   RGBERROR_INVALID_SATURATION                 =( RGBERROR_BASE + 0x0053 ),
   RGBERROR_INVALID_HUE                        =( RGBERROR_BASE + 0x0054 ),
   RGBERROR_INVALID_VIDEOSTANDARD              =( RGBERROR_BASE + 0x0055 ),
   RGBERROR_INVALID_DEINTERLACE                =( RGBERROR_BASE + 0x0056 ),
   RGBERROR_ROTATION_NOT_SUPPORTED             =( RGBERROR_BASE + 0x0057 ),
   RGBERROR_INVALID_ROTATION_ANGLE             =( RGBERROR_BASE + 0x0058 ),
   RGBERROR_EDID_NOT_SUPPORTED                 =( RGBERROR_BASE + 0x0059 ),
   RGBERROR_INCOMPATIBLE_HARDWARE              =( RGBERROR_BASE + 0x005A ),
   RGBERROR_INVALID_EDID                       =( RGBERROR_BASE + 0x005C ),
   RGBERROR_EDID_VERIFY                        =( RGBERROR_BASE + 0x005D ),
   RGBERROR_EDID_I2C_STUCK                     =( RGBERROR_BASE + 0x005E ),
   RGBERROR_EDID_I2C_NOACK                     =( RGBERROR_BASE + 0x005F ),
   RGBERROR_INVALID_EQUALISATION               =( RGBERROR_BASE + 0x0060 ),
   RGBERROR_INTERNAL_DEVICE_ERROR              =( RGBERROR_BASE + 0x0061 ),
   RGBERROR_INVALID_HWINDOW                    =( RGBERROR_BASE + 0x0062 ),
   RGBERROR_NOACCESS                           =( RGBERROR_BASE + 0x0063 ),
   RGBERROR_NOT_INITIALISED                    =( RGBERROR_BASE + 0x0064 ),
   RGBERROR_INVALID_HANDLE                     =( RGBERROR_BASE + 0x0065 ),
   RGBERROR_NO_AUDIO_AVAILABLE                 =( RGBERROR_BASE + 0x0066 ),
   RGBERROR_ALREADY_ACTIVE                     =( RGBERROR_BASE + 0x0067 ),
   RGBERROR_DIFFERENT_GPUDESCRIPTOR            =( RGBERROR_BASE + 0x0068 ),
   RGBERROR_INVALID_COLOURDOMAIN               =( RGBERROR_BASE + 0x0069 ),
   RGBERROR_OFFLINE_LOAD_FAILURE               =( RGBERROR_BASE + 0x0070 ),
   RGBERROR_OFFLINE_LOAD_ABORTED               =( RGBERROR_BASE + 0x0071 ),
   RGBERROR_INVALID_LIVESTREAM                 =( RGBERROR_BASE + 0x0072 ),
   RGBERROR_INVALID_LINKRATE                   =( RGBERROR_BASE + 0x0073 ),
   RGBERROR_INVALID_STATE                      =( RGBERROR_BASE + 0x0074 ),
   RGBERROR_INPUT_UNAVAILABLE                  =( RGBERROR_BASE + 0x0075 ),
   RGBERROR_KEY_VERIFY_FAIL                    =( RGBERROR_BASE + 0x0076 ),
   RGBERROR_KEY_ALREADY_PRESENT                =( RGBERROR_BASE + 0x0077 ),
   RGBERROR_OVERLAY_UNSUPPORTED                =( RGBERROR_BASE + 0x0078 ),
   RGBERROR_OVERLAY_INVALID_TIMEOUT            =( RGBERROR_BASE + 0x0079 ),
   RGBERROR_GANGING_UNSUPPORTED                =( RGBERROR_BASE + 0x007a ),
   RGBERROR_GANGINGTYPE_UNSUPPORTED            =( RGBERROR_BASE + 0x007b ),
   RGBERROR_HDCP_NOT_SUPPORTED                 =( RGBERROR_BASE + 0x007c ),
   RGBERROR_INVALID_PIXEL_GAMUT                =( RGBERROR_BASE + 0x007d ),
   RGBERROR_INVALID_PIXEL_RANGE                =( RGBERROR_BASE + 0x007e ),
   RGBERROR_AUDIOCAPTURETYPE_NOT_ACTIVE        =( RGBERROR_BASE + 0x007f ),
   RGBERROR_AUDIOCAPTURETYPE_UNSUPPORTED       =( RGBERROR_BASE + 0x0080 ),
   RGBERROR_OVERLAY_INVALID_OFFSET             =( RGBERROR_BASE + 0x0081 ),
   RGBERROR_OUTPUT_UNSUPPORTED                 =( RGBERROR_BASE + 0x0082 ),
   RGBERROR_OUTPUT_NOTMAPPED                   =( RGBERROR_BASE + 0x0083 ),
   RGBERROR_OUTPUT_CONVERT_ASPECT_UNSUPPORTED  =( RGBERROR_BASE + 0x0084 ),
   RGBERROR_UPGRADE_INPROGRESS                 =( RGBERROR_BASE + 0x0085 ),
   RGBERROR_VSCALE_NOT_EVEN                    =( RGBERROR_BASE + 0x0086 ),
   RGBERROR_SIGNAL_OUT_OF_RANGE                =( RGBERROR_BASE + 0x0087 ),
}  RGBERROR;
