/*******************************************************************************

Copyright Datapath Ltd. 2009.

File:    VisionFilter.h

Purpose: 

History:
         31 JAN 09    RL   Created.
         26 APR 12    JL   Added support for User-Mode filters.

/* Macros *********************************************************************/

#define SAFE_RELEASE(x) { if (x) x->Release(); x = NULL; }

/* Declarations ***************************************************************/

#ifdef USER_MODE_STREAMING // Use User-mode streaming interfaces

HRESULT
LoadVisionInterface(
   IBaseFilter    *pSrcFilter,
   IVisionUser    **ppVisionUser);

HRESULT
LoadVisionGangingInterface(
   IBaseFilter    *pSrcFilter,
   IVisionUserGanging   **ppVisionGanging );

// Unsupported, do not use. Returns E_NOTIMPL.
HRESULT
LoadControlConfigInterface (
   void  *pSrcFilter,
   void  **ppControlConfig);

// Unsupported, do not use. Returns E_NOTIMPL.
HRESULT
LoadCrossbarInterface(
   void*  pCapGraph2,
   void*  pSrcFilter,
   void** ppCrossbar);

HRESULT
LoadVisionEventInterface(
    IBaseFilter*       pSrcFilter,
    IVisionUserEvent** ppVisionUserEvent);

// Calls LoadVisionEventInterface internally.
HRESULT
LoadVisionEventInterface2(
    IBaseFilter*       pSrcFilter,
    IVisionUserEvent** ppVisionUserEvent);

#else // Use Kernel streaming interfaces

HRESULT
LoadVisionInterface(
   IBaseFilter    *pSrcFilter,
   IVision        **ppVision);

HRESULT
LoadControlConfigInterface(
   IBaseFilter           *pSrcFilter,
   IDGC103ControlConfig  **ppControlConfig);

HRESULT
LoadCrossbarInterface(
   ICaptureGraphBuilder2*  pCapGraph2,
   IBaseFilter*            pSrcFilter,
   IAMCrossbar**           ppCrossbar);

HRESULT
LoadVisionEventInterface(
    IBaseFilter*   pSrcFilter,
    IVisionEvent** ppVisionEvent);

HRESULT
LoadVisionEventInterface2(
    IBaseFilter*    pSrcFilter,
    IVisionEvent2** ppVisionEvent);

#endif

HRESULT
FilterPropertiesDlg(
   HWND        hWnd,
   IBaseFilter *pSrcFilter);

/******************************************************************************/