/*******************************************************************************

Copyright Datapath Ltd. 2008, 2010.

File:    Sample2.h

Purpose: 

History:
         28 NOV 08    RL   Created.
         01 JUL 10    RL   Added RemoveGraphFilters.
                           Removed applications concept of graph state.
         10 AUG 10    RL   Use IVisionEvent2.
         26 APR 12    JL   Added support for User-Mode filters.

/* Macros *********************************************************************/

#define SAFE_RELEASE(x) { if (x) x->Release(); x = NULL; }

/* Constants ******************************************************************/

#define APPLICATIONNAME TEXT("DirectShow Vision Sample2\0")
#define CLASSNAME       TEXT("Sample2\0")
#define WM_GRAPHNOTIFY    WM_APP+1
#define WM_SIGNAL_CHANGED WM_APP+2

/* Global Variables ***********************************************************/

typedef struct
{
   HWND                    HWndApp;
  
   IVideoWindow            *PVideoWindow;
   IMediaEventEx           *PMediaEvent;
   IMediaControl           *PMediaControl;

   IGraphBuilder           *PGraphBuilder;
   ICaptureGraphBuilder2   *PCapture;

#ifdef USER_MODE_STREAMING
   IVisionUser             *PVision;
#ifdef DO_GANGING
   IVisionUserGanging      *PVisionGanging;
#endif
   IVisionUserEvent        *PVisionEvent2;
#else
   IVision                 *PVision;
   IVisionEvent2           *PVisionEvent2;
#endif

   CVisionCallBack         *PModeChangeCallBack;

   ULONG_PTR               PDeviceEventHandle;

   DWORD                   DWGraphRegister;

   ULONG                   InputWidth;
   ULONG                   InputHeight;

}  GLOBAL;

static GLOBAL Global = {0,};

/******************************************************************************/
