/*******************************************************************************

Copyright Datapath Ltd. 2009.

File:    CVisionCallBack.cpp

Purpose: Implementation of a callback class.

History: 30 MAR 09    RL   Created.
         26 APR 12    JL   Added support for User-Mode filters.

*******************************************************************************/

#include <streams.h>

#ifdef USER_MODE_STREAMING
#include "DGC133UM.h" // Use User-mode streaming interfaces
#else
#include "DGC133ST.h" // Use Kernel streaming interfaces
#endif

#include "CVisionCallBack.h"

/******************************************************************************/
/* Constructor */
CVisionCallBack::CVisionCallBack( PCALLBACKFN pCallBackFn ) :
   CUnknown("CVisionCallBack", NULL ),
   m_pCallBackFn ( pCallBackFn )
{
}

/******************************************************************************/
/* Destructor */
CVisionCallBack::~CVisionCallBack ( )
{
}

/******************************************************************************/

HRESULT 
CVisionCallBack::ClientCallback ( ULONG eventFlag, long channel, PVOID pUserdata )
{
   if ( m_pCallBackFn )
   {
      m_pCallBackFn ( eventFlag, channel, pUserdata );
   }

   return S_OK;
}

/******************************************************************************/
