#!/bin/bash    

# GpuTest command line parameters:
# --------------------------------
# /test=<test_name> where test_name = fur | tess_x8 | tess_x16 | tess_x32 | tess_x64 | gi | pixmark_piano | pixmark_volplosion | plot3d | triangle
# /width=<window_width>
# /height=<window_height>
# /fullscreen : sets fullscreen mode
# /msaa=<samples> where samples can be 0, 2, 4, 8
# /benchmark : sets the benchmarking mode
# /benchmark_duration_ms=<duration_in_ms> : benchmark duration in milliseconds.
# /no_scorebox : does not display the score box at the end of the benchmark.
# /no_log_score : does not write score result in the log file at the end of the benchmark.
# /glinfo : write detailed OpenGL information in the log file
# /disable_opengl_support_check : disables the support of correct OpenGL support in some demos (GiMark, TessMark).
# /debug_log_frame_data : writes in the log file additional per frame information: frame number, elapsed time, opengl error code.

# From the terminal, launch this script with:
# sh ./gputest_command_line_example.sh  

# Simple test:
open 'GpuTest.app' --args '/test=tess_x32 /width=1024 /height=640'

# FurMark Benchmark:
# open 'GpuTest.app' --args '/test=fur /width=1280 /height=720 /msaa=4 /benchmark /benchmark_duration_ms=60000'

# GiMark Benchmark:
# open 'GpuTest.app' --args '/test=gi /width=1280 /height=720 /msaa=4 /benchmark /benchmark_duration_ms=60000'

# Volplosion Benchmark:
# open 'GpuTest.app' --args '/test=pixmark_volplosion /width=1280 /height=720 /msaa=0 /benchmark /benchmark_duration_ms=60000'

# Piano Benchmark:
# open 'GpuTest.app' --args '/test=pixmark_piano /width=1280 /height=720 /msaa=0 /benchmark /benchmark_duration_ms=60000'

# Plot3D Benchmark:
# open 'GpuTest.app' --args '/test=plot3d /width=1280 /height=720 /msaa=0 /benchmark /benchmark_duration_ms=60000'

# Triangle Benchmark:
# open 'GpuTest.app' --args '/test=triangle /width=1280 /height=720 /msaa=0 /benchmark /benchmark_duration_ms=60000'
