

# Elapsed time and FPS --------------------------------
#
elapsed_time = gh_utils.get_elapsed_time()
dt = gh_utils.get_time_step()

frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0):
  fps_time = 0
  fps = frames
  frames = 0



# Current screen size  --------------------------------
#
winW, winH = gh_window.getsize(0)


# Mouse position  --------------------------------
#
mouseX, mouseY = gh_input.mouse_get_position()



# Clear the screen --------------------------------
#
gh_renderer.set_depth_test_state(1)
gh_renderer.clear_color_depth_buffers(0.15, 0.15, 0.15, 1, 1.0)




# 3D code START --------------------------------
#

# Camera 3D  ------
#
##if (win_hovered == 0): 
gx_camera.update(camera, dt)

gh_camera.bind(camera)





# Grid rendering
gh_gpu_program.bind(vertex_color_prog0)
#gh_gpu_program.bind(vertex_color_prog_gl3)
gh_renderer.wireframe()
gh_object.render(torus)
gh_renderer.solid()

gh_object.render(grid)


#
# 3D code END --------------------------------






# Display some information --------------------------------
#

libfont_clear()

y_offset = 40

libfont_print(10, y_offset, 1, 1, 0, 1, "FPS: " + str(fps))
y_offset = y_offset + 30

libfont_print(10, y_offset, 1, 1, 0, 1, "GL_RENDERER")
y_offset = y_offset + 20

libfont_print(10, y_offset, 1, 1, 1, 1, "> " + gl_renderer)
y_offset = y_offset + 20

libfont_print(10, y_offset, 1, 1, 0, 1, "GL_VERSION")
y_offset = y_offset + 20

libfont_print(10, y_offset, 1, 1, 1, 1, "> " + gl_version)
y_offset = y_offset + 40

libfont_print(10, y_offset, 0.4, 0.4, 0.4, 1, "Resolution: %d x %d" % (winW, winH))
y_offset = y_offset + 20

libfont_print(10, y_offset, 0.4, 0.4, 0.4, 1, "Mouse: %d x %d" % (mouseX, mouseY))
y_offset = y_offset + 20


libfont_render()





  
# Display some widgets / User Interface --------------------------------
#
imgui_frame_begin()
gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.6)

is_open = imgui_window_begin_pos_size_once("Control panel", 250, 200, 10, 260)
if (is_open == 1):

  win_hovered = gh_imgui.is_window_hovered()

  gh_imgui.text("Hello from Python 3!")

  #gh_imgui.text("vertex_color_prog0 => " + str(vertex_color_prog0))
  #gh_imgui.text("vertex_color_prog_gl3 => " + str(vertex_color_prog_gl3))


imgui_window_end()
imgui_frame_end()

