

local demo_dir = gh_utils.get_demo_dir() 		

local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    
dofile(lib_dir .. "lua/gxl.lua")    



winW, winH = gh_window.getsize(0)



win_hovered = 0




-----------------------------------------------------------------------------
--
orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0

camera = gx_camera.create_perspective(60, 1, 0, 0, winW, winH, 0.1, 1000)
gh_camera.set_position(camera, 0, 0, 8)
gx_camera.init_orientation(camera, 0, 0, 0, 30, 90)

if (orbit_mode == 1) then
  gx_camera.set_mode_orbit()
else
  gx_camera.set_mode_fly()
end

gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)







-----------------------------------------------------------------------------
--
--texture_prog = gh_node.getid("texture_prog")
--*gh_gpu_program.uniform1i(texture_prog, "tex0", 0)

dofile(demo_dir .. "init_shader.lua")





-----------------------------------------------------------------------------
--
local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 1
local compressed_texture = 0

local filename = demo_dir .. "textures/9452-diffuse.jpg"
box_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/10912-diffuse.jpg"
sphere_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/4791-diffuse.jpg"
ground_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)


--filename = demo_dir .. "textures/Bullet_Physics_Library_Logo.png"
--bullet_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)








quad = gh_mesh.create_quad(180, 80)

ground = gh_mesh.create_plane(20, 20, 2, 2)





-- mesh instancing requires separate vertex arrays.
--
--local separate_vertex_arrays = 1
--gh_mesh.set_vertex_alloc_params_separate_vertex_arrays(separate_vertex_arrays)


box_size = 0.5
mesh_box = gh_mesh.create_box(box_size, box_size, box_size, 1, 1, 1)


all_px_boxes = {}
num_boxes = 100
box_rate = 10


physx4_ver = ""

gpu_physx = 0

can_run_sim = 0

px_scene = 0

physx_ok = gh_physx4.start()
if (physx_ok == 1) then
  gh_utils.trace("PhysX 4 started up ok.")
  
  local vmajor, vminor, vpatch = gh_physx4.get_version()
  physx4_ver = string.format("%d.%d.%d", vmajor, vminor, vpatch)

  gpu_physx = gh_physx4.gpu_is_supported()

  gh_physx4.set_solver_iteration_counts(8, 2)


  
  local bounce_threshold_velocity = 2.0
  local enable_ccd = 0;
  local enable_collision_reporting = 0
  local enable_stabilization = 1
  
  px_scene = gh_physx4.create_scene_broadphase_sap(bounce_threshold_velocity, enable_ccd, enable_collision_reporting, enable_stabilization)
  

  gh_physx4.set_scene_gravity(px_scene, 0, -10.0, 0)


  local static_friction = 0.5
  local dynamic_friction = 0.5
  local resilience = 0.4
  px_material_plane = gh_physx4.create_material(static_friction, dynamic_friction, resilience)
  px_actor_plane = gh_physx4.create_actor_plane(px_scene, 0, 1, 0, 0, px_material_plane)

  local material_density = 0.5

  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.1
  px_material_box = gh_physx4.create_material(static_friction, dynamic_friction, resilience)

  local i=0
  for i=0, num_boxes-1 do
    local box = { px_actor_id=0, pos_x=0, pos_y=0, pos_z=0, render=0 }
    local x = 0
    local y = 0
    local z = 0
    box.pos_x = x
    box.pos_y = y
    box.pos_z = z
    box.px_actor_id = gh_physx4.create_actor_box(px_scene, box_size, box_size, box_size, 0, 100 + i*10, 0, material_density, px_material_box)
    gh_physx3.actor_set_linear_damping(box.px_actor_id, 0.05)
    gh_physx3.actor_set_angular_damping(box.px_actor_id, 0.05)
    gh_physx3.actor_set_sleep_threshold(box.px_actor_id, 0.2)
    gh_physx3.actor_put_to_sleep(box.px_actor_id)
    all_px_boxes[i+1] = box
  end

  can_run_sim = 1
    
  gh_utils.trace("PhysX 4 scene/materials/actors init ok.")

else  
  gh_utils.trace("PhysX 4 starting up failed.")

end  





if ((can_run_sim == 1) and (px_scene > 0)) then
  -- Run an initial simulation
  gh_physx4.run_simulation(px_scene, 0.016, 0.016)
end  




last_time = gh_utils.get_elapsed_time()

rate_time = last_time
num_new_boxes_excess = 0
run_sim = 1
box_index = 1

num_boxes_render = 0
num_boxes_sleep = 0
sim_dt = 0
sim_fixed_time_step = 1.0/60.0 --16ms

gh_renderer.set_vsync(0)


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0





