    

function UpdateParticles(time)
  local dt = time - last_particle_time
  if ((particles_index < num_particles-2) and (dt > 0.001)) then
    last_particle_time = time
    
    local i = particles_index
    local k = 1
    if (particles_index == 1) then
      k = num_particles_render
    end
    
    local px=0
    local py=0
    local pz=0
      
    local p = last_position
    
    -- Lorenz equations
    --
    local S = 10.0
    local R = 28.0
    local B = 8/3
    --local S = 10
    --local R = 30
    --local B = 4.5
    local dx = (S * (p.y-p.x))
    local dy = ((-p.z*p.x) + (R*p.x) - p.y)
    local dz = ((p.x*p.y) - (B*p.z))
    
      
    p.x = p.x + dx * dt
    p.y = p.y + dy * dt 
    p.z = p.z + dz * dt 
    
    last_position = p
  
    gh_vertex_pool.vertex_set_position(vp, i-1, p.x*1.5, p.y*1.5, p.z*1.5-40.0, 1)

    local c = i/num_particles
    gh_vertex_pool.vertex_set_color(vp, i-1, 1, c*0.5, 0, alpha)
    --gh_vertex_pool.vertex_set_color(vp, i-1, 1, 1, 1, 1)
    
  
    particles_index = particles_index + 1
    if (particles_index > num_particles) then
      particles_index = 1
    end 
    
    num_particles_render = num_particles_render + 1
    if (num_particles_render > num_particles) then
      num_particles_render = num_particles
    end 
    
  end
end  

    

local elapsed_time = gh_utils.get_elapsed_time()
local dt = elapsed_time - last_time
last_time = elapsed_time



UpdateParticles(elapsed_time)


gx_camera.update(camera, dt)
gh_camera.bind(camera) 



gh_renderer.set_viewport_scissor(0, 0, winW, winH)
gh_renderer.clear_color_depth_buffers(0.0, 0.15, 0.2, 1.0, 1.0) 


gh_renderer.set_depth_test_state(1)
gh_renderer.set_depth_buffer_writing_state(0)




gh_renderer.set_blending_state(1)
local BLEND_FACTOR_ONE = 1
local BLEND_FACTOR_SRC_ALPHA = 2
gh_renderer.set_blending_factors(BLEND_FACTOR_SRC_ALPHA, BLEND_FACTOR_ONE)

-- local BLEND_FACTOR_ONE_MINUS_SRC_COLOR = 9
-- local BLEND_FACTOR_SRC_COLOR = 8
-- gh_renderer.set_blending_factors(BLEND_FACTOR_ONE_MINUS_SRC_COLOR, BLEND_FACTOR_SRC_COLOR)


gh_texture.bind(tex01, 0)


gh_gpu_program.bind(particle_prog)
gh_gpu_program.uniform1f(particle_prog, "point_size", 80.0)

-- gh_object.set_euler_angles(vp, 0, 90, )
gh_vertex_pool.render(vp, 0, num_particles_render-1)

gh_renderer.set_depth_buffer_writing_state(1)
gh_renderer.set_depth_test_state(1)
gh_renderer.set_blending_state(0)


gh_gpu_program.bind(color_prog)
gh_object.render(grid)



