
local demo_dir = gh_utils.get_demo_dir()
local lib_dir = gh_utils.get_lib_dir() 		

dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    






winW, winH = gh_window.getsize(0)


win_hovered = 0





-- A 2D camera. In this demo, there will be only 2D rendering.
--
camera_ortho = gh_camera.create_ortho(-winW/2, winW/2, -winH/2, winH/2, 1.0, 10.0)
gh_camera.set_viewport(camera_ortho, 0, 0, winW, winH)
gh_camera.set_position(camera_ortho, 0, 0, 4)






-- The mega color shader!
--
color_prog = gh_node.getid("color_prog")
gh_gpu_program.uniform4f(color_prog, "color", 1, 1, 1, 1)




--
-- Box2D works in MKS units (Meter / Kilogram / Second). For objects size, one unit is one meter.
-- Then if you create a quad with create_quad(10, 10) you will get a 10x10 meter quad in BoX2D.
-- It's not a problem for Box2D but it's a big quad and don't expect it will move fast like a small object.
-- A big object like in reality, will move slowly (for example if it is falling from a 100 meters tower).
-- To deal with graphics rendering, we will decouple the physics size and 3D/2D rendering size and we will use
-- a rendering_scale factor. So a 2x2 meters Box2D obstacle will be rendered with a 20x20 quad if the rendering_scale=10.
--
-- All rendering details can be found in the FRAME script after the world_step_simulation() call.
-- 
rendering_scale = 10.0
world_y_offset = -200




-- The ground: 100m x 2m
--
ground_size = {x=20.0, y=0.5}
ground = gh_mesh.create_quad(ground_size.x, ground_size.y)



-- A box shaped bullet: 2m x 2m (a big box!)
--
box_size = {x=1.0, y=1.0}
box = gh_mesh.create_quad(box_size.x, box_size.y)









gh_renderer.set_vsync(0)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0


run_simulation = 1
reset_simulation = 0

wireframe = 0



------------------------------------------------------------------------------
-- Box2D Physcis 
------------------------------------------------------------------------------


function deg2rad(deg)
  return deg*3.14159265/180.0
end

function rad2deg(rad)
  return rad*180.0/3.14159265
end


box2d_version = {major=0, minor=0, revision=0}

box2d_version.major, box2d_version.minor, box2d_version.revision = gh_box2d.get_version()


-- Like other physics engines, Box2D does not like variable time step for the simulation.
-- So we will run a simulation every 1/60 second and no more. The number of simulations is not linked
-- to the framerate.
--
sim_time = 0
sim_dt = 1.0/60.0



-- Inits the Box2D engine.
gh_box2d.init()


-- Creates a scene
b2_world = gh_box2d.world_init()


-- Sets the gravity
world_gravity = {x=0, y=-10}
gh_box2d.world_set_gravity(b2_world, world_gravity.x, world_gravity.y)




local density = 0.0
local friction = 0.6
local restitution = 0.1

b2_ground = gh_box2d.world_create_actor_box(b2_world, 0, -ground_size.y/2,    ground_size.x/2, ground_size.y/2,    "static", 0, 1.0, restitution)



density = 1000.0
friction = 0.4
restitution = 0.05



-- the box.
--
b2_box = gh_box2d.world_create_actor_box(b2_world, 0, 10,    box_size.x/2, box_size.y/2,   "dynamic", density, friction, restitution)
gh_box2d.actor_set_damping(b2_box, 0.0, 0.1)
gh_box2d.actor_set_transform(b2_box, 0, 10,   deg2rad(30.0))
gh_box2d.actor_set_linear_velocity(b2_box, 0.0, 0.0)
gh_box2d.actor_set_angular_velocity(b2_box, deg2rad(0.0))
-- Sleeping is not allowed here!!!!
gh_box2d.actor_set_sleeping_allowed(b2_box, 0)



contact_actor_id = 0
cpx = 0
cpy = 0
num_contacts = 0
