
local demo_dir = gh_utils.get_demo_dir()
    
local lib_dir = gh_utils.get_scripting_libs_dir() 		
dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    
dofile(lib_dir .. "lua/gxl.lua")  


winW, winH = gh_window.getsize(0)


win_hovered = 0


camera_ortho = gxl.create_camera_2d(winW, winH, 1.0, 10.0)



color_prog = gh_node.getid("color_prog")
gh_gpu_program.uniform4f(color_prog, "color", 1, 1, 1, 1)


--[[
texture_prog = gh_node.getid("texture_prog")
gh_gpu_program.uniform1i(texture_prog, "tex0", 0)


local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 1
local compressed_texture = 0

local filename = demo_dir .. "textures/20190201-ROG-mechanical-eye.jpg"
tex0 = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

quad = gh_mesh.create_quad(winW*0.8, winH*0.8)
--]]



bgcolor = {r=19/255, g=53/255, b=96/255, a=1}


gh_renderer.set_vsync(1)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0




function update_curve_v1(curve, t)
	local PI = 3.14159265
	local step_angle = (2.0*PI) / curve.num_vertices
	local angle = 0
	local x = -curve.x_size/2.0
	local x_step = curve.x_size / curve.num_vertices
	for i=0, curve.num_vertices-1 do
		local y = math.sin(angle * curve.frequency + t) * 5.0
		y = y * curve.amplitude
		angle = angle + step_angle
		gh_polyline.set_vertex_position(curve.line, i, x, y, 0, 1)
		x = x + x_step
	end
end



function update_curve_v2(curve, t)
	local PI = 3.14159265
	local step_angle = (2.0*PI) / curve.num_vertices
	local angle = 0
	local x = -curve.x_size/2.0
	local x_step = curve.x_size / curve.num_vertices
	for i=0, curve.num_vertices-1 do
		local y = math.sin(angle * curve.frequency)
		-- y = y + math.sin(angle * curve.frequency * 2.1 + t) * 4.5
		-- y = y + math.sin(angle * curve.frequency * 1.72 + t*1.121) * 4.0
		-- y = y + math.sin(angle * curve.frequency * 2.221 + t*0.437) * 5.0
		-- y = y + math.sin(angle * curve.frequency * 3.1122 + t*4.269) * 2.5

		y = y + math.sin(angle * curve.frequency * curve.f1 + t*curve.t1) * curve.a1
		y = y + math.sin(angle * curve.frequency * curve.f2 + t*curve.t2) * curve.a2
		y = y + math.sin(angle * curve.frequency * curve.f3 + t*curve.t3) * curve.a3
		y = y + math.sin(angle * curve.frequency * curve.f4 + t*curve.t4) * curve.a4

		y = y * curve.amplitude
		angle = angle + step_angle
		gh_polyline.set_vertex_position(curve.line, i, x, y, 0, 1)
		x = x + x_step
	end
end


function draw_curve(curve, prog)
	gh_gpu_program.uniform4f(prog, "color", curve.color.r, curve.color.g, curve.color.b, curve.color.a)
	gh_object.render(curve.line)
end	


function reset_curve_params(curve)
	curve.amplitude = 10.0
	curve.frequency = 3.0

	curve.f1 = 2.1
	curve.t1 = 1.0
	curve.a1 = 4.5

	curve.f2 = 1.72
	curve.t2 = 1.121
	curve.a2 = 4.0

	curve.f3 = 2.221
	curve.t3 = 0.437
	curve.a3 = 5.0

	curve.f4 = 3.1122
	curve.t4 = 4.269
	curve.a4 = 2.5
end


curve = {
	line = 0,
	num_vertices = 1000,
	x_size = winW * 0.9,
	color = {r=91/255, g=200/255, b=1.0, a=1.0},

	amplitude = 10.0,
	frequency = 3.0,

	f1 = 2.1,
	t1 = 1.0,
	a1 = 4.5,

	f2 = 1.72,
	t2 = 1.121,
	a2 = 4.0,

	f3 = 2.221,
	t3 = 0.437,
	a3 = 5.0,

	f4 = 3.1122,
	t4 = 4.269,
	a4 = 2.5,
}

local LINE_RENDER_DEFAULT = 0 
local LINE_RENDER_STRIP = 1 
local LINE_RENDER_LOOP = 2
local line_mode = LINE_RENDER_STRIP

curve.line = gh_polyline.create_v2(curve.num_vertices, line_mode)
gh_polyline.set_vertices_color_v2(curve.line, 1, 1, 1, 1)


	
wave_type = 2

